/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.AbortedException;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalChannel;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.core.ExchangeImpl;

public class ChannelImpl
implements InternalChannel {
    private static final Log LOG = LogFactory.getLog(ChannelImpl.class);
    private final InternalEndpoint endpoint;
    private final Executor executor;
    private final NMR nmr;
    private String name;

    public ChannelImpl(InternalEndpoint endpoint, Executor executor, NMR nmr) {
        this.endpoint = endpoint;
        this.executor = executor;
        this.nmr = nmr;
        Map props = nmr.getEndpointRegistry().getProperties((Object)endpoint);
        if (props != null) {
            this.name = (String)props.get("NAME");
        }
        if (this.name == null) {
            this.name = this.toString();
        }
    }

    public NMR getNMR() {
        return this.nmr;
    }

    public InternalEndpoint getEndpoint() {
        return this.endpoint;
    }

    public Exchange createExchange(Pattern pattern) {
        return new ExchangeImpl(pattern);
    }

    public void send(Exchange exchange) {
        InternalExchange e = (InternalExchange)exchange;
        this.dispatch(e);
    }

    public boolean sendSync(Exchange exchange) {
        return this.sendSync(exchange, 0L);
    }

    public boolean sendSync(Exchange exchange, long timeout) {
        InternalExchange e = (InternalExchange)exchange;
        Semaphore lock = e.getRole() == Role.Consumer ? e.getConsumerLock(true) : e.getProviderLock(true);
        try {
            this.dispatch(e);
            if (timeout > 0L) {
                if (!lock.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException();
                }
            } else {
                lock.acquire();
            }
            e.setRole(e.getRole() == Role.Consumer ? Role.Provider : Role.Consumer);
        }
        catch (InterruptedException ex) {
            exchange.setError((Exception)ex);
            exchange.setStatus(Status.Error);
            return false;
        }
        catch (TimeoutException ex) {
            exchange.setError((Exception)new AbortedException((Throwable)ex));
            exchange.setStatus(Status.Error);
            return false;
        }
        return true;
    }

    public void close() {
        Map props = this.nmr.getEndpointRegistry().getProperties((Object)this.endpoint);
        this.nmr.getEndpointRegistry().unregister((Endpoint)this.endpoint, props);
    }

    public void deliver(final InternalExchange exchange) {
        Semaphore lock;
        Semaphore semaphore = lock = exchange.getRole() == Role.Provider ? exchange.getConsumerLock(false) : exchange.getProviderLock(false);
        if (lock != null) {
            lock.release();
            return;
        }
        this.executor.execute(new Runnable(){

            public void run() {
                ChannelImpl.this.process(exchange);
            }
        });
    }

    protected void process(InternalExchange exchange) {
        if (exchange.getError() instanceof AbortedException) {
            return;
        }
        if (exchange.getDestination() == null) {
            exchange.setDestination(this.endpoint);
        }
        exchange.setRole(exchange.getRole() == Role.Provider ? Role.Consumer : Role.Provider);
        for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
            l.exchangeDelivered((Exchange)exchange);
        }
        this.endpoint.process((Exchange)exchange);
    }

    protected void dispatch(InternalExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Channel " + this.name + " dispatching exchange " + exchange));
        }
        if (exchange.getSource() == null) {
            exchange.setSource(this.endpoint);
        }
        for (ExchangeListener l : this.nmr.getListenerRegistry().getListeners(ExchangeListener.class)) {
            l.exchangeSent((Exchange)exchange);
        }
        this.nmr.getFlowRegistry().dispatch(exchange);
    }
}

