/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.jbi.JBIException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.servicemix.jbi.runtime.impl.AbstractComponentContext;
import org.apache.servicemix.jbi.runtime.impl.ComponentRegistryImpl;
import org.apache.servicemix.jbi.runtime.impl.DeliveryChannelImpl;
import org.apache.servicemix.jbi.runtime.impl.EndpointImpl;
import org.apache.servicemix.jbi.runtime.impl.utils.DOMUtil;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.Exchange;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContextImpl
extends AbstractComponentContext {
    public static final int DEFAULT_QUEUE_CAPACITY = 100;
    private static final Log LOG = LogFactory.getLog(ComponentContextImpl.class);
    protected ComponentWrapper component;
    protected Map<String, ?> properties;
    protected BlockingQueue<Exchange> queue;
    protected EndpointImpl componentEndpoint;
    protected String name;
    protected File workspaceRoot;
    protected File installRoot;

    public ComponentContextImpl(ComponentRegistryImpl componentRegistry, ComponentWrapper component, Map<String, ?> properties) {
        super(componentRegistry);
        this.component = component;
        this.properties = properties;
        this.queue = new ArrayBlockingQueue<Exchange>(100);
        this.componentEndpoint = new EndpointImpl();
        this.componentEndpoint.setQueue(this.queue);
        this.componentRegistry.getNmr().getEndpointRegistry().register((Endpoint)this.componentEndpoint, properties);
        this.dc = new DeliveryChannelImpl(this, this.componentEndpoint.getChannel(), this.queue);
        this.name = (String)properties.get("NAME");
        this.workspaceRoot = new File(System.getProperty("servicemix.base"), "data/jbi/" + this.name + "/workspace");
        this.workspaceRoot.mkdirs();
        this.installRoot = new File(System.getProperty("servicemix.base"), "data/jbi/" + this.name + "/install");
        this.installRoot.mkdirs();
    }

    public synchronized ServiceEndpoint activateEndpoint(QName serviceName, String endpointName) throws JBIException {
        try {
            EndpointImpl endpoint = new EndpointImpl();
            endpoint.setQueue(this.queue);
            endpoint.setServiceName(serviceName);
            endpoint.setEndpointName(endpointName);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("NAME", serviceName.toString() + ":" + endpointName);
            props.put("SERVICE_NAME", serviceName);
            props.put("ENDPOINT_NAME", endpointName);
            Document doc = this.component.getComponent().getServiceDescription((ServiceEndpoint)endpoint);
            if (doc != null) {
                String data = DOMUtil.asXML(doc);
                String url = this.componentRegistry.getDocumentRepository().register(data.getBytes());
                props.put("WSDL_URL", url);
            }
            this.componentRegistry.getNmr().getEndpointRegistry().register((Endpoint)endpoint, props);
            return new AbstractComponentContext.SimpleServiceEndpoint(props, endpoint);
        }
        catch (TransformerException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public synchronized void deactivateEndpoint(ServiceEndpoint endpoint) throws JBIException {
        EndpointImpl ep;
        if (endpoint instanceof EndpointImpl) {
            ep = (EndpointImpl)endpoint;
        } else if (endpoint instanceof AbstractComponentContext.SimpleServiceEndpoint) {
            ep = ((AbstractComponentContext.SimpleServiceEndpoint)endpoint).getEndpoint();
        } else {
            throw new IllegalArgumentException("Unrecognized endpoint");
        }
        this.componentRegistry.getNmr().getEndpointRegistry().unregister((Endpoint)ep, null);
    }

    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
    }

    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException {
    }

    public String getComponentName() {
        return this.name;
    }

    public String getInstallRoot() {
        return this.installRoot.getAbsolutePath();
    }

    public String getWorkspaceRoot() {
        return this.workspaceRoot.getAbsolutePath();
    }

    public ComponentWrapper getComponent() {
        return this.component;
    }
}

