/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.core.CamelConverter;
import org.apache.servicemix.nmr.core.Converter;
import org.apache.servicemix.nmr.core.DummyConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
implements Message {
    private static final long serialVersionUID = -8621182821298293687L;
    private Object body;
    private String contentType;
    private String contentEncoding;
    private Subject securitySubject;
    private Map<String, Object> headers;
    private Map<String, Object> attachments;
    private transient Converter converter;

    public Object getBody() {
        return this.body;
    }

    public <T> T getBody(Class<T> type) {
        return this.convert(this.body, type);
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public <T> void setBody(Object content, Class<T> type) {
        T t = this.convert(content, type);
        this.body = t != null ? t : content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String encoding) {
        this.contentEncoding = encoding;
    }

    public Subject getSecuritySubject() {
        return this.securitySubject;
    }

    public void setSecuritySubject(Subject securitySubject) {
        this.securitySubject = securitySubject;
    }

    public Object getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    public <T> T getHeader(String name, Class<T> type) {
        if (this.headers == null) {
            return null;
        }
        return this.convert(this.headers.get(name), type);
    }

    public <T> T getHeader(Class<T> type) {
        if (this.headers == null) {
            return null;
        }
        return this.convert(this.headers.get(type.getName()), type);
    }

    public void setHeader(String name, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(name, value);
    }

    public <T> void setHeader(Class<T> type, T value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(type.getName(), this.convert(value, type));
    }

    public Object removeHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.remove(name);
    }

    public <T> T removeHeader(Class<T> type) {
        return this.convert(this.removeHeader(type.getName()), type);
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public Object getAttachment(String id) {
        if (this.attachments == null) {
            return null;
        }
        return this.attachments.get(id);
    }

    public void addAttachment(String id, Object value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>();
        }
        this.attachments.put(id, value);
    }

    public void removeAttachment(String id) {
        if (this.attachments != null) {
            this.attachments.remove(id);
        }
    }

    public Map<String, Object> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>();
        }
        return this.attachments;
    }

    public void ensureReReadable() {
    }

    public void copyFrom(Message msg) {
        this.body = msg.getBody();
        if (!msg.getHeaders().isEmpty()) {
            this.headers = new HashMap<String, Object>();
            for (Map.Entry e : msg.getHeaders().entrySet()) {
                this.headers.put((String)e.getKey(), e.getValue());
            }
        } else {
            this.headers = null;
        }
        if (!msg.getAttachments().isEmpty()) {
            this.attachments = new HashMap<String, Object>();
            for (Map.Entry e : msg.getAttachments().entrySet()) {
                this.attachments.put((String)e.getKey(), e.getValue());
            }
        } else {
            this.attachments = null;
        }
    }

    public Message copy() {
        MessageImpl copy = new MessageImpl();
        copy.copyFrom(this);
        return copy;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.ensureReReadable();
        out.defaultWriteObject();
    }

    private <T> T convert(Object body, Class<T> type) {
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        if (this.converter == null) {
            try {
                this.converter = new CamelConverter();
            }
            catch (Throwable t) {
                this.converter = new DummyConverter();
            }
        }
        return this.converter.convert(body, type);
    }

    public String display(boolean displayContent) {
        if (displayContent) {
            this.ensureReReadable();
        }
        return "Message []";
    }

    public String toString() {
        return this.display(true);
    }
}

