/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.ServiceMixException;
import org.apache.servicemix.nmr.api.event.EndpointListener;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.service.ServiceRegistry;
import org.apache.servicemix.nmr.core.ChannelImpl;
import org.apache.servicemix.nmr.core.DynamicReferenceImpl;
import org.apache.servicemix.nmr.core.InternalEndpointWrapper;
import org.apache.servicemix.nmr.core.ServiceRegistryImpl;
import org.apache.servicemix.nmr.core.util.Filter;
import org.apache.servicemix.nmr.core.util.MapToDictionary;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRegistryImpl
implements EndpointRegistry {
    private NMR nmr;
    private ConcurrentMap<Endpoint, InternalEndpoint> endpoints = new ConcurrentHashMap<Endpoint, InternalEndpoint>();
    private Map<InternalEndpoint, Endpoint> wrappers = new ConcurrentHashMap<InternalEndpoint, Endpoint>();
    private Map<DynamicReferenceImpl, Boolean> references = new WeakHashMap<DynamicReferenceImpl, Boolean>();
    private ServiceRegistry<InternalEndpoint> registry;

    public EndpointRegistryImpl() {
    }

    public EndpointRegistryImpl(NMR nmr) {
        this.nmr = nmr;
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public ServiceRegistry<InternalEndpoint> getRegistry() {
        return this.registry;
    }

    public void setRegistry(ServiceRegistry<InternalEndpoint> registry) {
        this.registry = registry;
    }

    public void init() {
        if (this.nmr == null) {
            throw new NullPointerException("nmr must be not null");
        }
        if (this.registry == null) {
            this.registry = new ServiceRegistryImpl<InternalEndpoint>();
        }
    }

    public void register(Endpoint endpoint, Map<String, ?> properties) {
        InternalEndpointWrapper wrapper = new InternalEndpointWrapper(endpoint);
        if (this.endpoints.putIfAbsent(endpoint, wrapper) == null) {
            ExecutorService executor = Executors.newCachedThreadPool();
            ChannelImpl channel = new ChannelImpl(wrapper, executor, this.nmr);
            wrapper.setChannel((Channel)channel);
            this.wrappers.put(wrapper, endpoint);
            this.registry.register((Object)wrapper, properties);
            for (EndpointListener listener : this.nmr.getListenerRegistry().getListeners(EndpointListener.class)) {
                listener.endpointRegistered((InternalEndpoint)wrapper);
            }
            for (DynamicReferenceImpl ref : this.references.keySet()) {
                ref.setDirty();
            }
        }
    }

    public void unregister(Endpoint endpoint, Map<String, ?> properties) {
        InternalEndpoint wrapper;
        if (endpoint instanceof InternalEndpoint) {
            wrapper = (InternalEndpoint)endpoint;
            if (wrapper != null && (endpoint = this.wrappers.remove(wrapper)) != null) {
                this.endpoints.remove(endpoint);
            }
        } else {
            wrapper = (InternalEndpoint)this.endpoints.remove(endpoint);
            if (wrapper != null) {
                this.wrappers.remove(wrapper);
            }
        }
        if (wrapper != null) {
            this.registry.unregister((Object)wrapper, properties);
            for (EndpointListener listener : this.nmr.getListenerRegistry().getListeners(EndpointListener.class)) {
                listener.endpointUnregistered(wrapper);
            }
        }
        for (DynamicReferenceImpl ref : this.references.keySet()) {
            ref.setDirty();
        }
    }

    public Set<Endpoint> getServices() {
        return this.registry.getServices();
    }

    public Map<String, ?> getProperties(Endpoint endpoint) {
        InternalEndpoint wrapper = endpoint instanceof InternalEndpoint ? (InternalEndpoint)endpoint : (InternalEndpoint)this.endpoints.get(endpoint);
        return this.registry.getProperties((Object)wrapper);
    }

    public List<Endpoint> query(Map<String, ?> properties) {
        return this.internalQuery(properties);
    }

    public Reference lookup(final Map<String, ?> properties) {
        DynamicReferenceImpl ref = new DynamicReferenceImpl(this, new Filter<InternalEndpoint>(){

            @Override
            public boolean match(InternalEndpoint endpoint) {
                Map epProps = EndpointRegistryImpl.this.registry.getProperties((Object)endpoint);
                for (Map.Entry name : properties.entrySet()) {
                    if (name.getValue().equals(epProps.get(name.getKey()))) continue;
                    return false;
                }
                return true;
            }
        });
        this.references.put(ref, true);
        return ref;
    }

    public synchronized Reference lookup(Document xml) {
        return null;
    }

    public Reference lookup(String filter) {
        try {
            try {
                final org.osgi.framework.Filter flt = FrameworkUtil.createFilter((String)filter);
                DynamicReferenceImpl ref = new DynamicReferenceImpl(this, new Filter<InternalEndpoint>(){

                    @Override
                    public boolean match(InternalEndpoint endpoint) {
                        Map<String, ?> props = EndpointRegistryImpl.this.getProperties((Endpoint)endpoint);
                        return flt.match((Dictionary)new MapToDictionary(props));
                    }
                });
                this.references.put(ref, true);
                return ref;
            }
            catch (InvalidSyntaxException e) {
                throw new ServiceMixException("Invalid filter syntax: " + e.getMessage());
            }
        }
        catch (NoClassDefFoundError e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected List<InternalEndpoint> internalQuery(Map<String, ?> properties) {
        ArrayList<InternalEndpoint> endpoints = new ArrayList<InternalEndpoint>();
        if (properties == null) {
            endpoints.addAll(this.registry.getServices());
        } else {
            for (InternalEndpoint e : this.registry.getServices()) {
                boolean match = true;
                for (String name : properties.keySet()) {
                    if (properties.get(name).equals(this.registry.getProperties((Object)e).get(name))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                endpoints.add(e);
            }
        }
        return endpoints;
    }
}

