/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import javax.xml.namespace.QName;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.Type;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.core.CamelConverter;
import org.apache.servicemix.nmr.core.Converter;
import org.apache.servicemix.nmr.core.DummyConverter;
import org.apache.servicemix.nmr.core.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeImpl
implements InternalExchange {
    private static final long serialVersionUID = 5453128544624717320L;
    private String id;
    private Status status;
    private Role role;
    private Pattern pattern;
    private Reference target;
    private QName operation;
    private Map<String, Object> properties;
    private Message in;
    private Message out;
    private Message fault;
    private Exception error;
    private InternalEndpoint source;
    private InternalEndpoint destination;
    private Semaphore consumerLock;
    private Semaphore providerLock;
    private transient Converter converter;

    public ExchangeImpl(Pattern pattern) {
        this.id = UUID.randomUUID().toString();
        this.status = Status.Active;
        this.role = Role.Consumer;
        this.pattern = pattern;
    }

    private ExchangeImpl() {
    }

    public String getId() {
        return this.id;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Reference getTarget() {
        return this.target;
    }

    public void setTarget(Reference target) {
        this.target = target;
    }

    public QName getOperation() {
        return this.operation;
    }

    public void setOperation(QName operation) {
        this.operation = operation;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public <T> T getProperty(String name, Class<T> type) {
        if (this.properties == null) {
            return null;
        }
        return this.convert(this.properties.get(name), type);
    }

    public <T> T getProperty(Class<T> type) {
        if (this.properties == null) {
            return null;
        }
        return this.convert(this.properties.get(type.getName()), type);
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public <T> void setProperty(Class<T> type, T value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(type.getName(), this.convert(value, type));
    }

    public Object removeProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.remove(name);
    }

    public <T> T removeProperty(Class<T> type) {
        return this.convert(this.removeProperty(type.getName()), type);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Message getIn() {
        return this.getIn(true);
    }

    public Message getIn(boolean lazyCreate) {
        if (this.in == null && lazyCreate) {
            this.in = this.createMessage();
        }
        return this.in;
    }

    public void setIn(Message message) {
        this.in = message;
    }

    public Message getOut() {
        return this.getOut(true);
    }

    public Message getOut(boolean lazyCreate) {
        if (this.out == null && lazyCreate && this.pattern != Pattern.InOnly && this.pattern != Pattern.RobustInOnly) {
            this.out = this.createMessage();
        }
        return this.out;
    }

    public void setOut(Message message) {
        this.out = message;
    }

    public Message getFault() {
        return this.getFault(true);
    }

    public Message getFault(boolean lazyCreate) {
        if (this.fault == null && lazyCreate && this.pattern != Pattern.InOnly) {
            this.fault = this.createMessage();
        }
        return this.fault;
    }

    public void setFault(Message message) {
        this.fault = message;
    }

    public Message getMessage(Type type) {
        return this.getMessage(type, true);
    }

    public Message getMessage(Type type, boolean lazyCreate) {
        switch (type) {
            case In: {
                return this.getIn(lazyCreate);
            }
            case Out: {
                return this.getOut(lazyCreate);
            }
            case Fault: {
                return this.getFault(lazyCreate);
            }
        }
        throw new IllegalArgumentException();
    }

    public void setMessage(Type type, Message message) {
        switch (type) {
            case In: {
                this.setIn(message);
                break;
            }
            case Out: {
                this.setOut(message);
                break;
            }
            case Fault: {
                this.setFault(message);
            }
        }
    }

    protected Message createMessage() {
        return new MessageImpl();
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
        this.status = Status.Error;
    }

    public void ensureReReadable() {
        if (this.in != null) {
            this.in.ensureReReadable();
        }
        if (this.out != null) {
            this.out.ensureReReadable();
        }
        if (this.fault != null) {
            this.fault.ensureReReadable();
        }
    }

    public void copyFrom(Exchange exchange) {
        this.error = exchange.getError();
        if (exchange.getIn(false) != null) {
            this.in = exchange.getIn().copy();
        }
        if (exchange.getOut(false) != null) {
            this.out = exchange.getOut().copy();
        }
        if (exchange.getFault(false) != null) {
            this.fault = exchange.getFault().copy();
        }
        this.pattern = exchange.getPattern();
        this.properties = new HashMap<String, Object>(exchange.getProperties());
        this.role = exchange.getRole();
        this.target = exchange.getTarget();
    }

    public Exchange copy() {
        ExchangeImpl copy = new ExchangeImpl();
        copy.copyFrom((Exchange)this);
        return copy;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.ensureReReadable();
        out.defaultWriteObject();
    }

    public String display(boolean displayContent) {
        if (displayContent) {
            this.ensureReReadable();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Exchange [");
        sb.append("id=").append(this.id);
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        return this.display(true);
    }

    public InternalEndpoint getSource() {
        return this.source;
    }

    public void setSource(InternalEndpoint source) {
        this.source = source;
    }

    public InternalEndpoint getDestination() {
        return this.destination;
    }

    public void setDestination(InternalEndpoint destination) {
        this.destination = destination;
    }

    public Semaphore getConsumerLock(boolean create) {
        if (create) {
            this.consumerLock = new Semaphore(0);
        }
        return this.consumerLock;
    }

    public Semaphore getProviderLock(boolean create) {
        if (create) {
            this.providerLock = new Semaphore(0);
        }
        return this.providerLock;
    }

    private <T> T convert(Object body, Class<T> type) {
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        if (this.converter == null) {
            try {
                this.converter = new CamelConverter();
            }
            catch (Throwable t) {
                this.converter = new DummyConverter();
            }
        }
        return this.converter.convert(body, type);
    }
}

