/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.DeployedAssembly;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.DescriptorFactory;
import org.apache.servicemix.jbi.deployer.descriptor.Identification;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceAssemblyDesc;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryDesc;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryList;
import org.apache.servicemix.jbi.deployer.descriptor.Target;
import org.apache.servicemix.jbi.deployer.impl.AbstractBundleWatcher;
import org.apache.servicemix.jbi.deployer.impl.ComponentImpl;
import org.apache.servicemix.jbi.deployer.impl.FileUtil;
import org.apache.servicemix.jbi.deployer.impl.PendingException;
import org.apache.servicemix.jbi.deployer.impl.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.impl.ServiceUnitImpl;
import org.apache.servicemix.jbi.deployer.impl.SharedLibraryImpl;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.xbean.classloader.MultiParentClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.osgi.util.OsgiStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployer
extends AbstractBundleWatcher {
    public static final String NAME = "NAME";
    public static final String TYPE = "TYPE";
    private static final Log LOGGER = LogFactory.getLog(Deployer.class);
    private static final String JBI_DESCRIPTOR = "META-INF/jbi.xml";
    private Map<String, SharedLibraryImpl> sharedLibraries = new ConcurrentHashMap<String, SharedLibraryImpl>();
    private Map<String, ServiceAssemblyImpl> serviceAssemblies = new ConcurrentHashMap<String, ServiceAssemblyImpl>();
    private Map<String, ComponentImpl> components = new ConcurrentHashMap<String, ComponentImpl>();
    private Map<String, Boolean> wrappedComponents = new ConcurrentHashMap<String, Boolean>();
    private Map<Bundle, List<ServiceRegistration>> services = new ConcurrentHashMap<Bundle, List<ServiceRegistration>>();
    private List<Bundle> pendingBundles = new ArrayList<Bundle>();
    private File jbiRootDir = new File(System.getProperty("servicemix.base"), "data/jbi");
    private PreferencesService preferencesService;
    private boolean autoStart = true;
    private ServiceTracker tracker;
    private ServiceTracker deployedAssembliesTracker;

    public Deployer() throws JBIException {
        this.jbiRootDir.mkdirs();
    }

    public PreferencesService getPreferencesService() {
        return this.preferencesService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.tracker = new ServiceTracker(this.getBundleContext(), javax.jbi.component.Component.class.getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                Object o = super.addingService(serviceReference);
                Deployer.this.maybeWrapComponent(serviceReference, (javax.jbi.component.Component)o);
                return o;
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                Deployer.this.maybeUnwrapComponent(serviceReference, (javax.jbi.component.Component)o);
                super.removedService(serviceReference, o);
            }
        };
        this.tracker.open();
        this.deployedAssembliesTracker = new ServiceTracker(this.getBundleContext(), DeployedAssembly.class.getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                Object o = super.addingService(serviceReference);
                Deployer.this.registerDeployedServiceAssembly(serviceReference, (DeployedAssembly)o);
                return o;
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                Deployer.this.unregisterDeployedServiceAssembly(serviceReference, (DeployedAssembly)o);
                super.removedService(serviceReference, o);
            }
        };
        this.deployedAssembliesTracker.open();
    }

    @Override
    public void destroy() throws Exception {
        this.tracker.close();
        this.deployedAssembliesTracker.close();
        super.destroy();
    }

    @Override
    protected boolean match(Bundle bundle) {
        LOGGER.debug((Object)("Checking bundle: '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "'"));
        URL url = bundle.getResource(JBI_DESCRIPTOR);
        if (url == null) {
            LOGGER.debug((Object)("Bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' does not contain any JBI descriptor."));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void register(Bundle bundle) {
        block10: {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                URL url = bundle.getResource(JBI_DESCRIPTOR);
                Descriptor descriptor = DescriptorFactory.buildDescriptor(url);
                DescriptorFactory.checkDescriptor(descriptor);
                if (descriptor.getComponent() != null) {
                    this.installComponent(descriptor.getComponent(), bundle);
                    break block10;
                }
                if (descriptor.getServiceAssembly() != null) {
                    this.deployServiceAssembly(descriptor.getServiceAssembly(), bundle);
                    break block10;
                }
                if (descriptor.getSharedLibrary() != null) {
                    this.installSharedLibrary(descriptor.getSharedLibrary(), bundle);
                    break block10;
                }
                throw new IllegalStateException("Unrecognized JBI descriptor: " + url);
            }
            catch (PendingException e) {
                this.pendingBundles.add(e.getBundle());
                LOGGER.warn((Object)("Requirements not met for JBI artifact in bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + ". Installation pending. " + e));
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error handling bundle start event", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    @Override
    protected void unregister(Bundle bundle) {
        this.pendingBundles.remove(bundle);
        List<ServiceRegistration> registrations = this.services.remove(bundle);
        if (registrations != null) {
            for (ServiceRegistration reg : registrations) {
                try {
                    reg.unregister();
                }
                catch (IllegalStateException e) {}
            }
        }
        try {
            URL url = bundle.getResource(JBI_DESCRIPTOR);
            Descriptor descriptor = DescriptorFactory.buildDescriptor(url);
            if (descriptor.getComponent() != null) {
                this.uninstallComponent(descriptor.getComponent(), bundle);
            } else if (descriptor.getServiceAssembly() != null) {
                this.undeployServiceAssembly(descriptor.getServiceAssembly(), bundle);
            } else if (descriptor.getSharedLibrary() != null) {
                this.uninstallSharedLibrary(descriptor.getSharedLibrary(), bundle);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error handling bundle stop event", (Throwable)e);
        }
    }

    protected void installComponent(ComponentDesc componentDesc, Bundle bundle) throws Exception {
        LOGGER.info((Object)("Deploying bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' as a JBI component"));
        if (componentDesc.getSharedLibraries() != null) {
            for (SharedLibraryList sl : componentDesc.getSharedLibraries()) {
                if (this.sharedLibraries.get(sl.getName()) != null) continue;
                throw new PendingException(bundle, "SharedLibrary not installed: " + sl.getName());
            }
        }
        String name = componentDesc.getIdentification().getName();
        ClassLoader classLoader = this.createComponentClassLoader(componentDesc, bundle);
        Thread.currentThread().setContextClassLoader(classLoader);
        File installRoot = new File(System.getProperty("servicemix.base"), "data/jbi/" + name + "/install");
        installRoot.mkdirs();
        this.extractBundle(installRoot, bundle, "/");
        Preferences prefs = this.preferencesService.getUserPreferences(name);
        Class<?> clazz = classLoader.loadClass(componentDesc.getComponentClassName());
        javax.jbi.component.Component innerComponent = (javax.jbi.component.Component)clazz.newInstance();
        ComponentImpl component = new ComponentImpl(componentDesc, innerComponent, prefs, this.autoStart, this);
        this.components.put(name, component);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(NAME, name);
        ((Dictionary)props).put(TYPE, componentDesc.getType());
        LOGGER.debug((Object)"Registering JBI component");
        this.registerService(bundle, Component.class.getName(), component, props);
        this.registerService(bundle, ComponentWrapper.class.getName(), component, props);
        this.registerService(bundle, javax.jbi.component.Component.class.getName(), innerComponent, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractBundle(File installRoot, Bundle bundle, String path) throws IOException {
        Enumeration e = bundle.getEntryPaths(path);
        while (e != null && e.hasMoreElements()) {
            String entry = (String)e.nextElement();
            File fout = new File(installRoot, entry);
            if (entry.endsWith("/")) {
                fout.mkdirs();
                this.extractBundle(installRoot, bundle, entry);
                continue;
            }
            InputStream in = bundle.getEntry(entry).openStream();
            FileOutputStream out = new FileOutputStream(fout);
            try {
                FileUtil.copyInputStream(in, out);
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
        }
    }

    protected void deployServiceAssembly(ServiceAssemblyDesc serviceAssembyDesc, Bundle bundle) throws Exception {
        LOGGER.info((Object)("Deploying bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' as a JBI service assembly"));
        for (ServiceUnitDesc sud : serviceAssembyDesc.getServiceUnits()) {
            String componentName = sud.getTarget().getComponentName();
            ComponentImpl component = this.components.get(componentName);
            if (component == null) {
                throw new PendingException(bundle, "Component not installed: " + componentName);
            }
            if (!"Unknown".equals(component.getCurrentState())) continue;
            throw new PendingException(bundle, "Component is in an unknown state: " + componentName);
        }
        File saDir = new File(this.jbiRootDir, Long.toString(bundle.getBundleId()));
        FileUtil.deleteFile(saDir);
        FileUtil.buildDirectory(saDir);
        ArrayList<ServiceUnitImpl> sus = new ArrayList<ServiceUnitImpl>();
        boolean failure = false;
        for (ServiceUnitDesc sud : serviceAssembyDesc.getServiceUnits()) {
            File suRootDir = new File(saDir, sud.getIdentification().getName());
            suRootDir.mkdirs();
            String zip = sud.getTarget().getArtifactsZip();
            URL zipUrl = bundle.getResource(zip);
            FileUtil.unpackArchive(zipUrl, suRootDir);
            String componentName = sud.getTarget().getComponentName();
            ComponentImpl component = this.components.get(componentName);
            ServiceUnitImpl su = new ServiceUnitImpl(sud, suRootDir, component);
            try {
                LOGGER.debug((Object)("Deploying SU " + su.getName()));
                su.deploy();
                sus.add(su);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error deploying SU " + su.getName()), (Throwable)e);
                failure = true;
                break;
            }
        }
        if (failure) {
            for (ServiceUnitImpl su : sus) {
                try {
                    LOGGER.debug((Object)("Undeploying SU " + su.getName()));
                    su.undeploy();
                }
                catch (Exception e) {
                    LOGGER.warn((Object)("Error undeploying SU " + su.getName()), (Throwable)e);
                }
            }
            return;
        }
        this.registerSA(serviceAssembyDesc, bundle, sus);
    }

    protected void registerSA(ServiceAssemblyDesc serviceAssembyDesc, Bundle bundle, List<ServiceUnitImpl> sus) throws JBIException {
        Preferences prefs = this.preferencesService.getUserPreferences(serviceAssembyDesc.getIdentification().getName());
        ServiceAssemblyImpl sa = new ServiceAssemblyImpl(serviceAssembyDesc, sus, prefs, this.autoStart);
        sa.init();
        this.serviceAssemblies.put(sa.getName(), sa);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(NAME, serviceAssembyDesc.getIdentification().getName());
        LOGGER.debug((Object)"Registering JBI service assembly");
        this.registerService(bundle, ServiceAssembly.class.getName(), sa, props);
    }

    protected void installSharedLibrary(SharedLibraryDesc sharedLibraryDesc, Bundle bundle) {
        LOGGER.info((Object)("Deploying bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' as a JBI shared library"));
        SharedLibraryImpl sl = new SharedLibraryImpl(sharedLibraryDesc, bundle);
        this.sharedLibraries.put(sl.getName(), sl);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(NAME, sharedLibraryDesc.getIdentification().getName());
        LOGGER.debug((Object)"Registering JBI Shared Library");
        this.registerService(bundle, SharedLibrary.class.getName(), sl, props);
        this.checkPendingBundles();
    }

    protected void uninstallComponent(ComponentDesc componentDesc, Bundle bundle) throws Exception {
        String name = componentDesc.getIdentification().getName();
        ComponentImpl component = this.components.remove(name);
        if (component != null) {
            if (component.getState() == ComponentImpl.State.Started) {
                component.stop(false);
            }
            if (component.getState() == ComponentImpl.State.Stopped) {
                component.shutDown(false);
            }
            File file = new File(System.getProperty("servicemix.base"), "data/jbi/" + name);
            FileUtil.deleteFile(file);
        }
    }

    protected void undeployServiceAssembly(ServiceAssemblyDesc serviceAssembyDesc, Bundle bundle) throws Exception {
        String name = serviceAssembyDesc.getIdentification().getName();
        this.unregisterSA(name);
    }

    protected void unregisterSA(String name) throws JBIException {
        ServiceAssemblyImpl sa = this.serviceAssemblies.remove(name);
        if (sa != null) {
            if (sa.getState() == ServiceAssemblyImpl.State.Started) {
                sa.stop(false);
            }
            if (sa.getState() == ServiceAssemblyImpl.State.Stopped) {
                sa.shutDown(false);
            }
            for (ServiceUnit su : sa.getServiceUnits()) {
                ((ServiceUnitImpl)su).undeploy();
            }
        }
    }

    protected void uninstallSharedLibrary(SharedLibraryDesc sharedLibraryDesc, Bundle bundle) throws JBIException {
    }

    protected void maybeWrapComponent(ServiceReference reference, javax.jbi.component.Component component) {
        String name = (String)reference.getProperty(NAME);
        if (name != null && !this.components.containsKey(name)) {
            String type = (String)reference.getProperty(TYPE);
            Preferences prefs = this.preferencesService.getUserPreferences(name);
            ComponentDesc componentDesc = new ComponentDesc();
            componentDesc.setIdentification(new Identification());
            componentDesc.getIdentification().setName(name);
            componentDesc.setType(type);
            ComponentImpl wrapper = new ComponentImpl(componentDesc, component, prefs, this.autoStart, this);
            this.wrappedComponents.put(name, true);
            this.components.put(name, wrapper);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(NAME, name);
            ((Dictionary)props).put(TYPE, componentDesc.getType());
            this.registerService(reference.getBundle(), Component.class.getName(), wrapper, props);
            this.registerService(reference.getBundle(), ComponentWrapper.class.getName(), wrapper, props);
        }
    }

    protected void maybeUnwrapComponent(ServiceReference reference, javax.jbi.component.Component component) {
        ComponentImpl ci;
        String name = (String)reference.getProperty(NAME);
        if (name != null && Boolean.TRUE.equals(this.wrappedComponents.remove(name)) && (ci = this.components.remove(name)) != null) {
            try {
                ci.stop(false);
                ci.shutDown(false);
            }
            catch (JBIException e) {
                LOGGER.warn((Object)"Error when shutting down component", (Throwable)e);
            }
        }
    }

    protected void checkPendingBundles() {
        if (!this.pendingBundles.isEmpty()) {
            List<Bundle> pending = this.pendingBundles;
            this.pendingBundles = new ArrayList<Bundle>();
            for (Bundle bundle : pending) {
                this.register(bundle);
            }
        }
    }

    protected void registerService(Bundle bundle, String clazz, Object service, Dictionary props) {
        BundleContext context = bundle.getBundleContext() != null ? bundle.getBundleContext() : this.getBundleContext();
        ServiceRegistration reg = context.registerService(clazz, service, props);
        List<ServiceRegistration> registrations = this.services.get(bundle);
        if (registrations == null) {
            registrations = new ArrayList<ServiceRegistration>();
            this.services.put(bundle, registrations);
        }
        registrations.add(reg);
    }

    protected ClassLoader createComponentClassLoader(ComponentDesc component, Bundle bundle) {
        ClassLoader[] parents;
        if (component.getSharedLibraries() != null) {
            parents = new ClassLoader[component.getSharedLibraries().length + 1];
            for (int i = 0; i < component.getSharedLibraries().length; ++i) {
                parents[i + 1] = this.getSharedLibraryClassLoader(component.getSharedLibraries()[i]);
            }
        } else {
            parents = new ClassLoader[]{BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)bundle, (ClassLoader)this.getClass().getClassLoader())};
        }
        String[] classPathNames = component.getComponentClassPath().getPathElements();
        URL[] urls = new URL[classPathNames.length];
        for (int i = 0; i < classPathNames.length; ++i) {
            urls[i] = bundle.getResource(classPathNames[i]);
            if (urls[i] != null) continue;
            throw new IllegalArgumentException("SharedLibrary classpath entry not found: '" + classPathNames[i] + "'");
        }
        return new MultiParentClassLoader(component.getIdentification().getName(), urls, parents, component.isComponentClassLoaderDelegationSelfFirst(), new String[]{"javax.xml.bind"}, new String[]{"java.", "javax."});
    }

    protected ClassLoader getSharedLibraryClassLoader(SharedLibraryList sharedLibraryList) {
        SharedLibraryImpl sl = this.sharedLibraries.get(sharedLibraryList.getName());
        if (sl != null) {
            return sl.getClassLoader();
        }
        throw new IllegalStateException("SharedLibrary not installed: " + sharedLibraryList.getName());
    }

    public void registerDeployedServiceAssembly(ServiceReference serviceReference, DeployedAssembly assembly) {
        try {
            ServiceAssemblyDesc desc = new ServiceAssemblyDesc();
            desc.setIdentification(new Identification());
            desc.getIdentification().setName(assembly.getName());
            ArrayList<ServiceUnitImpl> sus = new ArrayList<ServiceUnitImpl>();
            for (Map.Entry<String, String> unit : assembly.getServiceUnits().entrySet()) {
                ServiceUnitDesc suDesc = new ServiceUnitDesc();
                suDesc.setIdentification(new Identification());
                suDesc.getIdentification().setName(unit.getKey());
                suDesc.setTarget(new Target());
                suDesc.getTarget().setComponentName(unit.getValue());
                ServiceUnitImpl su = new ServiceUnitImpl(suDesc, null, this.components.get(unit.getValue()));
                sus.add(su);
            }
            this.registerSA(desc, serviceReference.getBundle(), sus);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error registering deployed service assembly", (Throwable)e);
        }
    }

    public void unregisterDeployedServiceAssembly(ServiceReference serviceReference, DeployedAssembly assembly) {
        try {
            this.unregisterSA(assembly.getName());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error unregistering deployed service assembly", (Throwable)e);
        }
    }
}

