/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.impl.ComponentImpl;
import org.apache.servicemix.jbi.deployer.impl.ServiceAssemblyImpl;

public class ServiceUnitImpl
implements ServiceUnit {
    private static final Log Logger = LogFactory.getLog(ServiceUnitImpl.class);
    private ServiceUnitDesc serviceUnitDesc;
    private File rootDir;
    private ComponentImpl component;
    private ServiceAssemblyImpl serviceAssembly;

    public ServiceUnitImpl(ServiceUnitDesc serviceUnitDesc, File rootDir, ComponentImpl component) {
        this.serviceUnitDesc = serviceUnitDesc;
        this.rootDir = rootDir;
        this.component = component;
    }

    public String getKey() {
        return this.getComponentName() + "/" + this.getName();
    }

    public String getName() {
        return this.serviceUnitDesc.getIdentification().getName();
    }

    public String getDescription() {
        return this.serviceUnitDesc.getIdentification().getDescription();
    }

    public String getComponentName() {
        return this.serviceUnitDesc.getTarget().getComponentName();
    }

    public ServiceAssembly getServiceAssembly() {
        return this.serviceAssembly;
    }

    protected ServiceAssemblyImpl getServiceAssemblyImpl() {
        return this.serviceAssembly;
    }

    protected void setServiceAssemblyImpl(ServiceAssemblyImpl serviceAssembly) {
        this.serviceAssembly = serviceAssembly;
    }

    public Component getComponent() {
        return this.component;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void deploy() throws JBIException {
        this.component.getComponent().getServiceUnitManager().deploy(this.getName(), this.getRootDir() != null ? this.getRootDir().getAbsolutePath() : null);
        this.component.addServiceUnit(this);
    }

    public void init() throws JBIException {
        this.component.getComponent().getServiceUnitManager().init(this.getName(), this.getRootDir() != null ? this.getRootDir().getAbsolutePath() : null);
    }

    public void start() throws JBIException {
        this.checkComponentStarted("start");
        this.component.getComponent().getServiceUnitManager().start(this.getName());
    }

    public void stop() throws JBIException {
        this.checkComponentStarted("stop");
        this.component.getComponent().getServiceUnitManager().stop(this.getName());
    }

    public void shutdown() throws JBIException {
        this.checkComponentStartedOrStopped("shutDown");
        this.component.getComponent().getServiceUnitManager().shutDown(this.getName());
    }

    public void undeploy() throws JBIException {
        this.component.getComponent().getServiceUnitManager().undeploy(this.getName(), this.getRootDir().getAbsolutePath());
        this.component.removeServiceUnit(this);
    }

    protected void checkComponentStarted(String task) throws DeploymentException {
        if (!"Started".equals(this.component.getCurrentState())) {
            throw new DeploymentException("Component " + this.component.getName() + " is not started!");
        }
    }

    protected void checkComponentStartedOrStopped(String task) throws DeploymentException {
        if (!"Started".equals(this.component.getCurrentState()) && !"Stopped".equals(this.component.getCurrentState())) {
            throw new DeploymentException("Component " + this.component.getName() + " is shut down!");
        }
    }
}

