/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Copyright 2006 aQute SARL
 * Licensed under the Apache License, Version 2.0, see http://www.apache.org/licenses/LICENSE-2.0 */
/***
 * This code has been imported from aQute.lib.osgi.Builder class, from bnd-0.0.0239.jar
 * and only the cleanupVersion() and cleanupModifier() methods have been kept. 
 */
package org.apache.servicemix.jbi.deployer.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Builder {

	/**
	 * Clean up version parameters. Other builders use more fuzzy definitions of
	 * the version syntax. This method cleans up such a version to match an OSGi
	 * version.
	 *
	 * @param version
	 * @return
	 */
	static Pattern	fuzzyVersion	= Pattern
											.compile(
													"(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?",
													Pattern.DOTALL);
	static Pattern	fuzzyModifier	= Pattern.compile("(\\d+[.-])*(.*)",
											Pattern.DOTALL);

	static Pattern nummeric		= Pattern.compile("\\d*");

	static public String cleanupVersion(String version) {
		Matcher m = fuzzyVersion.matcher(version);
		if (m.matches()) {
			StringBuffer result = new StringBuffer();
			String d1 = m.group(1);
			String d2 = m.group(3);
			String d3 = m.group(5);
			String qualifier = m.group(7);

			if (d1 != null) {
				result.append(d1);
				if (d2 != null) {
					result.append(".");
					result.append(d2);
					if (d3 != null) {
						result.append(".");
						result.append(d3);
						if (qualifier != null) {
							result.append(".");
							cleanupModifier(result, qualifier);
						}
					} else if (qualifier != null) {
						result.append(".0.");
						cleanupModifier(result, qualifier);
					}
				} else if (qualifier != null) {
					result.append(".0.0.");
					cleanupModifier(result, qualifier);
				}
				return result.toString();
			}
		}
		return version;
	}

	static void cleanupModifier(StringBuffer result, String modifier) {
		Matcher m = fuzzyModifier.matcher(modifier);
		if (m.matches())
			modifier = m.group(2);

		for (int i = 0; i < modifier.length(); i++) {
			char c = modifier.charAt(i);
			if ((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') ||
					(c >= 'A' && c <= 'Z') || c == '_' || c == '-')
				result.append(c);
		}
	}

}
