/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.management.ManagedComponent;
import org.apache.servicemix.jbi.management.ManagedServiceAssembly;
import org.apache.servicemix.jbi.management.ManagedSharedLibrary;
import org.apache.servicemix.jbi.management.NamingStrategy;

public class DefaultNamingStrategy
implements NamingStrategy {
    private String jmxDomainName;

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public ObjectName getObjectName(ManagedSharedLibrary sharedLibrary) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Type=SharedLibrary," + "Name=" + this.sanitize(sharedLibrary.getName()) + "," + "Version=" + this.sanitize(sharedLibrary.getVersion()));
    }

    public ObjectName getObjectName(ManagedComponent component) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Type=Component," + "Name=" + this.sanitize(component.getName()) + "," + "SubType=LifeCycle");
    }

    public ObjectName getObjectName(ManagedServiceAssembly serviceAssembly) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Type=ServiceAssembly," + "Name=" + this.sanitize(serviceAssembly.getName()));
    }

    private String sanitize(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }
}

