/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.management.ManagedComponent;
import org.apache.servicemix.jbi.management.ManagedServiceAssembly;
import org.apache.servicemix.jbi.management.ManagedSharedLibrary;
import org.apache.servicemix.jbi.management.ManagementAgent;
import org.apache.servicemix.jbi.management.NamingStrategy;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedJbiRegistry
implements InitializingBean {
    private static final transient Log LOG = LogFactory.getLog(ManagedJbiRegistry.class);
    private NamingStrategy namingStrategy;
    private ManagementAgent managementAgent;
    private Map<String, ManagedSharedLibrary> sharedLibraries = new ConcurrentHashMap<String, ManagedSharedLibrary>();
    private Map<String, ManagedComponent> components = new ConcurrentHashMap<String, ManagedComponent>();
    private Map<String, ManagedServiceAssembly> serviceAssemblies = new ConcurrentHashMap<String, ManagedServiceAssembly>();

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public ManagementAgent getManagementAgent() {
        return this.managementAgent;
    }

    public void setManagementAgent(ManagementAgent managementAgent) {
        this.managementAgent = managementAgent;
    }

    public void registerSharedLibrary(SharedLibrary sharedLibrary, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Registering SharedLibrary: " + sharedLibrary + " with properties " + properties));
            ManagedSharedLibrary sl = new ManagedSharedLibrary(sharedLibrary, properties);
            this.sharedLibraries.put(sharedLibrary.getName() + "-" + sharedLibrary.getVersion(), sl);
            this.managementAgent.register(sl, this.namingStrategy.getObjectName(sl));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register managed SharedLibrary: " + e), (Throwable)e);
        }
    }

    public void unregisterSharedLibrary(SharedLibrary sharedLibrary, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Unregistering SharedLibrary: " + sharedLibrary + " with properties " + properties));
            ManagedSharedLibrary sl = this.sharedLibraries.remove(sharedLibrary.getName() + "-" + sharedLibrary.getVersion());
            this.managementAgent.unregister(this.namingStrategy.getObjectName(sl));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed SharedLibrary: " + e), (Throwable)e);
        }
    }

    public void registerComponent(Component component, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Registering Component: " + component + " with properties " + properties));
            ManagedComponent comp = new ManagedComponent(component, properties);
            this.components.put(component.getName(), comp);
            this.managementAgent.register(comp, this.namingStrategy.getObjectName(comp));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register managed Component: " + e), (Throwable)e);
        }
    }

    public void unregisterComponent(Component component, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Unregistering Component: " + component + " with properties " + properties));
            ManagedComponent comp = this.components.remove(component.getName());
            this.managementAgent.unregister(this.namingStrategy.getObjectName(comp));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed Component: " + e), (Throwable)e);
        }
    }

    public void registerServiceAssembly(ServiceAssembly serviceAssembly, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Registering ServiceAssembly: " + serviceAssembly + " with properties " + properties));
            ManagedServiceAssembly sa = new ManagedServiceAssembly(serviceAssembly, properties);
            this.serviceAssemblies.put(serviceAssembly.getName(), sa);
            this.managementAgent.register(sa, this.namingStrategy.getObjectName(sa));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register ServiceAssembly: " + e), (Throwable)e);
        }
    }

    public void unregisterServiceAssembly(ServiceAssembly serviceAssembly, Map<String, ?> properties) {
        try {
            LOG.info((Object)("Unregistering ServiceAssembly: " + serviceAssembly + " with properties " + properties));
            ManagedServiceAssembly sa = this.serviceAssemblies.remove(serviceAssembly.getName());
            this.managementAgent.unregister(this.namingStrategy.getObjectName(sa));
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed ServiceAssembly: " + e), (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.managementAgent == null) {
            throw new IllegalArgumentException("managementAgent must not be null");
        }
        if (this.namingStrategy == null) {
            throw new IllegalArgumentException("namingStrategy must not be null");
        }
    }
}

