/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.osgi;

import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.Reference;
import org.apache.servicemix.nmr.core.util.MapToDictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryWrapper
implements EndpointRegistry {
    private EndpointRegistry registry;
    private BundleContext bundleContext;
    private Map<Endpoint, ServiceRegistration> registrations = new ConcurrentHashMap<Endpoint, ServiceRegistration>();

    public RegistryWrapper(EndpointRegistry registry, BundleContext bundleContext) {
        this.registry = registry;
        this.bundleContext = bundleContext;
    }

    public void register(Endpoint endpoint, Map<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(Endpoint.class.getName(), (Object)endpoint, (Dictionary)new MapToDictionary(properties));
        this.registrations.put(endpoint, reg);
    }

    public void unregister(Endpoint endpoint, Map<String, ?> properties) {
        ServiceRegistration reg = this.registrations.remove(endpoint);
        reg.unregister();
    }

    public List<Endpoint> query(Map<String, ?> properties) {
        return this.registry.query(properties);
    }

    public Reference lookup(Map<String, ?> properties) {
        return this.registry.lookup(properties);
    }

    public Reference lookup(Document xml) {
        return this.registry.lookup(xml);
    }

    public Reference lookup(String filter) {
        return this.registry.lookup(filter);
    }

    public Map<String, ?> getProperties(Endpoint service) {
        return this.registry.getProperties((Object)service);
    }

    public Set<Endpoint> getServices() {
        return this.registry.getServices();
    }
}

