/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.compendium.cm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.geronimo.blueprint.compendium.cm.ManagedObject;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedObjectManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedObjectManager.class);
    private HashMap<String, ConfigurationWatcher> map = new HashMap();

    public synchronized void register(ManagedObject cm, Properties props) {
        String key = cm.getPersistentId();
        ConfigurationWatcher reg = this.map.get(key);
        if (reg == null) {
            reg = new ConfigurationWatcher();
            ServiceRegistration registration = cm.getBundle().getBundleContext().registerService(ManagedService.class.getName(), (Object)reg, (Dictionary)props);
            reg.setRegistration(registration);
            this.map.put(key, reg);
        }
        reg.add(cm);
    }

    public synchronized void unregister(ManagedObject cm) {
        String key = cm.getPersistentId();
        ConfigurationWatcher reg = this.map.get(key);
        if (reg != null) {
            reg.remove(cm);
            if (reg.isEmpty()) {
                this.map.remove(key);
                reg.getRegistration().unregister();
            }
        }
    }

    private static class ConfigurationWatcher
    implements ManagedService {
        private ServiceRegistration registration;
        private List<ManagedObject> list = Collections.synchronizedList(new ArrayList());

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updated(Dictionary props) throws ConfigurationException {
            List<ManagedObject> list = this.list;
            synchronized (list) {
                for (ManagedObject cm : this.list) {
                    cm.updated(props);
                }
            }
        }

        private void setRegistration(ServiceRegistration registration) {
            this.registration = registration;
        }

        private ServiceRegistration getRegistration() {
            return this.registration;
        }

        private void add(ManagedObject cm) {
            this.list.add(cm);
        }

        private void remove(ManagedObject cm) {
            this.list.remove(cm);
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }
    }
}

