/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.cluster.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.cluster.engine.ClusterRegistration;
import org.apache.servicemix.jbi.cluster.requestor.JmsRequestor;
import org.apache.servicemix.jbi.cluster.requestor.JmsRequestorListener;
import org.apache.servicemix.jbi.cluster.requestor.JmsRequestorPool;
import org.apache.servicemix.jbi.cluster.requestor.Transacted;
import org.apache.servicemix.jbi.runtime.impl.DeliveryChannelImpl;
import org.apache.servicemix.jbi.runtime.impl.ServiceEndpointImpl;
import org.apache.servicemix.nmr.api.Channel;
import org.apache.servicemix.nmr.api.Endpoint;
import org.apache.servicemix.nmr.api.EndpointRegistry;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.api.Role;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.api.event.EndpointListener;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.apache.servicemix.nmr.api.internal.InternalExchange;
import org.apache.servicemix.nmr.api.service.ServiceHelper;
import org.apache.servicemix.nmr.core.ServiceRegistryImpl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterEngine
extends ServiceRegistryImpl<ClusterRegistration>
implements Endpoint,
InitializingBean,
DisposableBean,
EndpointListener,
ExchangeListener {
    public static final int DEFAULT_MAX_PENDING_EXCHANGES = 4096;
    protected static final String JBI_MESSAGE = "JBIMessage";
    protected static final int JBI_MESSAGE_IN = 0;
    protected static final int JBI_MESSAGE_OUT = 1;
    protected static final int JBI_MESSAGE_FAULT = 2;
    protected static final int JBI_MESSAGE_DONE = 3;
    protected static final int JBI_MESSAGE_ERROR = 4;
    protected static final String JBI_MEP = "JBIMep";
    protected static final String JBI_INTERFACE = "JBIInterface";
    protected static final String JBI_OPERATION = "JBIOperation";
    protected static final String JBI_SERVICE = "JBIService";
    protected static final String JBI_ENDPOINT = "JBIEndpoint";
    protected static final String PROPERTY_CORR_ID = "ClusterCorrId";
    protected static final String PROPERTY_SENDER_CORR_ID = "SenderClusterCorrId";
    protected static final String PROPERTY_ROLLBACK_ON_ERRORS = "ClusterRollbackOnErrors";
    protected static final String PROPERTY_CLUSTER_NAME = "ClusterName";
    protected static final String PROPERTY_SENDER_CLUSTER_NAME = "SenderClusterName";
    protected static final Log logger = LogFactory.getLog(ClusterEngine.class);
    protected boolean rollbackOnErrors = true;
    protected String name;
    protected JmsRequestorPool pool;
    protected Channel channel;
    protected AtomicBoolean started = new AtomicBoolean();
    protected final Map<String, Exchange> exchanges = new ConcurrentHashMap<String, Exchange>();
    protected String selector;
    protected AtomicInteger pendingExchanges = new AtomicInteger();
    protected AtomicBoolean pauseConsumption = new AtomicBoolean(false);
    protected int maxPendingExchanges = 4096;

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start cluster endpoint", e);
        }
    }

    public JmsRequestorPool getPool() {
        return this.pool;
    }

    public void setPool(JmsRequestorPool pool) {
        this.pool = pool;
    }

    public boolean isRollbackOnErrors() {
        return this.rollbackOnErrors;
    }

    public void setRollbackOnErrors(boolean rollbackOnErrors) {
        this.rollbackOnErrors = rollbackOnErrors;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getMaxPendingExchanges() {
        return this.maxPendingExchanges;
    }

    public void setMaxPendingExchanges(int maxPendingExchanges) {
        this.maxPendingExchanges = maxPendingExchanges;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.pool == null) {
            throw new IllegalArgumentException("'pool' must be set");
        }
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting cluster endpoint: " + this.name));
            }
            this.pool.setListener(new JmsRequestorListener(){

                public void onMessage(JmsRequestor requestor) throws Exception {
                    ClusterEngine.this.process(requestor);
                }
            });
            this.invalidateSelector();
            this.pool.start();
        }
    }

    public void destroy() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Stopping cluster endpoint: " + this.name));
            }
            this.pool.stop();
        }
    }

    public void pause() {
        if (this.pauseConsumption.compareAndSet(false, true)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pausing cluster endpoint: " + this.name));
            }
            this.invalidateSelector();
        }
    }

    public void resume() {
        if (this.pauseConsumption.compareAndSet(true, false)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resuming cluster endpoint: " + this.name));
            }
            this.invalidateSelector();
        }
    }

    public void endpointRegistered(InternalEndpoint endpoint) {
        this.invalidateSelector();
    }

    public void endpointUnregistered(InternalEndpoint endpoint) {
        this.invalidateSelector();
    }

    public void exchangeSent(Exchange exchange) {
        if (exchange instanceof InternalExchange && exchange.getStatus() == Status.Active && exchange.getRole() == Role.Consumer && exchange.getOut(false) == null && exchange.getFault(false) == null) {
            InternalEndpoint source = ((InternalExchange)exchange).getSource();
            for (ClusterRegistration reg : this.getServices()) {
                if (!reg.match(source)) continue;
                exchange.setTarget(this.getChannel().getNMR().getEndpointRegistry().lookup(ServiceHelper.createMap((String[])new String[]{"NAME", this.name})));
                return;
            }
        }
    }

    public void exchangeDelivered(Exchange exchange) {
    }

    public void exchangeFailed(Exchange exchange) {
    }

    public void invalidateSelector() {
        this.selector = null;
        if (this.pool != null) {
            String selector = this.pauseConsumption.get() ? "ClusterName = '" + this.name + "'" : this.getSelector();
            this.pool.setMessageSelector(selector);
        }
    }

    protected String getSelector() {
        if (this.selector == null) {
            HashSet<String> interfaces = new HashSet<String>();
            HashSet<String> services = new HashSet<String>();
            HashSet<String> endpoints = new HashSet<String>();
            for (ServiceEndpoint se : this.getAllEndpoints()) {
                QName[] itfs = se.getInterfaces();
                if (itfs != null) {
                    for (QName itf : itfs) {
                        interfaces.add(itf.toString());
                    }
                }
                services.add(se.getServiceName().toString());
                endpoints.add("{" + se.getServiceName().toString() + "}" + se.getEndpointName());
            }
            StringBuilder selector = new StringBuilder();
            if (!endpoints.isEmpty()) {
                selector.append("(");
                selector.append(JBI_MESSAGE).append(" = ").append(0).append(" AND (");
                if (!interfaces.isEmpty()) {
                    selector.append(JBI_INTERFACE).append(" IN (");
                    boolean first = true;
                    for (String s : interfaces) {
                        if (!first) {
                            selector.append(", ");
                        } else {
                            first = false;
                        }
                        selector.append("'").append(s).append("'");
                    }
                    selector.append(")");
                }
                if (!interfaces.isEmpty()) {
                    selector.append(" OR ");
                }
                selector.append(JBI_SERVICE).append(" IN (");
                boolean first = true;
                for (String s : services) {
                    if (!first) {
                        selector.append(", ");
                    } else {
                        first = false;
                    }
                    selector.append("'").append(s).append("'");
                }
                selector.append(")");
                selector.append(" OR ");
                selector.append(JBI_ENDPOINT).append(" IN (");
                first = true;
                for (String s : endpoints) {
                    if (!first) {
                        selector.append(", ");
                    } else {
                        first = false;
                    }
                    selector.append("'").append(s).append("'");
                }
                selector.append(")");
                selector.append(")");
                selector.append(")");
                selector.append(" OR ");
            }
            selector.append(PROPERTY_CLUSTER_NAME).append(" = '").append(this.name).append("'");
            this.selector = selector.toString();
        }
        return this.selector;
    }

    protected ServiceEndpoint getEndpoint(QName serviceName, String endpointName) {
        return new ServiceEndpointImpl(serviceName, endpointName);
    }

    protected List<ServiceEndpoint> getAllEndpoints() {
        ArrayList<ServiceEndpoint> endpoints = new ArrayList<ServiceEndpoint>();
        EndpointRegistry registry = this.getChannel().getNMR().getEndpointRegistry();
        for (Endpoint ep : registry.getServices()) {
            Map props = registry.getProperties((Object)ep);
            if (props.get("SERVICE_NAME") == null || props.get("ENDPOINT_NAME") == null || Boolean.valueOf((String)props.get("UNTARGETABLE")).booleanValue()) continue;
            endpoints.add((ServiceEndpoint)new ServiceEndpointImpl(props));
        }
        return endpoints;
    }

    protected void done(Exchange exchange) {
        exchange.setStatus(Status.Done);
        this.send(exchange);
    }

    protected void fail(Exchange exchange, Exception e) {
        exchange.setStatus(Status.Error);
        exchange.setError(e);
        this.send(exchange);
    }

    protected void send(Exchange exchange) {
        this.decrementPendingExchangeIfNeeded(exchange);
        this.getChannel().send(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) {
        block16: {
            try {
                JmsRequestor item;
                String corrId = (String)exchange.getProperty("ClusterCorrId." + this.name);
                if (corrId != null) {
                    JmsRequestor item2;
                    JmsRequestor jmsRequestor = item2 = this.pool.resume(corrId);
                    synchronized (jmsRequestor) {
                        try {
                            this.processExchange(item2, exchange);
                        }
                        finally {
                            item2.close();
                        }
                        break block16;
                    }
                }
                JmsRequestor jmsRequestor = item = this.pool.newRequestor();
                synchronized (jmsRequestor) {
                    try {
                        item.begin();
                        this.processExchange(item, exchange);
                    }
                    finally {
                        item.close();
                    }
                }
            }
            catch (Exception e) {
                this.fail(exchange, e);
            }
        }
    }

    protected void process(JmsRequestor requestor) throws JMSException {
        Message message = requestor.getMessage();
        int type = message.getIntProperty(JBI_MESSAGE);
        switch (type) {
            case 3: {
                String corrId = message.getStringProperty(PROPERTY_CORR_ID);
                if (corrId == null) {
                    throw new IllegalStateException("Incoming JMS message has no correlationId");
                }
                Exchange exchange = this.exchanges.remove(corrId);
                if (exchange == null) {
                    throw new IllegalStateException("Exchange not found for id " + corrId);
                }
                this.done(exchange);
                break;
            }
            case 4: {
                String corrId = message.getStringProperty(PROPERTY_CORR_ID);
                if (corrId == null) {
                    throw new IllegalStateException("Incoming JMS message has no correlationId");
                }
                Exchange exchange = this.exchanges.remove(corrId);
                if (exchange == null) {
                    throw new IllegalStateException("Exchange not found for id " + corrId);
                }
                this.fail(exchange, (Exception)((ObjectMessage)message).getObject());
                break;
            }
            case 0: {
                String mep = message.getStringProperty(JBI_MEP);
                if (mep == null) {
                    throw new IllegalStateException("Exchange MEP not found for JMS message " + message.getJMSMessageID());
                }
                Exchange exchange = this.getChannel().createExchange(Pattern.fromWsdlUri((String)mep));
                exchange.setProperty("ClusterRollbackOnErrors." + this.name, (Object)message.getBooleanProperty(PROPERTY_ROLLBACK_ON_ERRORS));
                if (message.propertyExists(JBI_INTERFACE)) {
                    exchange.setProperty("javax.jbi.InterfaceName", (Object)QName.valueOf(message.getStringProperty(JBI_INTERFACE)));
                }
                if (message.propertyExists(JBI_OPERATION)) {
                    exchange.setOperation(QName.valueOf(message.getStringProperty(JBI_OPERATION)));
                }
                if (message.propertyExists(JBI_SERVICE)) {
                    exchange.setProperty("javax.jbi.ServiceName", (Object)QName.valueOf(message.getStringProperty(JBI_SERVICE)));
                }
                if (message.propertyExists(JBI_ENDPOINT)) {
                    QName q = QName.valueOf(message.getStringProperty(JBI_ENDPOINT));
                    String e = q.getLocalPart();
                    q = QName.valueOf(q.getNamespaceURI());
                    ServiceEndpoint se = this.getEndpoint(q, e);
                    exchange.setProperty("javax.jbi.ServiceEndpoint", (Object)se);
                }
                DeliveryChannelImpl.createTarget((NMR)this.getChannel().getNMR(), (Exchange)exchange);
                org.apache.servicemix.nmr.api.Message msg = this.unmarshallMessage(message);
                exchange.setIn(msg);
                this.exchanges.put(exchange.getId(), exchange);
                if (this.pendingExchanges.incrementAndGet() >= this.maxPendingExchanges && this.pauseConsumption.compareAndSet(false, true)) {
                    this.invalidateSelector();
                }
                exchange.setProperty("ClusterCorrId." + this.name, (Object)exchange.getId());
                requestor.suspend(exchange.getId());
                if (requestor.getTransaction() != null) {
                    exchange.setProperty("javax.jbi.transaction.jta", (Object)requestor.getTransaction());
                }
                this.send(exchange);
                break;
            }
            case 1: {
                String corrId = message.getStringProperty(PROPERTY_CORR_ID);
                if (corrId == null) {
                    throw new IllegalStateException("Incoming JMS message has no correlationId");
                }
                Exchange exchange = this.exchanges.get(corrId);
                if (exchange == null) {
                    throw new IllegalStateException("Exchange not found for id " + corrId);
                }
                org.apache.servicemix.nmr.api.Message msg = this.unmarshallMessage(message);
                exchange.setOut(msg);
                this.exchanges.put(exchange.getId(), exchange);
                exchange.setProperty("ClusterCorrId." + this.name, (Object)exchange.getId());
                requestor.suspend(exchange.getId());
                if (requestor.getTransaction() != null) {
                    exchange.setProperty("javax.jbi.transaction.jta", (Object)requestor.getTransaction());
                }
                this.send(exchange);
                break;
            }
            case 2: {
                String corrId = message.getStringProperty(PROPERTY_CORR_ID);
                if (corrId == null) {
                    throw new IllegalStateException("Incoming JMS message has no correlationId");
                }
                Exchange exchange = this.exchanges.get(corrId);
                if (exchange == null) {
                    throw new IllegalStateException("Exchange not found for id " + corrId);
                }
                org.apache.servicemix.nmr.api.Message msg = this.unmarshallMessage(message);
                exchange.setFault(msg);
                this.exchanges.put(exchange.getId(), exchange);
                exchange.setProperty("ClusterCorrId." + this.name, (Object)exchange.getId());
                requestor.suspend(exchange.getId());
                if (requestor.getTransaction() != null) {
                    exchange.setProperty("javax.jbi.transaction.jta", (Object)requestor.getTransaction());
                }
                this.send(exchange);
                break;
            }
            default: {
                throw new IllegalStateException("Received unknown message type: " + type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExchange(JmsRequestor requestor, Exchange exchange) throws Exception {
        JmsRequestor jmsRequestor = requestor;
        synchronized (jmsRequestor) {
            this.decrementPendingExchangeIfNeeded(exchange);
            boolean rollbackOnErrors = exchange.getRole() == Role.Consumer ? Boolean.TRUE.equals(exchange.getProperty("ClusterRollbackOnErrors." + this.name)) : this.rollbackOnErrors;
            if (exchange.getStatus() == Status.Active) {
                boolean expectResponse;
                int type;
                org.apache.servicemix.nmr.api.Message msg = exchange.getFault(false);
                if (msg != null) {
                    type = 2;
                } else {
                    msg = exchange.getOut(false);
                    if (msg != null) {
                        type = 1;
                    } else {
                        msg = exchange.getIn(false);
                        if (msg != null) {
                            type = 0;
                        } else {
                            throw new IllegalStateException("No normalized message on an active exchange: " + exchange);
                        }
                    }
                }
                ObjectMessage message = requestor.getSession().createObjectMessage((Serializable)msg);
                message.setIntProperty(JBI_MESSAGE, type);
                if (type == 0) {
                    rollbackOnErrors = this.rollbackOnErrors;
                    exchange.setProperty("ClusterRollbackOnErrors." + this.name, (Object)rollbackOnErrors);
                    message.setStringProperty(JBI_MEP, exchange.getPattern().getWsdlUri());
                    if (exchange.getProperty("javax.jbi.InterfaceName") != null) {
                        message.setStringProperty(JBI_INTERFACE, exchange.getProperty("javax.jbi.InterfaceName").toString());
                    }
                    if (exchange.getOperation() != null) {
                        message.setStringProperty(JBI_OPERATION, exchange.getOperation().toString());
                    }
                    if (exchange.getProperty("javax.jbi.ServiceName") != null) {
                        message.setStringProperty(JBI_SERVICE, exchange.getProperty("javax.jbi.ServiceName").toString());
                    }
                    if (exchange.getProperty("javax.jbi.ServiceEndpoint") != null) {
                        ServiceEndpoint se = (ServiceEndpoint)exchange.getProperty("javax.jbi.ServiceEndpoint");
                        message.setStringProperty(JBI_ENDPOINT, "{" + se.getServiceName().toString() + "}" + se.getEndpointName());
                    }
                }
                message.setBooleanProperty(PROPERTY_ROLLBACK_ON_ERRORS, rollbackOnErrors);
                if (!rollbackOnErrors) {
                    expectResponse = true;
                } else {
                    switch (exchange.getPattern()) {
                        case InOnly: {
                            expectResponse = false;
                            break;
                        }
                        case RobustInOnly: {
                            expectResponse = exchange.getRole() == Role.Provider;
                            break;
                        }
                        case InOut: {
                            expectResponse = exchange.getRole() == Role.Provider;
                            break;
                        }
                        default: {
                            expectResponse = true;
                        }
                    }
                }
                if (expectResponse) {
                    this.exchanges.put(exchange.getId(), exchange);
                    message.setStringProperty(PROPERTY_SENDER_CLUSTER_NAME, this.name);
                    message.setStringProperty(PROPERTY_SENDER_CORR_ID, exchange.getId());
                    if (requestor.getMessage() != null) {
                        message.setStringProperty(PROPERTY_CLUSTER_NAME, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CLUSTER_NAME));
                        message.setStringProperty(PROPERTY_CORR_ID, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CORR_ID));
                    }
                    requestor.send((Message)message);
                } else {
                    message.setStringProperty(PROPERTY_SENDER_CLUSTER_NAME, this.name);
                    message.setStringProperty(PROPERTY_SENDER_CORR_ID, null);
                    if (requestor.getMessage() != null) {
                        message.setStringProperty(PROPERTY_CLUSTER_NAME, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CLUSTER_NAME));
                        message.setStringProperty(PROPERTY_CORR_ID, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CORR_ID));
                    }
                    requestor.send((Message)message);
                    this.done(exchange);
                }
            } else if (exchange.getStatus() == Status.Done) {
                boolean doSend;
                if (!rollbackOnErrors) {
                    doSend = true;
                } else {
                    switch (exchange.getPattern()) {
                        case InOnly: {
                            doSend = false;
                            break;
                        }
                        case RobustInOnly: {
                            doSend = exchange.getRole() == Role.Consumer;
                            break;
                        }
                        case InOptionalOut: {
                            doSend = true;
                            break;
                        }
                        case InOut: {
                            doSend = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported MEP: " + exchange.getPattern());
                        }
                    }
                }
                if (doSend) {
                    Message message = requestor.getSession().createMessage();
                    message.setIntProperty(JBI_MESSAGE, 3);
                    message.setStringProperty(PROPERTY_SENDER_CLUSTER_NAME, this.name);
                    message.setStringProperty(PROPERTY_SENDER_CORR_ID, null);
                    if (requestor.getMessage() != null) {
                        message.setStringProperty(PROPERTY_CLUSTER_NAME, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CLUSTER_NAME));
                        message.setStringProperty(PROPERTY_CORR_ID, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CORR_ID));
                    }
                    requestor.send(message);
                }
            } else if (exchange.getStatus() == Status.Error) {
                boolean doSend;
                if (!rollbackOnErrors) {
                    doSend = true;
                } else {
                    switch (exchange.getPattern()) {
                        case InOnly: {
                            doSend = false;
                            break;
                        }
                        case RobustInOnly: {
                            doSend = this.pool.getTransacted() == Transacted.None || exchange.getRole() != Role.Consumer;
                            break;
                        }
                        case InOptionalOut: {
                            doSend = true;
                            break;
                        }
                        case InOut: {
                            doSend = this.pool.getTransacted() == Transacted.None || exchange.getRole() != Role.Consumer;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported MEP: " + exchange.getPattern());
                        }
                    }
                }
                if (doSend) {
                    ObjectMessage message = requestor.getSession().createObjectMessage((Serializable)exchange.getError());
                    message.setIntProperty(JBI_MESSAGE, 4);
                    message.setStringProperty(PROPERTY_SENDER_CLUSTER_NAME, this.name);
                    message.setStringProperty(PROPERTY_SENDER_CORR_ID, null);
                    if (requestor.getMessage() != null) {
                        message.setStringProperty(PROPERTY_CLUSTER_NAME, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CLUSTER_NAME));
                        message.setStringProperty(PROPERTY_CORR_ID, requestor.getMessage().getStringProperty(PROPERTY_SENDER_CORR_ID));
                    }
                    requestor.send((Message)message);
                } else {
                    requestor.setRollbackOnly();
                }
            } else {
                throw new IllegalStateException("Unknown exchange status: " + exchange);
            }
        }
    }

    protected void decrementPendingExchangeIfNeeded(Exchange exchange) {
        if (exchange.getRole() == Role.Consumer && exchange.getStatus() != Status.Active && this.pendingExchanges.decrementAndGet() < this.maxPendingExchanges && this.pauseConsumption.compareAndSet(true, false)) {
            this.invalidateSelector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.servicemix.nmr.api.Message unmarshallMessage(Message message) throws JMSException {
        org.apache.servicemix.nmr.api.Message msg = null;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            msg = (org.apache.servicemix.nmr.api.Message)((ObjectMessage)message).getObject();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        return msg;
    }
}

