/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.osgi.config.internal.util.ParserUtils;
import org.springframework.osgi.config.internal.util.ServiceAttributeCallback;
import org.springframework.osgi.config.internal.util.ServiceParsingUtils;
import org.springframework.osgi.service.exporter.support.OsgiServiceFactoryBean;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String TARGET_BEAN_NAME_PROP = "targetBeanName";
    private static final String TARGET_PROP = "target";
    private static final String LISTENERS_PROP = "listeners";
    private static final String LISTENER = "registration-listener";
    private static final String REF = "ref";

    ServiceBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        return OsgiServiceFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParserUtils.parseCustomAttributes(element, builder, new ServiceAttributeCallback());
        Object target = null;
        if (element.hasAttribute(REF)) {
            target = new RuntimeBeanReference(element.getAttribute(REF));
        }
        NodeList nl = element.getChildNodes();
        ManagedList listeners = new ManagedList();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element subElement = (Element)node;
            String name = subElement.getLocalName();
            if (ServiceParsingUtils.parseInterfaces(element, subElement, parserContext, builder) || ServiceParsingUtils.parseServiceProperties(element, subElement, parserContext, builder)) continue;
            if (LISTENER.equals(name)) {
                listeners.add((Object)ServiceParsingUtils.parseListener(parserContext, subElement, builder));
                continue;
            }
            target = this.parseBeanReference(element, subElement, parserContext, builder);
        }
        if (target instanceof RuntimeBeanReference) {
            builder.addPropertyValue(TARGET_BEAN_NAME_PROP, (Object)target.getBeanName());
        } else {
            builder.addPropertyValue(TARGET_PROP, target);
        }
        builder.addPropertyValue(LISTENERS_PROP, (Object)listeners);
    }

    private Object parseBeanReference(Element parent, Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (parent.hasAttribute(REF)) {
            parserContext.getReaderContext().error("nested bean definition/reference cannot be used when attribute 'ref' is specified", (Object)parent);
        }
        return parserContext.getDelegate().parsePropertySubElement(element, (BeanDefinition)builder.getBeanDefinition());
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }
}

