/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.apache.servicemix.jbi.deployer.AdminCommandsService;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.artifacts.SharedLibraryImpl;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.impl.DeploymentService;
import org.apache.servicemix.jbi.deployer.impl.InstallationService;
import org.apache.servicemix.jbi.deployer.utils.ManagementSupport;
import org.apache.servicemix.nmr.management.Nameable;
import org.springframework.util.StringUtils;

public class AdminCommandsImpl
implements AdminCommandsService,
Nameable {
    private Deployer deployer;
    private InstallationService installationService;
    private DeploymentService deploymentService;

    public String installComponent(String file, Properties props, boolean deferException) throws Exception {
        try {
            this.getInstallationService().install(file, props, deferException);
            return ManagementSupport.createSuccessMessage("installComponent", file);
        }
        catch (Exception e) {
            throw ManagementSupport.failure("installComponent", file, e);
        }
    }

    public String uninstallComponent(String name) throws Exception {
        try {
            if (this.installationService.unloadInstaller(name, true)) {
                return ManagementSupport.createSuccessMessage("uninstallComponent", name);
            }
            throw ManagementSupport.failure("uninstallComponent", name);
        }
        catch (Exception e) {
            throw ManagementSupport.failure("uninstallComponent", name, e);
        }
    }

    public String installSharedLibrary(String file, boolean deferException) throws Exception {
        try {
            this.installationService.installSharedLibrary(file);
            return ManagementSupport.createSuccessMessage("installSharedLibrary", file);
        }
        catch (Exception e) {
            throw ManagementSupport.failure("installSharedLibrary", file, e);
        }
    }

    public String uninstallSharedLibrary(String name) throws Exception {
        try {
            this.getInstallationService().doUninstallSharedLibrary(name);
            return ManagementSupport.createSuccessMessage("uninstallSharedLibrary", name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("uninstallSharedLibrary", name, e);
        }
    }

    public String startComponent(String name) throws Exception {
        ComponentImpl component = this.deployer.getComponent(name);
        if (component == null) {
            throw ManagementSupport.failure("start", "Component does not exist: " + name);
        }
        try {
            component.start();
            return ManagementSupport.createSuccessMessage("Component started", name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("startComponent", name, e);
        }
    }

    public String stopComponent(String name) throws Exception {
        ComponentImpl component = this.deployer.getComponent(name);
        if (component == null) {
            throw ManagementSupport.failure("stop", "Component does not exist: " + name);
        }
        try {
            component.stop();
            return ManagementSupport.createSuccessMessage("Component stopped", name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("stopComponent", name, e);
        }
    }

    public String shutdownComponent(String name) throws Exception {
        ComponentImpl component = this.deployer.getComponent(name);
        if (component == null) {
            throw ManagementSupport.failure("shutdown", "Component does not exist: " + name);
        }
        try {
            component.shutDown();
            return ManagementSupport.createSuccessMessage("Component shut down", name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("shutdownComponent", name, e);
        }
    }

    public String deployServiceAssembly(String file, boolean deferException) throws Exception {
        try {
            return this.deploymentService.deploy(file, deferException);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("deployServiceAssembly", file, e);
        }
    }

    public String undeployServiceAssembly(String name) throws Exception {
        ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(name);
        if (sa == null) {
            throw ManagementSupport.failure("start", "Service assembly does not exist: " + name);
        }
        try {
            return this.getDeploymentService().undeploy(name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("undeployServiceAssembly", name, e);
        }
    }

    public String startServiceAssembly(String name) throws Exception {
        ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(name);
        if (sa == null) {
            throw ManagementSupport.failure("start", "Service assembly does not exist: " + name);
        }
        try {
            sa.start();
            return ManagementSupport.createSuccessMessage("Service assembly started", name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("startServiceAssembly", name, e);
        }
    }

    public String stopServiceAssembly(String name) throws Exception {
        ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(name);
        if (sa == null) {
            throw ManagementSupport.failure("stop", "Service assembly does not exist: " + name);
        }
        try {
            sa.stop();
            return ManagementSupport.createSuccessMessage("Service assembly stopped", name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("stopServiceAssembly", name, e);
        }
    }

    public String shutdownServiceAssembly(String name) throws Exception {
        ServiceAssemblyImpl sa = this.deployer.getServiceAssembly(name);
        if (sa == null) {
            throw ManagementSupport.failure("shutdown", "Service assembly does not exist: " + name);
        }
        try {
            sa.shutDown();
            return ManagementSupport.createSuccessMessage("Service assembly shut down", name);
        }
        catch (Throwable e) {
            throw ManagementSupport.failure("shutdownServiceAssembly", name, e);
        }
    }

    public String listComponents(boolean excludeSEs, boolean excludeBCs, boolean excludePojos, String requiredState, String sharedLibraryName, String serviceAssemblyName) throws Exception {
        if (!(requiredState == null || requiredState.length() <= 0 || "Unknown".equalsIgnoreCase(requiredState) || "Shutdown".equalsIgnoreCase(requiredState) || "Stopped".equalsIgnoreCase(requiredState) || "Started".equalsIgnoreCase(requiredState))) {
            throw ManagementSupport.failure("listComponents", "Required state '" + requiredState + "' is not a valid state.");
        }
        ArrayList<ComponentImpl> components = new ArrayList<ComponentImpl>();
        for (ComponentImpl component : this.deployer.getComponents().values()) {
            boolean bl;
            if (excludeSEs && "service-engine".equals(component.getMainType()) || excludeBCs && "binding-component".equals(component.getMainType()) || requiredState != null && requiredState.length() > 0 && !requiredState.equalsIgnoreCase(component.getCurrentState())) continue;
            if (StringUtils.hasLength((String)sharedLibraryName)) {
                bl = false;
                for (SharedLibrary lib : component.getSharedLibraries()) {
                    if (!sharedLibraryName.equals(lib.getName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (StringUtils.hasLength((String)serviceAssemblyName)) {
                bl = false;
                for (ServiceUnit su : component.getServiceUnits()) {
                    if (!serviceAssemblyName.equals(su.getServiceAssembly().getName())) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            components.add(component);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>\n");
        buffer.append("<component-info-list xmlns='http://java.sun.com/xml/ns/jbi/component-info-list' version='1.0'>\n");
        for (Component component : components) {
            buffer.append("  <component-info");
            buffer.append(" type='").append(component.getMainType()).append("'");
            buffer.append(" name='").append(component.getName()).append("'");
            buffer.append(" state='").append(component.getCurrentState()).append("'>\n");
            buffer.append("    <description>");
            if (component.getDescription() != null) {
                buffer.append(component.getDescription());
            }
            buffer.append("</description>\n");
            buffer.append("  </component-info>\n");
        }
        buffer.append("</component-info-list>");
        return buffer.toString();
    }

    public String listSharedLibraries(String componentName, String sharedLibraryName) throws Exception {
        HashSet<SharedLibrary> libs = new HashSet<SharedLibrary>();
        if (sharedLibraryName != null && sharedLibraryName.length() > 0) {
            SharedLibraryImpl lib = this.getDeployer().getSharedLibrary(sharedLibraryName);
            if (lib != null) {
                libs.add(lib);
            }
        } else if (componentName != null && componentName.length() > 0) {
            ComponentImpl component = this.deployer.getComponent(componentName);
            if (component != null) {
                for (SharedLibrary lib : component.getSharedLibraries()) {
                    libs.add(lib);
                }
            }
        } else {
            libs.addAll(this.getDeployer().getSharedLibraries().values());
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>\n");
        buffer.append("<component-info-list xmlns='http://java.sun.com/xml/ns/jbi/component-info-list' version='1.0'>\n");
        for (SharedLibrary sl : libs) {
            buffer.append("  <component-info type='shared-library' name='").append(sl.getName()).append("' state='Started'>\n");
            buffer.append("    <description>").append(sl.getDescription()).append("</description>\n");
            buffer.append("  </component-info>\n");
        }
        buffer.append("</component-info-list>");
        return buffer.toString();
    }

    public String listServiceAssemblies(String state, String componentName, String serviceAssemblyName) throws Exception {
        ArrayList<ServiceAssemblyImpl> assemblies = new ArrayList<ServiceAssemblyImpl>();
        ComponentImpl component = null;
        if (StringUtils.hasLength((String)componentName)) {
            component = this.deployer.getComponent(componentName);
        }
        for (ServiceAssemblyImpl sa : this.deployer.getServiceAssemblies().values()) {
            boolean bl = true;
            if (StringUtils.hasLength((String)serviceAssemblyName)) {
                bl = serviceAssemblyName.equals(sa.getName());
            }
            if (bl && StringUtils.hasLength((String)state)) {
                bl = state.equalsIgnoreCase(sa.getCurrentState());
            }
            if (bl && StringUtils.hasLength((String)componentName)) {
                bl = false;
                if (component != null) {
                    for (ServiceUnit su : component.getServiceUnits()) {
                        if (!sa.getName().equals(su.getServiceAssembly().getName())) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (!bl) continue;
            assemblies.add(sa);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>\n");
        buffer.append("<service-assembly-info-list xmlns='http://java.sun.com/xml/ns/jbi/service-assembly-info-list' version='1.0'>\n");
        for (ServiceAssembly serviceAssembly : assemblies) {
            buffer.append("  <service-assembly-info");
            buffer.append(" name='").append(serviceAssembly.getName()).append("'");
            buffer.append(" state='").append(serviceAssembly.getCurrentState()).append("'>\n");
            buffer.append("    <description>").append(serviceAssembly.getDescription()).append("</description>\n");
            for (ServiceUnit su : serviceAssembly.getServiceUnits()) {
                buffer.append("    <service-unit-info");
                buffer.append(" name='").append(su.getName()).append("'");
                buffer.append(" state='").append(serviceAssembly.getCurrentState()).append("'");
                buffer.append(" deployed-on='").append(su.getComponent().getName()).append("'>\n");
                buffer.append("      <description>").append(su.getDescription()).append("</description>\n");
                buffer.append("    </service-unit-info>\n");
            }
            buffer.append("  </service-assembly-info>\n");
        }
        buffer.append("</service-assembly-info-list>");
        return buffer.toString();
    }

    public void init() throws Exception {
        this.deployer.getManagementStrategy().manageObject((Object)this);
    }

    public void destroy() throws Exception {
        try {
            this.deployer.getManagementStrategy().unmanageObject((Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInstallationService(InstallationService installationService) {
        this.installationService = installationService;
    }

    public InstallationService getInstallationService() {
        return this.installationService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    public String getParent() {
        return "ServiceMix";
    }

    public String getName() {
        return "AdminCommandsService";
    }

    public String getMainType() {
        return "SystemService";
    }

    public String getSubType() {
        return null;
    }

    public Class getPrimaryInterface() {
        return AdminCommandsService.class;
    }

    public String getVersion() {
        return null;
    }
}

