/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.JBIException;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.DeployedAssembly;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.deployer.artifacts.AbstractLifecycleJbiArtifact;
import org.apache.servicemix.jbi.deployer.artifacts.AssemblyReferencesListener;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceUnitImpl;
import org.apache.servicemix.jbi.deployer.artifacts.SharedLibraryImpl;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.DescriptorFactory;
import org.apache.servicemix.jbi.deployer.descriptor.Identification;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceAssemblyDesc;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.descriptor.SharedLibraryDesc;
import org.apache.servicemix.jbi.deployer.descriptor.Target;
import org.apache.servicemix.jbi.deployer.events.LifeCycleEvent;
import org.apache.servicemix.jbi.deployer.events.LifeCycleListener;
import org.apache.servicemix.jbi.deployer.impl.AbstractInstaller;
import org.apache.servicemix.jbi.deployer.impl.ComponentInstaller;
import org.apache.servicemix.jbi.deployer.impl.PendingException;
import org.apache.servicemix.jbi.deployer.impl.ServiceAssemblyInstaller;
import org.apache.servicemix.jbi.deployer.impl.SharedLibraryInstaller;
import org.apache.servicemix.jbi.runtime.ComponentWrapper;
import org.apache.servicemix.jbi.runtime.Environment;
import org.apache.servicemix.nmr.api.event.Listener;
import org.apache.servicemix.nmr.api.event.ListenerRegistry;
import org.apache.servicemix.nmr.core.ListenerRegistryImpl;
import org.fusesource.commons.management.ManagementStrategy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.osgi.util.OsgiStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployer
implements SynchronousBundleListener,
LifeCycleListener {
    public static final String NAME = "NAME";
    public static final String TYPE = "TYPE";
    public static final String TYPE_SERVICE_ENGINE = "service-engine";
    public static final String TYPE_BINDING_COMPONENT = "binding-component";
    private static final Log LOGGER = LogFactory.getLog(Deployer.class);
    private BundleContext bundleContext;
    private final Set<Bundle> bundles = new HashSet<Bundle>();
    private final Map<String, SharedLibraryImpl> sharedLibraries = new ConcurrentHashMap<String, SharedLibraryImpl>();
    private final Map<String, ComponentImpl> components = new ConcurrentHashMap<String, ComponentImpl>();
    private final Map<String, ServiceAssemblyImpl> serviceAssemblies = new ConcurrentHashMap<String, ServiceAssemblyImpl>();
    private final Map<Bundle, AbstractInstaller> installers = new ConcurrentHashMap<Bundle, AbstractInstaller>();
    private final ThreadLocal<AbstractInstaller> jmxManaged = new ThreadLocal();
    private final Map<String, Boolean> wrappedComponents = new ConcurrentHashMap<String, Boolean>();
    private final Map<Bundle, List<ServiceRegistration>> services = new ConcurrentHashMap<Bundle, List<ServiceRegistration>>();
    private final Set<AbstractInstaller> pendingInstallers = new HashSet<AbstractInstaller>();
    private final Set<ServiceAssemblyImpl> pendingAssemblies = new HashSet<ServiceAssemblyImpl>();
    private File jbiRootDir = new File(System.getProperty("karaf.base"), "data/jbi");
    private PreferencesService preferencesService;
    private boolean autoStart = true;
    private ServiceTracker deployedComponentsTracker;
    private ServiceTracker deployedAssembliesTracker;
    private AssemblyReferencesListener endpointListener;
    private int shutdownTimeout;
    private ManagementStrategy managementStrategy;
    private Environment environment;
    private ListenerRegistry listenerRegistry;
    private MBeanServer mbeanServer;

    public Deployer() throws JBIException {
        this.jbiRootDir.mkdirs();
        this.listenerRegistry = new ListenerRegistryImpl();
        this.listenerRegistry.register((Listener)this, null);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public PreferencesService getPreferencesService() {
        return this.preferencesService;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setEndpointListener(AssemblyReferencesListener endpointListener) {
        this.endpointListener = endpointListener;
    }

    public AssemblyReferencesListener getEndpointListener() {
        return this.endpointListener;
    }

    public ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    protected AbstractInstaller getJmxManaged() {
        return this.jmxManaged.get();
    }

    public void setJmxManaged(AbstractInstaller installer) {
        this.jmxManaged.set(installer);
    }

    public Map<String, SharedLibraryImpl> getSharedLibraries() {
        return this.sharedLibraries;
    }

    public Map<String, ComponentImpl> getComponents() {
        return this.components;
    }

    public Map<String, ServiceAssemblyImpl> getServiceAssemblies() {
        return this.serviceAssemblies;
    }

    public SharedLibraryImpl getSharedLibrary(String name) {
        return name != null ? this.sharedLibraries.get(name) : null;
    }

    public ComponentImpl getComponent(String name) {
        return name != null ? this.components.get(name) : null;
    }

    public ServiceAssemblyImpl getServiceAssembly(String name) {
        return name != null ? this.serviceAssemblies.get(name) : null;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void init() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.bundleChanged(new BundleEvent(2, bundle));
        }
        this.deployedComponentsTracker = new ServiceTracker(this.bundleContext, javax.jbi.component.Component.class.getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                Object o = super.addingService(serviceReference);
                Deployer.this.registerDeployedComponent(serviceReference, (javax.jbi.component.Component)o);
                return o;
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                Deployer.this.unregisterDeployedComponent(serviceReference, (javax.jbi.component.Component)o);
                super.removedService(serviceReference, o);
            }
        };
        this.deployedComponentsTracker.open();
        this.deployedAssembliesTracker = new ServiceTracker(this.bundleContext, DeployedAssembly.class.getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                Object o = super.addingService(serviceReference);
                Deployer.this.registerDeployedServiceAssembly(serviceReference, (DeployedAssembly)o);
                return o;
            }

            public void removedService(ServiceReference serviceReference, Object o) {
                Deployer.this.unregisterDeployedServiceAssembly(serviceReference, (DeployedAssembly)o);
                super.removedService(serviceReference, o);
            }
        };
        this.deployedAssembliesTracker.open();
    }

    public synchronized void destroy() throws Exception {
        for (Bundle bundle : this.bundles) {
            this.bundleChanged(new BundleEvent(256, bundle));
        }
        this.deployedComponentsTracker.close();
        this.deployedAssembliesTracker.close();
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                if (!this.match(event.getBundle())) break;
                this.bundles.add(event.getBundle());
                this.onBundleStarted(event.getBundle());
                break;
            }
            case 256: {
                if (!this.bundles.contains(event.getBundle())) break;
                this.onBundleStopping(event.getBundle());
                break;
            }
            case 16: {
                if (!this.bundles.remove(event.getBundle())) break;
                this.onBundleUninstalled(event.getBundle());
            }
        }
    }

    protected boolean match(Bundle bundle) {
        LOGGER.debug((Object)("Checking bundle: '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "'"));
        URL url = bundle.getResource("META-INF/jbi.xml");
        if (url == null) {
            LOGGER.debug((Object)("Bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' does not contain any JBI descriptor."));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onBundleStarted(Bundle bundle) {
        AbstractInstaller installer = this.getJmxManaged();
        if (installer != null) {
            this.installers.put(bundle, installer);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                installer = this.installers.get(bundle);
                if (installer == null) {
                    URL url = bundle.getResource("META-INF/jbi.xml");
                    Descriptor descriptor = DescriptorFactory.buildDescriptor(url);
                    DescriptorFactory.checkDescriptor(descriptor);
                    if (descriptor.getSharedLibrary() != null) {
                        LOGGER.info((Object)("Deploying bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' as a JBI shared library"));
                        installer = new SharedLibraryInstaller(this, descriptor, null, true);
                    } else if (descriptor.getComponent() != null) {
                        LOGGER.info((Object)("Deploying bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' as a JBI component"));
                        installer = new ComponentInstaller(this, descriptor, null, true);
                    } else if (descriptor.getServiceAssembly() != null) {
                        LOGGER.info((Object)("Deploying bundle '" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "' as a JBI service assembly"));
                        installer = new ServiceAssemblyInstaller(this, descriptor, (File)null, true);
                    } else {
                        throw new IllegalStateException("Unrecognized JBI descriptor: " + url);
                    }
                    installer.setBundle(bundle);
                }
                try {
                    installer.init();
                    installer.install();
                    this.installers.put(bundle, installer);
                }
                catch (PendingException e) {
                    this.pendingInstallers.add(installer);
                    LOGGER.warn((Object)("Requirements not met for JBI artifact in bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + ". Installation pending. " + e));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error handling bundle start event", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    protected void onBundleStopping(Bundle bundle) {
        AbstractInstaller installer = this.getJmxManaged();
        if (installer == null && (installer = this.installers.get(bundle)) != null) {
            try {
                installer.stop(true);
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Error shutting down JBI artifact", (Throwable)e);
            }
        }
        this.unregisterServices(bundle);
    }

    protected void onBundleUninstalled(Bundle bundle) {
        AbstractInstaller installer = this.getJmxManaged();
        if (installer == null) {
            installer = this.installers.remove(bundle);
            if (installer != null) {
                try {
                    this.pendingInstallers.remove(installer);
                    installer.setUninstallFromOsgi(true);
                    installer.uninstall(true);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Error uninstalling JBI artifact", (Throwable)e);
                }
            }
        } else {
            this.installers.remove(bundle);
        }
    }

    public ServiceUnitImpl createServiceUnit(ServiceUnitDesc sud, File suRootDir, ComponentImpl component) {
        return new ServiceUnitImpl(sud, suRootDir, component);
    }

    public SharedLibraryImpl registerSharedLibrary(Bundle bundle, SharedLibraryDesc sharedLibraryDesc, ClassLoader classLoader) throws Exception {
        SharedLibraryImpl sl = new SharedLibraryImpl(bundle, sharedLibraryDesc, classLoader);
        this.sharedLibraries.put(sl.getName(), sl);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(NAME, sharedLibraryDesc.getIdentification().getName());
        LOGGER.debug((Object)"Registering JBI Shared Library");
        this.registerService(bundle, SharedLibrary.class.getName(), (Object)sl, props);
        this.getManagementStrategy().manageObject((Object)sl);
        this.checkPendingInstallers();
        return sl;
    }

    public ComponentImpl registerComponent(Bundle bundle, ComponentDesc componentDesc, javax.jbi.component.Component innerComponent, SharedLibrary[] sharedLibraries) throws Exception {
        String name = componentDesc.getIdentification().getName();
        Preferences prefs = this.preferencesService.getUserPreferences(name);
        ComponentImpl component = new ComponentImpl(bundle, componentDesc, innerComponent, prefs, this.autoStart, sharedLibraries);
        component.setListenerRegistry(this.listenerRegistry);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(NAME, name);
        ((Dictionary)props).put(TYPE, componentDesc.getType());
        for (SharedLibrary lib : sharedLibraries) {
            ((SharedLibraryImpl)lib).addComponent(component);
        }
        this.components.put(name, component);
        LOGGER.debug((Object)"Registering JBI component");
        this.registerService(bundle, new String[]{Component.class.getName(), ComponentWrapper.class.getName()}, (Object)component, props);
        if (!this.wrappedComponents.containsKey(name)) {
            this.registerService(bundle, javax.jbi.component.Component.class.getName(), (Object)innerComponent, props);
        }
        this.getManagementStrategy().manageObject((Object)component);
        return component;
    }

    public ServiceAssemblyImpl registerServiceAssembly(Bundle bundle, ServiceAssemblyDesc serviceAssemblyDesc, List<ServiceUnitImpl> sus) throws Exception {
        Preferences prefs = this.preferencesService.getUserPreferences(serviceAssemblyDesc.getIdentification().getName());
        ServiceAssemblyImpl sa = new ServiceAssemblyImpl(bundle, serviceAssemblyDesc, sus, prefs, this.endpointListener, this.autoStart);
        sa.setShutdownTimeout(this.shutdownTimeout);
        sa.setListenerRegistry(this.listenerRegistry);
        sa.init();
        this.serviceAssemblies.put(sa.getName(), sa);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put(NAME, serviceAssemblyDesc.getIdentification().getName());
        LOGGER.debug((Object)"Registering JBI service assembly");
        this.registerService(bundle, ServiceAssembly.class.getName(), (Object)sa, props);
        this.getManagementStrategy().manageObject((Object)sa);
        return sa;
    }

    protected void unregisterComponent(ComponentImpl component) {
        if (component != null) {
            try {
                component.stop(false);
                component.shutDown(false, true);
                HashSet<ServiceAssemblyImpl> sas = new HashSet<ServiceAssemblyImpl>();
                for (ServiceUnit su : component.getServiceUnits()) {
                    sas.add((ServiceAssemblyImpl)su.getServiceAssembly());
                }
                for (ServiceAssemblyImpl sa : sas) {
                    Bundle bundle = sa.getBundle();
                    ServiceAssemblyInstaller installer = (ServiceAssemblyInstaller)this.installers.get(bundle);
                    if (installer == null) continue;
                    try {
                        installer.stop(true);
                        this.pendingAssemblies.remove(sa);
                        if (installer.getDeployedAssembly() == null) {
                            this.unregisterServiceAssembly(sa);
                            this.pendingInstallers.add(installer);
                            continue;
                        }
                        this.installers.remove(bundle);
                    }
                    catch (Exception e) {
                        LOGGER.warn((Object)"Error uninstalling service assembly", (Throwable)e);
                    }
                }
                this.unregisterServices(component.getBundle());
            }
            catch (JBIException e) {
                LOGGER.warn((Object)"Error when shutting down component", (Throwable)e);
            }
            for (SharedLibrary lib : component.getSharedLibraries()) {
                ((SharedLibraryImpl)lib).removeComponent(component);
            }
            this.components.remove(component.getName());
            try {
                this.getManagementStrategy().unmanageObject((Object)component);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error unmanage component: " + component.getName()), (Throwable)e);
            }
        }
    }

    protected void unregisterServiceAssembly(ServiceAssemblyImpl assembly) {
        if (assembly != null) {
            this.serviceAssemblies.remove(assembly.getName());
            this.pendingAssemblies.remove(assembly);
            this.unregisterServices(assembly.getBundle());
            try {
                this.getManagementStrategy().unmanageObject((Object)assembly);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error unmanage service assembly: " + assembly.getName()), (Throwable)e);
            }
            for (ServiceUnitImpl su : assembly.getServiceUnitsList()) {
                su.getComponentImpl().removeServiceUnit(su);
            }
        }
    }

    protected void unregisterSharedLibrary(SharedLibrary library) {
        if (library != null) {
            this.sharedLibraries.remove(library.getName());
            try {
                this.getManagementStrategy().unmanageObject((Object)library);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error unmanage sharedlibrary: " + library.getName()), (Throwable)e);
            }
        }
    }

    public AbstractInstaller getInstaller(Object o) {
        if (o instanceof SharedLibraryImpl) {
            return this.installers.get(((SharedLibraryImpl)o).getBundle());
        }
        if (o instanceof ComponentImpl) {
            return this.installers.get(((ComponentImpl)o).getBundle());
        }
        if (o instanceof ServiceAssemblyImpl) {
            return this.installers.get(((ServiceAssemblyImpl)o).getBundle());
        }
        return null;
    }

    protected void checkPendingInstallers() {
        if (!this.pendingInstallers.isEmpty()) {
            ArrayList<AbstractInstaller> pending = new ArrayList<AbstractInstaller>(this.pendingInstallers);
            this.pendingInstallers.clear();
            for (AbstractInstaller installer : pending) {
                try {
                    installer.init();
                    installer.install();
                    this.installers.put(installer.getBundle(), installer);
                }
                catch (PendingException e) {
                    this.pendingInstallers.add(installer);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Error installing JBI artifact", (Throwable)e);
                }
            }
        }
    }

    protected void checkPendingAssemblies() {
        ArrayList<ServiceAssemblyImpl> sas = new ArrayList<ServiceAssemblyImpl>(this.pendingAssemblies);
        this.pendingAssemblies.clear();
        for (ServiceAssemblyImpl sa : sas) {
            try {
                sa.init();
            }
            catch (JBIException e) {
                this.pendingAssemblies.add(sa);
            }
        }
    }

    @Override
    public void lifeCycleChanged(LifeCycleEvent event) throws JBIException {
        if (event.getLifeCycleMBean() instanceof ComponentImpl) {
            ComponentImpl comp = (ComponentImpl)event.getLifeCycleMBean();
            switch (event.getType()) {
                case Stopping: {
                    if (comp.getState() != AbstractLifecycleJbiArtifact.State.Started) break;
                    for (ServiceAssemblyImpl sa : comp.getServiceAssemblies()) {
                        if (sa.getState() != AbstractLifecycleJbiArtifact.State.Started) continue;
                        sa.stop(false);
                        this.pendingAssemblies.add(sa);
                    }
                    break;
                }
                case ShuttingDown: {
                    if (comp.getState() != AbstractLifecycleJbiArtifact.State.Stopped) break;
                    for (ServiceAssemblyImpl sa : comp.getServiceAssemblies()) {
                        if (sa.getState() != AbstractLifecycleJbiArtifact.State.Stopped) continue;
                        sa.shutDown(false, event.isForced());
                        this.pendingAssemblies.add(sa);
                    }
                    break;
                }
                case Started: {
                    this.checkPendingInstallers();
                    this.checkPendingAssemblies();
                }
            }
        }
        try {
            this.getManagementStrategy().notify((EventObject)event);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void registerDeployedComponent(ServiceReference reference, javax.jbi.component.Component component) {
        String name = (String)reference.getProperty(NAME);
        if (name != null && !this.components.containsKey(name)) {
            String type = (String)reference.getProperty(TYPE);
            Descriptor descriptor = new Descriptor();
            ComponentDesc componentDesc = new ComponentDesc();
            componentDesc.setIdentification(new Identification());
            componentDesc.getIdentification().setName(name);
            componentDesc.setType(type);
            descriptor.setComponent(componentDesc);
            try {
                this.wrappedComponents.put(name, true);
                ComponentInstaller installer = new ComponentInstaller(this, descriptor, null, this.autoStart);
                installer.setBundle(reference.getBundle());
                installer.setInnerComponent(component);
                installer.init();
                installer.install();
                this.bundles.add(reference.getBundle());
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Error registering deployed component", (Throwable)e);
            }
        }
    }

    protected void unregisterDeployedComponent(ServiceReference reference, javax.jbi.component.Component component) {
        String name = (String)reference.getProperty(NAME);
        if (name != null) {
            this.wrappedComponents.remove(name);
            this.unregisterComponent(this.getComponent(name));
        }
    }

    public void registerDeployedServiceAssembly(ServiceReference reference, DeployedAssembly assembly) {
        try {
            ServiceAssemblyDesc desc = new ServiceAssemblyDesc();
            desc.setIdentification(new Identification());
            desc.getIdentification().setName(assembly.getName());
            ArrayList<ServiceUnitDesc> sus = new ArrayList<ServiceUnitDesc>();
            for (Map.Entry<String, String> unit : assembly.getServiceUnits().entrySet()) {
                ServiceUnitDesc suDesc = new ServiceUnitDesc();
                suDesc.setIdentification(new Identification());
                suDesc.getIdentification().setName(unit.getKey());
                suDesc.setTarget(new Target());
                suDesc.getTarget().setComponentName(unit.getValue());
                sus.add(suDesc);
            }
            desc.setServiceUnits(sus.toArray(new ServiceUnitDesc[sus.size()]));
            Descriptor descriptor = new Descriptor();
            descriptor.setServiceAssembly(desc);
            ServiceAssemblyInstaller installer = new ServiceAssemblyInstaller(this, descriptor, assembly, this.autoStart);
            installer.setBundle(reference.getBundle());
            try {
                installer.init();
                installer.install();
                this.installers.put(installer.getBundle(), installer);
            }
            catch (PendingException e) {
                this.pendingInstallers.add(installer);
                LOGGER.warn((Object)("Requirements not met for JBI artifact in bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)reference.getBundle()) + ". Installation pending. " + e));
            }
            this.bundles.add(reference.getBundle());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error registering deployed service assembly", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDeployedServiceAssembly(ServiceReference reference, DeployedAssembly assembly) {
        ServiceAssemblyImpl sa = this.getServiceAssembly(assembly.getName());
        if (sa != null) {
            try {
                if (sa.getState() == AbstractLifecycleJbiArtifact.State.Started) {
                    sa.stop(false);
                }
                if (sa.getState() == AbstractLifecycleJbiArtifact.State.Stopped) {
                    sa.shutDown(false, true);
                }
                for (ServiceUnitImpl su : sa.getServiceUnitsList()) {
                    su.undeploy();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error unregistering deployed service assembly", (Throwable)e);
            }
            finally {
                this.unregisterServiceAssembly(sa);
            }
        }
    }

    protected void registerService(Bundle bundle, String clazz, Object service, Dictionary props) {
        this.registerService(bundle, new String[]{clazz}, service, props);
    }

    protected void registerService(Bundle bundle, String[] clazz, Object service, Dictionary props) {
        BundleContext context = bundle.getBundleContext() != null ? bundle.getBundleContext() : this.getBundleContext();
        ServiceRegistration reg = context.registerService(clazz, service, props);
        List<ServiceRegistration> registrations = this.services.get(bundle);
        if (registrations == null) {
            registrations = new ArrayList<ServiceRegistration>();
            this.services.put(bundle, registrations);
        }
        registrations.add(reg);
    }

    protected void unregisterServices(Bundle bundle) {
        List<ServiceRegistration> registrations = this.services.remove(bundle);
        if (registrations != null && bundle.getState() != 4) {
            for (ServiceRegistration reg : registrations) {
                try {
                    reg.unregister();
                }
                catch (IllegalStateException e) {}
            }
        }
    }
}

