/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.internal.MessageFormatter;
import org.apache.log4j.spi.LoggerFactory;
import org.ops4j.pax.logging.DefaultServiceLog;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.osgi.framework.BundleContext;

public class Logger
extends Category {
    private static final String LOG4J_FQCN = Logger.class.getName();
    private static PaxLoggingManager m_paxLogging;
    private static Map m_loggers;

    public static void setBundleContext(BundleContext ctx) {
        m_paxLogging = new OSGIPaxLoggingManager(ctx);
        Set entrySet = m_loggers.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Logger logger = (Logger)entry.getKey();
            String name = (String)entry.getValue();
            logger.setPaxLoggingManager(m_paxLogging, name);
        }
        m_paxLogging.open();
    }

    private void setPaxLoggingManager(PaxLoggingManager loggingManager, String name) {
        this.m_delegate = loggingManager.getLogger(name, LOG4J_FQCN);
    }

    public static void release() {
        m_paxLogging.close();
        m_paxLogging.dispose();
        m_paxLogging = null;
    }

    private Logger(PaxLogger delegate) {
        super(delegate);
    }

    public static Logger getLogger(String name) {
        PaxLogger paxLogger = m_paxLogging == null ? new DefaultServiceLog(null, name) : m_paxLogging.getLogger(name, LOG4J_FQCN);
        Logger logger = new Logger(paxLogger);
        m_loggers.put(logger, name);
        return logger;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return Logger.getLogger("");
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return Logger.getLogger(name);
    }

    public void trace(Object message) {
        if (this.m_delegate.isTraceEnabled() && message != null) {
            this.m_delegate.trace(message.toString(), null);
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.m_delegate.isTraceEnabled()) {
            if (message != null) {
                this.m_delegate.trace(message.toString(), t);
            } else {
                this.m_delegate.trace(null, t);
            }
        }
    }

    public void trace(Object messagePattern, Object arg) {
        if (this.m_delegate.isTraceEnabled() && messagePattern != null) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.trace(msgStr, null);
        }
    }

    public void trace(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isTraceEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.trace(msgStr, null);
        }
    }

    public void fatal(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isFatalEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.fatal(msgStr, null);
        }
    }

    public void debug(Object messagePattern, Object arg) {
        if (this.m_delegate.isDebugEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.debug(msgStr, null);
        }
    }

    public void debug(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isDebugEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.debug(msgStr, null);
        }
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public void error(Object messagePattern, Object arg) {
        if (this.m_delegate.isErrorEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.error(msgStr, null);
        }
    }

    public void error(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isErrorEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.error(msgStr, null);
        }
    }

    public void fatal(Object messagePattern, Object arg) {
        if (this.m_delegate.isFatalEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.fatal(msgStr, null);
        }
    }

    public void info(Object messagePattern, Object arg) {
        if (this.m_delegate.isInfoEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.inform(msgStr, null);
        }
    }

    public void info(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isInfoEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.inform(msgStr, null);
        }
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public boolean isEnabledFor(Priority priority) {
        if (priority == Level.FATAL) {
            return this.m_delegate.isFatalEnabled();
        }
        if (priority == Level.ERROR) {
            return this.m_delegate.isErrorEnabled();
        }
        if (priority == Level.WARN) {
            return this.m_delegate.isWarnEnabled();
        }
        if (priority == Level.INFO) {
            return this.m_delegate.isDebugEnabled();
        }
        if (priority == Level.DEBUG) {
            return this.m_delegate.isDebugEnabled();
        }
        if (priority == Level.ALL) {
            return this.m_delegate.isTraceEnabled();
        }
        return false;
    }

    public void warn(Object messagePattern, Object arg) {
        if (this.m_delegate.isWarnEnabled()) {
            String msgStr = (String)messagePattern;
            msgStr = MessageFormatter.format(msgStr, arg);
            this.m_delegate.warn(msgStr, null);
        }
    }

    public void warn(String messagePattern, Object arg1, Object arg2) {
        if (this.m_delegate.isWarnEnabled()) {
            String msgStr = MessageFormatter.format(messagePattern, arg1, arg2);
            this.m_delegate.warn(msgStr, null);
        }
    }

    public void debug(Object message) {
        super.debug(message);
    }

    public void debug(Object message, Throwable t) {
        super.debug(message, t);
    }

    public void error(Object message) {
        super.error(message);
    }

    public void error(Object message, Throwable t) {
        super.error(message, t);
    }

    public void fatal(Object message) {
        super.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        super.fatal(message, t);
    }

    public void info(Object message) {
        super.info(message);
    }

    public void info(Object message, Throwable t) {
        super.info(message, t);
    }

    public void warn(Object message) {
        super.warn(message);
    }

    public void warn(Object message, Throwable t) {
        super.warn(message, t);
    }

    static {
        m_loggers = Collections.synchronizedMap(new WeakHashMap());
    }
}

