/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.jbi.component.ComponentContext;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.management.ManagedEndpoint;
import org.apache.servicemix.nmr.management.Nameable;
import org.apache.servicemix.nmr.management.NamingStrategy;
import org.apache.servicemix.nmr.management.stats.CountStatistic;
import org.apache.servicemix.nmr.management.stats.TimeStatistic;
import org.fusesource.commons.management.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.jmx.export.annotation.AnnotationJmxAttributeSource;
import org.springframework.jmx.export.assembler.MetadataMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxAttributeSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementAgent
implements ManagementStrategy,
DisposableBean {
    private static final transient Log LOG = LogFactory.getLog(ManagementAgent.class);
    private boolean enabled;
    private MBeanServer mbeanServer;
    private MetadataMBeanInfoAssembler assembler;
    private Set<ObjectName> mbeans = new HashSet<ObjectName>();
    private NamingStrategy namingStrategy;
    private BundleContext bundleContext;
    private ServiceRegistration serviceRegistration;

    public ManagementAgent() {
        this.assembler = new MetadataMBeanInfoAssembler();
        this.assembler.setAttributeSource((JmxAttributeSource)new AnnotationJmxAttributeSource());
    }

    public void manageObject(Object managedObject) throws Exception {
        ObjectName objectName = this.getManagedObjectName(managedObject, null, ObjectName.class);
        this.manageNamedObject(managedObject, objectName);
    }

    public <T> T getManagedObjectName(Object managableObject, String customName, Class<T> nameType) throws Exception {
        return String.class.equals(nameType) && managableObject == null && customName == null ? (T)nameType.cast(this.namingStrategy.getJmxDomainName()) : (ObjectName.class.equals(nameType) ? (T)nameType.cast(this.getTypeSpecificObjectName(managableObject, customName)) : null);
    }

    public void manageNamedObject(Object managedObject, Object preferredName) throws Exception {
        managedObject = this.getTypeSpecificManagedObject(managedObject);
        if (preferredName instanceof ObjectName && managedObject != null) {
            try {
                this.register(managedObject, (ObjectName)preferredName);
            }
            catch (Exception ex) {
                throw (JMException)new JMException(ex.getMessage()).initCause(ex);
            }
        }
    }

    public void unmanageObject(Object managedObject) throws Exception {
        ObjectName objectName = this.getManagedObjectName(managedObject, null, ObjectName.class);
        this.unmanageNamedObject(objectName);
    }

    public void unmanageNamedObject(Object name) throws Exception {
        if (name instanceof ObjectName) {
            this.unregister((ObjectName)name);
        }
    }

    public boolean isManaged(Object managableObject, Object name) {
        try {
            return managableObject != null ? this.getMbeanServer().isRegistered(this.getManagedObjectName(managableObject, null, ObjectName.class)) : (name != null && name instanceof ObjectName ? this.getMbeanServer().isRegistered((ObjectName)name) : false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Statistic createStatistic(String name, Object owner, Statistic.UpdateMode updateMode) {
        return updateMode == Statistic.UpdateMode.COUNTER ? new TimeStatistic(name, null) : (updateMode == Statistic.UpdateMode.VALUE ? new CountStatistic(name, null) : null);
    }

    public void notify(EventObject event) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)event.toString());
        }
    }

    public void setBundleContext(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void init() throws Exception {
        if (this.isEnabled()) {
            this.registerService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            Object[] mBeans = this.mbeans.toArray();
            int caught = 0;
            for (Object name : mBeans) {
                this.mbeans.remove((ObjectName)name);
                try {
                    this.unregister((ObjectName)name);
                }
                catch (JMException jmex) {
                    LOG.info((Object)"Exception unregistering MBean", (Throwable)jmex);
                    ++caught;
                }
            }
            if (caught > 0) {
                LOG.warn((Object)("A number of " + caught + " exceptions caught while unregistering MBeans during stop operation.  " + "See INFO log for details."));
            }
        }
        finally {
            this.unregisterService();
        }
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, !(obj instanceof ManagedEndpoint));
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        try {
            this.registerMBeanWithServer(obj, name, forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            this.registerViaAnnotations(obj, name, forceRegistration);
        }
        catch (UndeclaredThrowableException ute) {
            if (ute.getCause() instanceof NotCompliantMBeanException || ute.getCause().getCause() instanceof NotCompliantMBeanException) {
                this.registerViaAnnotations(obj, name, forceRegistration);
            }
            if (ute.getCause() instanceof RuntimeException) {
                LOG.warn((Object)"MBean registration failed: ", ute.getCause());
                throw (RuntimeException)ute.getCause();
            }
            LOG.warn((Object)"MBean registration failed: ", ute.getCause());
            throw new JMException(ute.getCause().getMessage());
        }
    }

    protected void registerViaAnnotations(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ModelMBeanInfo mbi = this.assembler.getMBeanInfo(obj, name.toString());
        RequiredModelMBean mbean = (RequiredModelMBean)this.mbeanServer.instantiate(RequiredModelMBean.class.getName());
        mbean.setModelMBeanInfo(mbi);
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException itotex) {
            throw new JMException(itotex.getMessage());
        }
        this.registerMBeanWithServer(mbean, name, forceRegistration);
    }

    public void unregister(ObjectName name) throws JMException {
        this.mbeanServer.unregisterMBean(name);
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance = null;
        try {
            instance = this.mbeanServer.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.mbeanServer.unregisterMBean(name);
                instance = this.mbeanServer.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.mbeans.add(name);
        }
    }

    protected void registerService() {
        this.serviceRegistration = this.getBundleContext().registerService("org.fusesource.commons.management.ManagementStrategy", (Object)this, null);
    }

    protected void unregisterService() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    private ObjectName getTypeSpecificObjectName(Object mo, String customName) throws MalformedObjectNameException {
        return mo instanceof ManagedEndpoint ? this.namingStrategy.getObjectName((ManagedEndpoint)mo) : (mo instanceof Nameable ? (customName != null ? this.namingStrategy.getCustomObjectName(customName, ((Nameable)mo).getName()) : this.namingStrategy.getObjectName((Nameable)mo)) : (mo instanceof ComponentContext ? this.namingStrategy.getCustomObjectName(customName, ((ComponentContext)mo).getComponentName()) : null));
    }

    private Object getTypeSpecificManagedObject(Object object) throws NotCompliantMBeanException {
        return object instanceof ManagedEndpoint ? object : (object instanceof Nameable ? new StandardMBean(object, ((Nameable)object).getPrimaryInterface()) : null);
    }
}

