/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.artifacts;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceUnit;
import org.apache.servicemix.jbi.deployer.SharedLibrary;
import org.apache.servicemix.jbi.deployer.artifacts.AbstractLifecycleJbiArtifact;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceUnitImpl;
import org.apache.servicemix.jbi.deployer.descriptor.ComponentDesc;
import org.apache.servicemix.jbi.deployer.descriptor.DescriptorFactory;
import org.apache.servicemix.jbi.deployer.events.LifeCycleEvent;
import org.apache.servicemix.nmr.management.Nameable;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentImpl
extends AbstractLifecycleJbiArtifact
implements Component,
org.apache.servicemix.jbi.runtime.ComponentWrapper,
Nameable {
    private Bundle bundle;
    private ComponentDesc componentDesc;
    private javax.jbi.component.Component component;
    private Set<ServiceUnitImpl> serviceUnits;
    private SharedLibrary[] sharedLibraries;
    private boolean restoreState = true;
    private ClassLoader componentClassLoader;

    public ComponentImpl(Bundle bundle, ComponentDesc componentDesc, javax.jbi.component.Component component, Preferences prefs, boolean autoStart, SharedLibrary[] sharedLibraries) {
        this.bundle = bundle;
        this.componentDesc = componentDesc;
        this.component = new ComponentWrapper(component);
        this.prefs = prefs;
        this.runningState = this.loadState(autoStart ? AbstractLifecycleJbiArtifact.State.Started : AbstractLifecycleJbiArtifact.State.Shutdown);
        this.serviceUnits = new HashSet<ServiceUnitImpl>();
        this.sharedLibraries = sharedLibraries;
        this.componentClassLoader = component.getClass().getClassLoader();
    }

    public ClassLoader getComponentClassLoader() {
        return this.componentClassLoader;
    }

    public void addServiceUnit(ServiceUnitImpl serviceUnit) {
        this.serviceUnits.add(serviceUnit);
    }

    public void removeServiceUnit(ServiceUnitImpl serviceUnit) {
        this.serviceUnits.remove(serviceUnit);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public ServiceUnit[] getServiceUnits() {
        return this.serviceUnits.toArray(new ServiceUnit[this.serviceUnits.size()]);
    }

    @Override
    public String getName() {
        return this.componentDesc.getIdentification().getName();
    }

    @Override
    public String getDescription() {
        return this.componentDesc.getIdentification().getDescription();
    }

    @Override
    public String getDescriptor() {
        URL url = this.bundle.getResource("META-INF/jbi.xml");
        return DescriptorFactory.getDescriptorAsText(url);
    }

    public String getType() {
        return this.componentDesc.getType();
    }

    public ObjectName getExtensionMBeanName() throws JBIException {
        return this.component.getLifeCycle().getExtensionMBeanName();
    }

    @Override
    public javax.jbi.component.Component getComponent() {
        return this.component;
    }

    public void start() throws JBIException {
        this.start(true);
    }

    public void start(boolean saveState) throws JBIException {
        this.LOGGER.info((Object)("Starting component " + this.getName()));
        if (this.state != AbstractLifecycleJbiArtifact.State.Started) {
            if (this.state == AbstractLifecycleJbiArtifact.State.Shutdown) {
                this.component.getLifeCycle().init(null);
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Starting);
            this.component.getLifeCycle().start();
            this.state = AbstractLifecycleJbiArtifact.State.Started;
            if (saveState) {
                this.saveState();
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Started);
        }
    }

    public void stop() throws JBIException {
        this.stop(true);
    }

    public Set<ServiceAssemblyImpl> getServiceAssemblies() {
        HashSet<ServiceAssemblyImpl> sas = new HashSet<ServiceAssemblyImpl>();
        for (ServiceUnitImpl su : this.serviceUnits) {
            sas.add(su.getServiceAssemblyImpl());
        }
        return sas;
    }

    @Override
    public SharedLibrary[] getSharedLibraries() {
        return this.sharedLibraries;
    }

    public void stop(boolean saveState) throws JBIException {
        this.LOGGER.info((Object)("Stopping component " + this.getName()));
        if (this.state == AbstractLifecycleJbiArtifact.State.Started) {
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Stopping);
            this.component.getLifeCycle().stop();
            this.state = AbstractLifecycleJbiArtifact.State.Stopped;
            if (saveState) {
                this.saveState();
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.Stopped);
        }
    }

    public void shutDown() throws JBIException {
        this.shutDown(true, false);
    }

    @Override
    public void forceShutDown() throws JBIException {
        this.shutDown(true, true);
    }

    public void shutDown(boolean saveState, boolean force) throws JBIException {
        this.LOGGER.info((Object)("Shutting down component " + this.getName()));
        if (this.state == AbstractLifecycleJbiArtifact.State.Started) {
            this.stop(saveState);
        }
        if (this.state == AbstractLifecycleJbiArtifact.State.Stopped) {
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.ShuttingDown, force);
            this.component.getLifeCycle().shutDown();
            this.state = AbstractLifecycleJbiArtifact.State.Shutdown;
            if (saveState) {
                this.saveState();
            }
            this.fireEvent(LifeCycleEvent.LifeCycleEventType.ShutDown);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getParent() {
        return null;
    }

    @Override
    public String getMainType() {
        return "Component";
    }

    public String getSubType() {
        return "LifeCycle";
    }

    public String getVersion() {
        return null;
    }

    public Class getPrimaryInterface() {
        return Component.class;
    }

    protected class ComponentWrapper
    implements javax.jbi.component.Component,
    ComponentLifeCycle {
        private javax.jbi.component.Component component;
        private ComponentLifeCycle lifeCycle;
        private ComponentContext context;

        public ComponentWrapper(javax.jbi.component.Component component) {
            this.component = component;
        }

        public ComponentLifeCycle getLifeCycle() {
            if (this.lifeCycle == null) {
                this.lifeCycle = this.component.getLifeCycle();
            }
            return this;
        }

        public ServiceUnitManager getServiceUnitManager() {
            return this.component.getServiceUnitManager();
        }

        public Document getServiceDescription(ServiceEndpoint endpoint) {
            return this.component.getServiceDescription(endpoint);
        }

        public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
            return this.component.isExchangeWithConsumerOkay(endpoint, exchange);
        }

        public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
            return this.component.isExchangeWithProviderOkay(endpoint, exchange);
        }

        public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) {
            return this.component.resolveEndpointReference(epr);
        }

        public ObjectName getExtensionMBeanName() {
            return this.lifeCycle.getExtensionMBeanName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init(ComponentContext context) throws JBIException {
            ComponentContext contextToUse = context;
            if (this.context == null) {
                this.context = context;
            }
            if (contextToUse == null) {
                contextToUse = this.context;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ComponentImpl.this.getComponentClassLoader());
                if (ComponentImpl.this.restoreState) {
                    AbstractLifecycleJbiArtifact.State stateToUse = context != null ? ComponentImpl.this.runningState : AbstractLifecycleJbiArtifact.State.Shutdown;
                    switch (stateToUse) {
                        case Started: {
                            ComponentImpl.this.fireEvent(LifeCycleEvent.LifeCycleEventType.Starting);
                            this.lifeCycle.init(contextToUse);
                            this.start();
                            ComponentImpl.this.state = AbstractLifecycleJbiArtifact.State.Started;
                            ComponentImpl.this.fireEvent(LifeCycleEvent.LifeCycleEventType.Started);
                            break;
                        }
                        case Stopped: {
                            ComponentImpl.this.fireEvent(LifeCycleEvent.LifeCycleEventType.Stopping);
                            this.lifeCycle.init(contextToUse);
                            this.start();
                            this.stop();
                            ComponentImpl.this.state = AbstractLifecycleJbiArtifact.State.Stopped;
                            ComponentImpl.this.fireEvent(LifeCycleEvent.LifeCycleEventType.Stopped);
                            break;
                        }
                        case Shutdown: {
                            ComponentImpl.this.state = AbstractLifecycleJbiArtifact.State.Shutdown;
                        }
                    }
                    ComponentImpl.this.restoreState = false;
                } else {
                    this.lifeCycle.init(contextToUse);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutDown() throws JBIException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
                this.lifeCycle.shutDown();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws JBIException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
                this.lifeCycle.start();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() throws JBIException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
                this.lifeCycle.stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }
}

