/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.TrackingLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class OSGIPaxLoggingManager
extends ServiceTracker
implements PaxLoggingManager {
    private PaxLoggingService m_service;
    private BundleContext m_context;
    private Map m_loggers = new HashMap();
    private ServiceReference m_logServiceRef;

    public OSGIPaxLoggingManager(BundleContext context) {
        super(context, PaxLoggingService.class.getName(), null);
        this.m_context = context;
        ServiceReference ref = context.getServiceReference(PaxLoggingService.class.getName());
        if (ref != null) {
            this.m_service = (PaxLoggingService)context.getService(ref);
        }
    }

    public Object addingService(ServiceReference reference) {
        this.m_logServiceRef = reference;
        this.m_service = (PaxLoggingService)this.m_context.getService(reference);
        Collection values = this.m_loggers.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            TrackingLogger logger = (TrackingLogger)iterator.next();
            logger.added(this.m_service);
        }
        return this.m_service;
    }

    public void removedService(ServiceReference reference, Object service) {
        this.m_service = null;
        this.m_context.ungetService(this.m_logServiceRef);
        this.m_logServiceRef = null;
        Collection values = this.m_loggers.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            TrackingLogger logger = (TrackingLogger)iterator.next();
            logger.removed();
        }
    }

    public PaxLogger getLogger(String category, String fqcn) {
        String key;
        TrackingLogger logger;
        if (fqcn == null) {
            fqcn = PaxLogger.class.getName();
        }
        if ((logger = (TrackingLogger)this.m_loggers.get(key = fqcn + "#" + category)) == null) {
            logger = new TrackingLogger(this.m_service, category, this.m_context.getBundle(), fqcn);
            this.m_loggers.put(key, logger);
        }
        return logger;
    }

    public PaxLoggingService getPaxLoggingService() {
        return this.m_service;
    }

    public void dispose() {
        if (this.m_logServiceRef != null) {
            this.m_context.ungetService(this.m_logServiceRef);
        }
    }

    public Bundle getBundle() {
        return this.m_context.getBundle();
    }
}

