/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.karaf.shell.console.Completer;
import org.apache.felix.karaf.shell.console.completer.StringsCompleter;
import org.apache.servicemix.jbi.deployer.Component;
import org.apache.servicemix.jbi.deployer.ServiceAssembly;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiCommandCompleter
implements Completer,
BundleContextAware {
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public int complete(String buffer, int cursor, List candidates) {
        Set<String> artifacts = this.getComponentsAndAssemblies();
        StringsCompleter delegate = new StringsCompleter(artifacts);
        return delegate.complete(buffer, cursor, candidates);
    }

    protected Set<String> getComponentsAndAssemblies() {
        try {
            String name;
            HashSet<String> artifacts = new HashSet<String>();
            ServiceReference[] references = this.bundleContext.getAllServiceReferences(Component.class.getName(), null);
            if (references != null) {
                for (ServiceReference ref : references) {
                    name = (String)ref.getProperty("NAME");
                    if (name == null) continue;
                    artifacts.add(name);
                }
            }
            if ((references = this.bundleContext.getAllServiceReferences(ServiceAssembly.class.getName(), null)) != null) {
                for (ServiceReference ref : references) {
                    name = (String)ref.getProperty("NAME");
                    if (name == null) continue;
                    artifacts.add(name);
                }
            }
            return artifacts;
        }
        catch (Exception e) {
            return null;
        }
    }
}

