/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.container;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.blueprint.utils.JavaUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintEventDispatcher
implements BlueprintListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintEventDispatcher.class);
    private final BlueprintListener eventAdminListener;
    private final ServiceTracker containerListenerTracker;
    private final Map<Bundle, BlueprintEvent> states = new ConcurrentHashMap<Bundle, BlueprintEvent>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    public BlueprintEventDispatcher(final BundleContext bundleContext) {
        EventAdminListener listener = null;
        try {
            this.getClass().getClassLoader().loadClass("org.osgi.service.event.EventAdmin");
            listener = new EventAdminListener(bundleContext);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.eventAdminListener = listener;
        this.containerListenerTracker = new ServiceTracker(bundleContext, BlueprintListener.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                BlueprintListener listener = (BlueprintListener)bundleContext.getService(reference);
                BlueprintEventDispatcher.this.sendInitialEvents(listener);
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
                bundleContext.ungetService(reference);
            }
        });
        this.containerListenerTracker.open();
    }

    protected void sendInitialEvents(BlueprintListener listener) {
        if (this.states != null) {
            for (Map.Entry<Bundle, BlueprintEvent> entry : this.states.entrySet()) {
                listener.blueprintEvent(new BlueprintEvent(entry.getValue(), true));
            }
        }
    }

    public void blueprintEvent(final BlueprintEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sending blueprint container event {} for bundle {}", (Object)this.toString(event), (Object)event.getBundle().getSymbolicName());
        }
        this.states.put(event.getBundle(), event);
        this.executor.submit(new Runnable(){

            public void run() {
                BlueprintEventDispatcher.this.callListeners(event);
                if (BlueprintEventDispatcher.this.eventAdminListener != null) {
                    BlueprintEventDispatcher.this.eventAdminListener.blueprintEvent(event);
                }
            }
        });
    }

    private String toString(BlueprintEvent event) {
        return "BlueprintEvent[type=" + this.getEventType(event.getType()) + (event.getDependencies() != null ? ", dependencies=" + Arrays.asList(event.getDependencies()) : "") + (event.getCause() != null ? ", exception=" + event.getCause().getMessage() : "") + "]";
    }

    private String getEventType(int type) {
        switch (type) {
            case 1: {
                return "CREATING";
            }
            case 2: {
                return "CREATED";
            }
            case 3: {
                return "DESTROYING";
            }
            case 4: {
                return "DESTROYED";
            }
            case 5: {
                return "FAILURE";
            }
            case 6: {
                return "GRACE_PERIOD";
            }
            case 7: {
                return "WAITING";
            }
        }
        return "UNKNOWN";
    }

    private void callListeners(BlueprintEvent event) {
        Object[] listeners = this.containerListenerTracker.getServices();
        if (listeners != null) {
            for (Object listener : listeners) {
                ((BlueprintListener)listener).blueprintEvent(event);
            }
        }
    }

    protected void contextDestroyed(Bundle bundle) {
        this.states.remove(bundle);
    }

    public void destroy() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.containerListenerTracker.close();
    }

    static class EventAdminListener
    implements BlueprintListener {
        private ServiceTracker tracker;

        public EventAdminListener(BundleContext context) {
            this.tracker = new ServiceTracker(context, EventAdmin.class.getName(), null);
            this.tracker.open();
        }

        public void blueprintEvent(BlueprintEvent event) {
            String topic;
            EventAdmin eventAdmin = (EventAdmin)this.tracker.getService();
            if (eventAdmin == null) {
                return;
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("type", event.getType());
            ((Dictionary)props).put("event", event);
            ((Dictionary)props).put("timestamp", event.getTimestamp());
            ((Dictionary)props).put("bundle", event.getBundle());
            ((Dictionary)props).put("bundle.symbolicName", event.getBundle().getSymbolicName());
            ((Dictionary)props).put("bundle.id", event.getBundle().getBundleId());
            Version version = JavaUtils.getBundleVersion(event.getBundle());
            if (version != null) {
                ((Dictionary)props).put("bundle.version", version);
            }
            ((Dictionary)props).put("extender.bundle", event.getExtenderBundle());
            ((Dictionary)props).put("extender.bundle.id", event.getExtenderBundle().getBundleId());
            ((Dictionary)props).put("extender.bundle.symbolicName", event.getExtenderBundle().getSymbolicName());
            version = JavaUtils.getBundleVersion(event.getExtenderBundle());
            if (version != null) {
                ((Dictionary)props).put("extender.bundle.version", version);
            }
            if (event.getCause() != null) {
                ((Dictionary)props).put("cause", event.getCause());
            }
            if (event.getDependencies() != null) {
                ((Dictionary)props).put("dependencies", event.getDependencies());
            }
            switch (event.getType()) {
                case 1: {
                    topic = "org/osgi/service/blueprint/container/CREATING";
                    break;
                }
                case 2: {
                    topic = "org/osgi/service/blueprint/container/CREATED";
                    break;
                }
                case 3: {
                    topic = "org/osgi/service/blueprint/container/DESTROYING";
                    break;
                }
                case 4: {
                    topic = "org/osgi/service/blueprint/container/DESTROYED";
                    break;
                }
                case 5: {
                    topic = "org/osgi/service/blueprint/container/FAILURE";
                    break;
                }
                case 6: {
                    topic = "org/osgi/service/blueprint/container/GRACE_PERIOD";
                    break;
                }
                case 7: {
                    topic = "org/osgi/service/blueprint/container/WAITING";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown blueprint event type: " + event.getType());
                }
            }
            eventAdmin.postEvent(new Event(topic, props));
        }
    }
}

