/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geronimo.blueprint.ExtendedBlueprintContainer;
import org.apache.geronimo.blueprint.ServiceProcessor;
import org.apache.geronimo.blueprint.container.ServiceListener;
import org.apache.geronimo.blueprint.di.AbstractRecipe;
import org.apache.geronimo.blueprint.di.CollectionRecipe;
import org.apache.geronimo.blueprint.di.MapRecipe;
import org.apache.geronimo.blueprint.di.Recipe;
import org.apache.geronimo.blueprint.di.Repository;
import org.apache.geronimo.blueprint.utils.JavaUtils;
import org.apache.geronimo.blueprint.utils.ReflectionUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.RefMetadata;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRecipe
extends AbstractRecipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRecipe.class);
    private final ExtendedBlueprintContainer blueprintContainer;
    private final ServiceMetadata metadata;
    private final Recipe serviceRecipe;
    private final CollectionRecipe listenersRecipe;
    private final MapRecipe propertiesRecipe;
    private final List<Recipe> explicitDependencies;
    private Map properties;
    private final AtomicBoolean registered = new AtomicBoolean();
    private volatile ServiceRegistration registration;
    private Map registrationProperties;
    private List<ServiceListener> listeners;
    private volatile Object service;

    public ServiceRecipe(String name, ExtendedBlueprintContainer blueprintContainer, ServiceMetadata metadata, Recipe serviceRecipe, CollectionRecipe listenersRecipe, MapRecipe propertiesRecipe, List<Recipe> explicitDependencies) {
        super(name);
        this.prototype = false;
        this.blueprintContainer = blueprintContainer;
        this.metadata = metadata;
        this.serviceRecipe = serviceRecipe;
        this.listenersRecipe = listenersRecipe;
        this.propertiesRecipe = propertiesRecipe;
        this.explicitDependencies = explicitDependencies;
    }

    public Recipe getServiceRecipe() {
        return this.serviceRecipe;
    }

    public CollectionRecipe getListenersRecipe() {
        return this.listenersRecipe;
    }

    @Override
    public List<Recipe> getConstructorDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.explicitDependencies != null) {
            recipes.addAll(this.explicitDependencies);
        }
        return recipes;
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        if (this.serviceRecipe != null) {
            recipes.add(this.serviceRecipe);
        }
        if (this.listenersRecipe != null) {
            recipes.add(this.listenersRecipe);
        }
        if (this.propertiesRecipe != null) {
            recipes.add(this.propertiesRecipe);
        }
        recipes.addAll(this.getConstructorDependencies());
        return recipes;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        ServiceRegistrationProxy proxy = new ServiceRegistrationProxy();
        this.addPartialObject(proxy);
        this.internalGetService(null, null);
        return proxy;
    }

    public boolean isRegistered() {
        return this.registered.get();
    }

    public void register() {
        if (this.registered.compareAndSet(false, true)) {
            this.createExplicitDependencies();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            if (this.properties == null) {
                this.properties = (Map)this.createRecipe(this.propertiesRecipe);
            }
            props.putAll(this.properties);
            if (this.metadata.getRanking() == 0) {
                props.remove("service.ranking");
            } else {
                props.put("service.ranking", this.metadata.getRanking());
            }
            String componentName = this.getComponentName();
            if (componentName != null) {
                props.put("osgi.service.blueprint.compname", componentName);
            } else {
                props.remove("osgi.service.blueprint.compname");
            }
            for (ServiceProcessor processor : this.blueprintContainer.getProcessors(ServiceProcessor.class)) {
                processor.updateProperties(new PropertiesUpdater(), props);
            }
            Set<String> classes = this.getClasses();
            String[] classArray = classes.toArray(new String[classes.size()]);
            LOGGER.debug("Registering service {} with interfaces {} and properties {}", new Object[]{this.name, classes, props});
            this.registrationProperties = props;
            this.registration = this.blueprintContainer.registerService(classArray, new TriggerServiceFactory(), props);
        }
    }

    public void unregister() {
        if (this.registered.compareAndSet(true, false)) {
            LOGGER.debug("Unregistering service {}", (Object)this.name);
            ServiceRegistration reg = this.registration;
            if (this.listeners != null) {
                LOGGER.debug("Calling listeners for service unregistration");
                for (ServiceListener listener : this.listeners) {
                    listener.unregister(this.service, this.registrationProperties);
                }
            }
            if (reg != null) {
                reg.unregister();
            }
            if (this.registration == reg) {
                this.registration = null;
            }
        }
    }

    protected ServiceReference getReference() {
        if (this.registration == null) {
            throw new IllegalStateException("Service is not registered");
        }
        return this.registration.getReference();
    }

    protected void setProperties(Dictionary props) {
        if (this.registration == null) {
            throw new IllegalStateException("Service is not registered");
        }
        this.registration.setProperties(props);
    }

    protected Object internalGetService() {
        return this.internalGetService(this.blueprintContainer.getBundleContext().getBundle(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalGetService(Bundle bundle, ServiceRegistration registration) {
        LOGGER.debug("Retrieving service for bundle {} and service registration {}", (Object)bundle, (Object)registration);
        if (this.service == null) {
            Object object = this.blueprintContainer.getRepository().getInstanceLock();
            synchronized (object) {
                if (this.service == null) {
                    this.createService();
                }
            }
        }
        Object service = this.service;
        if (bundle != null) {
            if (service instanceof ServiceFactory) {
                service = ((ServiceFactory)service).getService(bundle, registration);
            }
            if (service == null) {
                throw new IllegalStateException("service is null");
            }
            this.validateClasses(service);
        } else if (!(service instanceof ServiceFactory)) {
            this.validateClasses(service);
        }
        return service;
    }

    private void createService() {
        try {
            LOGGER.debug("Creating service instance");
            this.service = this.createRecipe(this.serviceRecipe);
            LOGGER.debug("Service created: {}", this.service);
            if (this.listeners == null) {
                LOGGER.debug("Creating listeners");
                this.listeners = this.listenersRecipe != null ? (List<Object>)this.createRecipe(this.listenersRecipe) : Collections.emptyList();
                LOGGER.debug("Listeners created: {}", this.listeners);
                if (this.registered.get()) {
                    LOGGER.debug("Calling listeners for initial service registration");
                    for (ServiceListener listener : this.listeners) {
                        listener.register(this.service, this.registrationProperties);
                    }
                } else {
                    LOGGER.debug("Calling listeners for initial service unregistration");
                    for (ServiceListener listener : this.listeners) {
                        listener.unregister(this.service, this.registrationProperties);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Error retrieving service from " + this, (Throwable)e);
            throw e;
        }
    }

    private void validateClasses(Object service) {
        if (this.metadata.getAutoExport() == 1) {
            HashSet<String> allClasses = new HashSet<String>();
            ReflectionUtils.getSuperClasses(allClasses, service.getClass());
            ReflectionUtils.getImplementedInterfaces(allClasses, service.getClass());
            Set<String> classes = this.getClasses();
            classes.removeAll(allClasses);
            if (!classes.isEmpty()) {
                throw new ComponentDefinitionException("The service implementation does not implement the required interfaces: " + classes);
            }
        }
    }

    public synchronized Object getService(Bundle bundle, ServiceRegistration registration) {
        if (this.registration == null) {
            this.registration = registration;
        }
        return this.internalGetService(bundle, registration);
    }

    public synchronized void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        if (this.service instanceof ServiceFactory) {
            ((ServiceFactory)this.service).ungetService(bundle, registration, service);
        }
    }

    private Set<String> getClasses() {
        Set<String> classes;
        switch (this.metadata.getAutoExport()) {
            case 2: {
                classes = ReflectionUtils.getImplementedInterfaces(new HashSet<String>(), this.internalGetService().getClass());
                break;
            }
            case 3: {
                classes = ReflectionUtils.getSuperClasses(new HashSet<String>(), this.internalGetService().getClass());
                break;
            }
            case 4: {
                classes = ReflectionUtils.getSuperClasses(new HashSet<String>(), this.internalGetService().getClass());
                classes = ReflectionUtils.getImplementedInterfaces(classes, this.internalGetService().getClass());
                break;
            }
            default: {
                classes = new HashSet<String>(this.metadata.getInterfaces());
            }
        }
        return classes;
    }

    private void createExplicitDependencies() {
        if (this.explicitDependencies != null) {
            for (Recipe recipe : this.explicitDependencies) {
                this.createRecipe(recipe);
            }
        }
    }

    private Object createRecipe(Recipe recipe) {
        String name = recipe.getName();
        Repository repo = this.blueprintContainer.getRepository();
        if (repo.getRecipe(name) != recipe) {
            repo.putRecipe(name, recipe);
        }
        return repo.create(name);
    }

    private String getComponentName() {
        if (this.metadata.getServiceComponent() instanceof RefMetadata) {
            RefMetadata ref = (RefMetadata)this.metadata.getServiceComponent();
            return ref.getComponentId();
        }
        return null;
    }

    private class PropertiesUpdater
    implements ServiceProcessor.ServicePropertiesUpdater {
        private PropertiesUpdater() {
        }

        public String getId() {
            return ServiceRecipe.this.metadata.getId();
        }

        public void updateProperties(Dictionary properties) {
            Hashtable table = JavaUtils.getProperties(ServiceRecipe.this.getReference());
            JavaUtils.copy(table, properties);
            ServiceRecipe.this.setProperties(table);
        }
    }

    private class ServiceRegistrationProxy
    implements ServiceRegistration {
        private ServiceRegistrationProxy() {
        }

        public ServiceReference getReference() {
            return ServiceRecipe.this.getReference();
        }

        public void setProperties(Dictionary properties) {
            ServiceRecipe.this.setProperties(properties);
        }

        public void unregister() {
            throw new UnsupportedOperationException();
        }
    }

    private class TriggerServiceFactory
    implements ServiceFactory {
        private TriggerServiceFactory() {
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return ServiceRecipe.this.getService(bundle, registration);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            ServiceRecipe.this.ungetService(bundle, registration, service);
        }
    }
}

