/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.di;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geronimo.blueprint.di.AbstractRecipe;
import org.apache.geronimo.blueprint.di.Recipe;
import org.apache.geronimo.blueprint.utils.ReflectionUtils;
import org.osgi.service.blueprint.container.ComponentDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRecipe
extends AbstractRecipe {
    private final List<Recipe[]> entries;
    private final Class typeClass;

    public MapRecipe(String name, Class type) {
        super(name);
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.typeClass = type;
        this.entries = new ArrayList<Recipe[]>();
    }

    @Override
    public List<Recipe> getDependencies() {
        ArrayList<Recipe> nestedRecipes = new ArrayList<Recipe>(this.entries.size() * 2);
        for (Recipe[] entry : this.entries) {
            nestedRecipes.add(entry[0]);
            if (entry[1] == null) continue;
            nestedRecipes.add(entry[1]);
        }
        return nestedRecipes;
    }

    @Override
    protected Object internalCreate() throws ComponentDefinitionException {
        Map instance;
        Object o;
        Class mapType = MapRecipe.getMap(this.typeClass);
        if (!ReflectionUtils.hasDefaultConstructor(mapType)) {
            throw new ComponentDefinitionException("Type does not have a default constructor " + mapType.getName());
        }
        try {
            o = mapType.newInstance();
        }
        catch (Exception e) {
            throw new ComponentDefinitionException("Error while creating set instance: " + mapType.getName());
        }
        if (o instanceof Map) {
            instance = (Map)o;
        } else if (o instanceof Dictionary) {
            instance = new DummyDictionaryAsMap((Dictionary)o);
        } else {
            throw new ComponentDefinitionException("Specified map type does not implement the Map interface: " + mapType.getName());
        }
        for (Recipe[] entry : this.entries) {
            Object key = entry[0].create();
            Object value = entry[1] != null ? entry[1].create() : null;
            instance.put(key, value);
        }
        return instance;
    }

    public void put(Recipe key, Recipe value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.entries.add(new Recipe[]{key, value});
    }

    public void putAll(Map<Recipe, Recipe> map) {
        if (map == null) {
            throw new NullPointerException("map is null");
        }
        for (Map.Entry<Recipe, Recipe> entry : map.entrySet()) {
            Recipe key = entry.getKey();
            Recipe value = entry.getValue();
            this.put(key, value);
        }
    }

    public static Class getMap(Class type) {
        if (ReflectionUtils.hasDefaultConstructor(type)) {
            return type;
        }
        if (SortedMap.class.isAssignableFrom(type)) {
            return TreeMap.class;
        }
        if (ConcurrentMap.class.isAssignableFrom(type)) {
            return ConcurrentHashMap.class;
        }
        return LinkedHashMap.class;
    }

    public static class DummyDictionaryAsMap
    extends AbstractMap {
        private final Dictionary dictionary;

        public DummyDictionaryAsMap(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        public Object put(Object key, Object value) {
            return this.dictionary.put(key, value);
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }
    }
}

