/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.blueprint.utils;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public class BundleDelegatingClassLoader
extends ClassLoader {
    private final Bundle bundle;
    private final ClassLoader classLoader;

    public BundleDelegatingClassLoader(Bundle bundle) {
        this(bundle, null);
    }

    public BundleDelegatingClassLoader(Bundle bundle, ClassLoader classLoader) {
        this.bundle = bundle;
        this.classLoader = classLoader;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        return this.bundle.loadClass(name);
    }

    protected URL findResource(String name) {
        URL resource = this.bundle.getResource(name);
        if (this.classLoader != null && resource == null) {
            resource = this.classLoader.getResource(name);
        }
        return resource;
    }

    protected Enumeration findResources(String name) throws IOException {
        return this.bundle.getResources(name);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = this.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.classLoader != null) {
                try {
                    clazz = this.classLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException(name + " from bundle " + this.bundle.getBundleId() + " (" + this.bundle.getSymbolicName() + ")", cnfe);
                }
            }
            throw new ClassNotFoundException(name + " from bundle " + this.bundle.getBundleId() + " (" + this.bundle.getSymbolicName() + ")", cnfe);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

