/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.BufferUtils;
import org.apache.sshd.common.util.SecurityUtils;

public final class Buffer {
    public static final int DEFAULT_SIZE = 256;
    private byte[] data;
    private int rpos;
    private int wpos;

    public Buffer() {
        this(256);
    }

    public Buffer(int size) {
        this(new byte[Buffer.getNextPowerOf2(size)], false);
    }

    public Buffer(byte[] data) {
        this(data, true);
    }

    public Buffer(byte[] data, boolean read) {
        this.data = data;
        this.rpos = 0;
        this.wpos = read ? data.length : 0;
    }

    public String toString() {
        return "Buffer [rpos=" + this.rpos + ", wpos=" + this.wpos + ", size=" + this.data.length + "]";
    }

    public int rpos() {
        return this.rpos;
    }

    public void rpos(int rpos) {
        this.rpos = rpos;
    }

    public int wpos() {
        return this.wpos;
    }

    public void wpos(int wpos) {
        this.ensureCapacity(wpos - this.wpos);
        this.wpos = wpos;
    }

    public int available() {
        return this.wpos - this.rpos;
    }

    public byte[] array() {
        return this.data;
    }

    public void compact() {
        if (this.available() > 0) {
            System.arraycopy(this.data, this.rpos, this.data, 0, this.wpos - this.rpos);
        }
        this.wpos -= this.rpos;
        this.rpos = 0;
    }

    public byte[] getCompactData() {
        int l = this.available();
        if (l > 0) {
            byte[] b = new byte[l];
            System.arraycopy(this.data, this.rpos, b, 0, l);
            return b;
        }
        return new byte[0];
    }

    public void clear() {
        this.rpos = 0;
        this.wpos = 0;
    }

    public String printHex() {
        return BufferUtils.printHex(this.array(), this.rpos(), this.available());
    }

    public byte getByte() {
        this.ensureAvailable(1);
        return this.data[this.rpos++];
    }

    public int getInt() {
        return (int)this.getUInt();
    }

    public long getUInt() {
        this.ensureAvailable(4);
        long l = (long)(this.data[this.rpos++] << 24) & 0xFF000000L | (long)(this.data[this.rpos++] << 16) & 0xFF0000L | (long)(this.data[this.rpos++] << 8) & 0xFF00L | (long)this.data[this.rpos++] & 0xFFL;
        return l;
    }

    public boolean getBoolean() {
        return this.getByte() != 0;
    }

    public String getString() {
        int len = this.getInt();
        if (len < 0 || len > 32768) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        this.ensureAvailable(len);
        String s = new String(this.data, this.rpos, len);
        this.rpos += len;
        return s;
    }

    public byte[] getStringAsBytes() {
        return this.getBytes();
    }

    public BigInteger getMPInt() {
        return new BigInteger(this.getMPIntAsBytes());
    }

    public byte[] getMPIntAsBytes() {
        return this.getBytes();
    }

    public byte[] getBytes() {
        int len = this.getInt();
        if (len < 0 || len > 32768) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        byte[] b = new byte[len];
        this.getRawBytes(b);
        return b;
    }

    public void getRawBytes(byte[] buf) {
        this.getRawBytes(buf, 0, buf.length);
    }

    public void getRawBytes(byte[] buf, int off, int len) {
        this.ensureAvailable(len);
        System.arraycopy(this.data, this.rpos, buf, off, len);
        this.rpos += len;
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PublicKey key;
        String keyAlg = this.getString();
        if ("ssh-rsa".equals(keyAlg)) {
            BigInteger e = this.getMPInt();
            BigInteger n = this.getMPInt();
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("RSA");
            key = keyFactory.generatePublic(new RSAPublicKeySpec(n, e));
        } else if ("ssh-dss".equals(keyAlg)) {
            BigInteger p = this.getMPInt();
            BigInteger q = this.getMPInt();
            BigInteger g = this.getMPInt();
            BigInteger y = this.getMPInt();
            KeyFactory keyFactory = SecurityUtils.getKeyFactory("DSA");
            key = keyFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
        } else {
            throw new IllegalStateException("Unsupported algorithm: " + keyAlg);
        }
        return key;
    }

    public SshConstants.Message getCommand() {
        byte b = this.getByte();
        SshConstants.Message cmd = SshConstants.Message.fromByte(b);
        if (cmd == null) {
            throw new IllegalStateException("Unknown command code: " + b);
        }
        return cmd;
    }

    private void ensureAvailable(int a) {
        if (this.available() < a) {
            throw new BufferException("Underflow");
        }
    }

    public void putByte(byte b) {
        this.ensureCapacity(1);
        this.data[this.wpos++] = b;
    }

    public void putBuffer(Buffer buffer) {
        int r = buffer.available();
        this.ensureCapacity(r);
        System.arraycopy(buffer.data, buffer.rpos, this.data, this.wpos, r);
        this.wpos += r;
    }

    public void putBuffer(IoBuffer buffer) {
        int r = buffer.remaining();
        this.ensureCapacity(r);
        buffer.get(this.data, this.wpos, r);
        this.wpos += r;
    }

    public void putInt(long i) {
        this.ensureCapacity(4);
        this.data[this.wpos++] = (byte)(i >> 24);
        this.data[this.wpos++] = (byte)(i >> 16);
        this.data[this.wpos++] = (byte)(i >> 8);
        this.data[this.wpos++] = (byte)i;
    }

    public void putBoolean(boolean b) {
        this.putByte(b ? (byte)1 : 0);
    }

    public void putBytes(byte[] b) {
        this.putBytes(b, 0, b.length);
    }

    public void putBytes(byte[] b, int off, int len) {
        this.putInt(len);
        this.ensureCapacity(len);
        System.arraycopy(b, off, this.data, this.wpos, len);
        this.wpos += len;
    }

    public void putString(String string) {
        this.putString(string.getBytes());
    }

    public void putString(byte[] str) {
        this.putInt(str.length);
        this.putRawBytes(str);
    }

    public void putMPInt(BigInteger bi) {
        this.putMPInt(bi.toByteArray());
    }

    public void putMPInt(byte[] foo) {
        int i = foo.length;
        if ((foo[0] & 0x80) != 0) {
            this.putInt(++i);
            this.putByte((byte)0);
        } else {
            this.putInt(i);
        }
        this.putRawBytes(foo);
    }

    public void putRawBytes(byte[] d) {
        this.putRawBytes(d, 0, d.length);
    }

    public void putRawBytes(byte[] d, int off, int len) {
        this.ensureCapacity(len);
        System.arraycopy(d, off, this.data, this.wpos, len);
        this.wpos += len;
    }

    public void putPublicKey(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            this.putString("ssh-rsa");
            this.putMPInt(((RSAPublicKey)key).getPublicExponent());
            this.putMPInt(((RSAPublicKey)key).getModulus());
        } else if (key instanceof DSAPublicKey) {
            this.putString("ssh-dss");
            this.putMPInt(((DSAPublicKey)key).getParams().getP());
            this.putMPInt(((DSAPublicKey)key).getParams().getQ());
            this.putMPInt(((DSAPublicKey)key).getParams().getG());
            this.putMPInt(((DSAPublicKey)key).getY());
        } else {
            throw new IllegalStateException("Unsupported algorithm: " + key.getAlgorithm());
        }
    }

    public void putCommand(SshConstants.Message cmd) {
        this.putByte(cmd.toByte());
    }

    private void ensureCapacity(int capacity) {
        if (this.data.length - this.wpos < capacity) {
            int cw = this.wpos + capacity;
            byte[] tmp = new byte[Buffer.getNextPowerOf2(cw)];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
    }

    private static int getNextPowerOf2(int i) {
        int j;
        for (j = 1; j < i; j <<= 1) {
        }
        return j;
    }

    public static class BufferException
    extends RuntimeException {
        public BufferException(String message) {
            super(message);
        }
    }
}

