/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployer.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jbi.JBIException;
import javax.management.ObjectName;
import org.apache.servicemix.jbi.deployer.DeployedAssembly;
import org.apache.servicemix.jbi.deployer.artifacts.ComponentImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceAssemblyImpl;
import org.apache.servicemix.jbi.deployer.artifacts.ServiceUnitImpl;
import org.apache.servicemix.jbi.deployer.descriptor.Descriptor;
import org.apache.servicemix.jbi.deployer.descriptor.ServiceUnitDesc;
import org.apache.servicemix.jbi.deployer.impl.AbstractInstaller;
import org.apache.servicemix.jbi.deployer.impl.Deployer;
import org.apache.servicemix.jbi.deployer.impl.PendingException;
import org.apache.servicemix.jbi.deployer.utils.FileUtil;
import org.apache.servicemix.jbi.deployer.utils.ManagementSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAssemblyInstaller
extends AbstractInstaller {
    private DeployedAssembly deployedAssembly;

    public ServiceAssemblyInstaller(Deployer deployer, Descriptor descriptor, File jbiArtifact, boolean autoStart) {
        super(deployer, descriptor, jbiArtifact, autoStart);
        this.installRoot = new File(System.getProperty("karaf.base"), "data/jbi/" + this.getName() + "/install");
        this.installRoot.mkdirs();
    }

    public ServiceAssemblyInstaller(Deployer deployer, Descriptor descriptor, DeployedAssembly deployedAssembly, boolean autoStart) {
        super(deployer, descriptor, null, autoStart);
        this.deployedAssembly = deployedAssembly;
    }

    @Override
    public String getName() {
        return this.descriptor.getServiceAssembly().getIdentification().getName();
    }

    public DeployedAssembly getDeployedAssembly() {
        return this.deployedAssembly;
    }

    @Override
    public void init() throws Exception {
        for (ServiceUnitDesc sud : this.descriptor.getServiceAssembly().getServiceUnits()) {
            String componentName = sud.getTarget().getComponentName();
            ComponentImpl component = this.deployer.getComponent(componentName);
            if (component == null) {
                throw new PendingException(this.bundle, "Component not installed: " + componentName);
            }
            if ("Started".equals(component.getCurrentState())) continue;
            throw new PendingException(this.bundle, "Component is not started: " + componentName);
        }
        super.init();
    }

    @Override
    public ObjectName install() throws JBIException {
        try {
            List<ServiceUnitImpl> sus;
            if (this.deployedAssembly == null) {
                sus = this.deploySUs();
            } else {
                sus = new ArrayList<ServiceUnitImpl>();
                for (ServiceUnitDesc sud : this.descriptor.getServiceAssembly().getServiceUnits()) {
                    String componentName = sud.getTarget().getComponentName();
                    ComponentImpl component = this.deployer.getComponent(componentName);
                    ServiceUnitImpl su = this.deployer.createServiceUnit(sud, null, component);
                    sus.add(su);
                }
            }
            this.postInstall();
            ServiceAssemblyImpl sa = this.deployer.registerServiceAssembly(this.bundle, this.descriptor.getServiceAssembly(), sus);
            return (ObjectName)this.deployer.getManagementStrategy().getManagedObjectName((Object)sa, null, ObjectName.class);
        }
        catch (Exception e) {
            this.LOGGER.error((Object)e.getMessage());
            throw new JBIException((Throwable)e);
        }
    }

    @Override
    public void stop(boolean force) throws Exception {
        ServiceAssemblyImpl assembly = this.deployer.getServiceAssembly(this.getName());
        if (assembly == null && !force) {
            throw ManagementSupport.failure("undeployServiceAssembly", "ServiceAssembly '" + this.getName() + "' is not deployed.");
        }
        if (assembly != null && !"Shutdown".equals(assembly.getCurrentState())) {
            if (!force) {
                throw ManagementSupport.failure("undeployServiceAssembly", "ServiceAssembly '" + this.getName() + "' is not shut down.");
            }
            if ("Started".equals(assembly.getCurrentState())) {
                assembly.stop(false);
            }
            if ("Stopped".equals(assembly.getCurrentState())) {
                assembly.shutDown(false, force);
            }
        }
        if (this.deployedAssembly == null) {
            if (assembly != null) {
                for (ServiceUnitImpl su : assembly.getServiceUnitsList()) {
                    su.getComponentImpl().removeServiceUnit(su);
                }
            }
        } else {
            this.deployedAssembly.undeploy(this.bundle.getState() == 32);
        }
    }

    @Override
    public void uninstall(boolean force) throws Exception {
        this.stop(force);
        ServiceAssemblyImpl assembly = this.deployer.getServiceAssembly(this.getName());
        if (assembly == null && !force) {
            throw ManagementSupport.failure("undeployServiceAssembly", "ServiceAssembly '" + this.getName() + "' is not deployed.");
        }
        if (assembly != null) {
            if (assembly.getServiceUnitsList() != null) {
                for (ServiceUnitImpl su : assembly.getServiceUnitsList()) {
                    su.undeploy();
                }
            }
            this.deployer.unregisterServiceAssembly(assembly);
        }
        try {
            this.deletePreferences();
        }
        catch (BackingStoreException e) {
            this.LOGGER.warn((Object)("Error cleaning persistent state for component: " + this.getName()), (Throwable)e);
        }
        this.uninstallBundle();
        FileUtil.deleteFile(this.installRoot);
    }

    protected List<ServiceUnitImpl> deploySUs() throws Exception {
        File saDir = new File(this.installRoot.getParent(), "sus");
        if (this.isModified && !this.isFirstInstall) {
            for (ServiceUnitDesc sud : this.descriptor.getServiceAssembly().getServiceUnits()) {
                File suRootDir = new File(saDir, sud.getIdentification().getName());
                String componentName = sud.getTarget().getComponentName();
                ComponentImpl component = this.deployer.getComponent(componentName);
                ServiceUnitImpl su = this.deployer.createServiceUnit(sud, suRootDir, component);
                try {
                    su.undeploy();
                }
                catch (Exception e) {
                    this.LOGGER.warn((Object)("Problem undeploying SU " + su.getName()));
                }
            }
        }
        if (this.isModified) {
            FileUtil.deleteFile(saDir);
            FileUtil.buildDirectory(saDir);
        }
        ArrayList<ServiceUnitImpl> sus = new ArrayList<ServiceUnitImpl>();
        Exception failure = null;
        for (ServiceUnitDesc sud : this.descriptor.getServiceAssembly().getServiceUnits()) {
            File suRootDir = new File(saDir, sud.getIdentification().getName());
            if (this.isModified) {
                String zip = sud.getTarget().getArtifactsZip();
                URL zipUrl = this.bundle.getResource(zip);
                FileUtil.unpackArchive(zipUrl, suRootDir);
            }
            String componentName = sud.getTarget().getComponentName();
            ComponentImpl component = this.deployer.getComponent(componentName);
            ServiceUnitImpl su = this.deployer.createServiceUnit(sud, suRootDir, component);
            try {
                this.LOGGER.debug((Object)("Deploying SU " + su.getName()));
                if (this.isModified) {
                    su.deploy();
                }
                sus.add(su);
            }
            catch (Throwable e) {
                this.LOGGER.error((Object)("Error deploying SU " + su.getName()), e);
                failure = new Exception("Error deploying SU " + su.getName(), e);
                break;
            }
        }
        if (failure != null) {
            for (ServiceUnitImpl su : sus) {
                try {
                    this.LOGGER.debug((Object)("Undeploying SU " + su.getName()));
                    su.undeploy();
                }
                catch (Exception e) {
                    this.LOGGER.warn((Object)("Error undeploying SU " + su.getName()), (Throwable)e);
                }
            }
            throw failure;
        }
        return sus;
    }

    public void undeploy() throws JBIException {
        try {
            Bundle bundle = this.getBundle();
            if (bundle == null) {
                this.LOGGER.warn((Object)("Could not find Bundle for Service Assembly: " + this.getName()));
            } else {
                bundle.stop();
                bundle.uninstall();
                try {
                    this.deletePreferences();
                }
                catch (BackingStoreException e) {
                    this.LOGGER.warn((Object)("Error cleaning persistent state for service assembly: " + this.getName()), (Throwable)e);
                }
            }
        }
        catch (BundleException e) {
            this.LOGGER.error((Object)("failed to uninstall Service Assembly: " + this.getName()), (Throwable)e);
            throw new JBIException((Throwable)e);
        }
    }
}

