/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.dev;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.karaf.shell.dev.AbstractBundleCommand;
import org.apache.felix.karaf.shell.dev.util.Bundles;
import org.apache.felix.karaf.shell.dev.util.Import;
import org.apache.felix.karaf.shell.dev.util.Node;
import org.apache.felix.karaf.shell.dev.util.Tree;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="dev", name="show-tree", description="Show the tree of bundles based on the wiring information")
public class ShowBundleTree
extends AbstractBundleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowBundleTree.class);
    private ExportedPackage[] allExportedPackages;

    @Override
    protected void doExecute(Bundle bundle) throws Exception {
        this.printHeader(bundle);
        Tree<Bundle> tree = this.createTree(bundle);
        this.printTree(tree);
        this.printDuplicatePackages(tree);
    }

    private void printHeader(Bundle bundle) {
        System.out.printf("Bundle %s [%s] is currently %s%n", bundle.getSymbolicName(), bundle.getBundleId(), Bundles.toString(bundle.getState()));
    }

    private void printTree(Tree<Bundle> tree) {
        System.out.printf("%n", new Object[0]);
        tree.write(System.out, new Tree.Converter<Bundle>(){

            @Override
            public String toString(Node<Bundle> node) {
                return String.format("%s [%s]", node.getValue().getSymbolicName(), node.getValue().getBundleId());
            }
        });
    }

    private void printDuplicatePackages(Tree<Bundle> tree) {
        Set bundles = tree.flatten();
        HashMap exports = new HashMap();
        for (Bundle bundle : bundles) {
            ExportedPackage[] packages = this.getPackageAdmin().getExportedPackages(bundle);
            if (packages == null) continue;
            for (ExportedPackage p : packages) {
                if (exports.get(p.getName()) == null) {
                    exports.put(p.getName(), new HashSet());
                }
                ((Set)exports.get(p.getName())).add(bundle);
            }
        }
        for (String pkg : exports.keySet()) {
            if (((Set)exports.get(pkg)).size() <= 1) continue;
            System.out.printf("%n", new Object[0]);
            System.out.printf("WARNING: multiple bundles are exporting package %s%n", pkg);
            for (Bundle bundle : (Set)exports.get(pkg)) {
                System.out.printf("- %s%n", bundle);
            }
        }
    }

    protected Tree<Bundle> createTree(Bundle bundle) {
        Tree<Bundle> tree = new Tree<Bundle>(bundle);
        HashSet<Bundle> trail = new HashSet<Bundle>();
        if (bundle.getState() >= 4) {
            this.createNode(tree, trail);
        } else {
            for (Import i : Import.parse(String.valueOf(bundle.getHeaders().get("Import-Package")))) {
                for (ExportedPackage ep : this.getPackageAdmin().getExportedPackages(i.getPackage())) {
                    if (ep.getVersion().compareTo((Object)i.getVersion()) < 0 || bundle.equals(ep.getExportingBundle())) continue;
                    Node child = tree.addChild(ep.getExportingBundle());
                    System.out.printf("- using %s to resolve import %s%n", ep.getExportingBundle(), i);
                    this.createNode(child, trail);
                }
            }
        }
        return tree;
    }

    private void createNode(Node<Bundle> node, Set<Bundle> trail) {
        Bundle bundle = node.getValue();
        HashSet<Bundle> exporters = new HashSet<Bundle>();
        exporters.addAll(this.getWiredBundles(bundle).values());
        for (Bundle exporter : exporters) {
            if (trail.contains(exporter)) {
                LOGGER.debug(String.format("Skipping %s because it already exists in the current tree branch", exporter));
                continue;
            }
            trail.add(exporter);
            Node child = node.addChild(exporter);
            LOGGER.debug(String.format("Adding %s as a dependency for %s", exporter, bundle));
            this.createNode(child, trail);
            trail.remove(exporter);
        }
    }
}

