/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.dev.util;

import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Import {
    private final String packageName;
    private final Version version;
    private final String value;

    protected Import(String value) {
        this.value = value;
        this.packageName = value.contains(";") ? value.split(";")[0] : value;
        this.version = value.contains("version=") ? this.extractVersion(value) : Version.emptyVersion;
    }

    private Version extractVersion(String value) {
        int begin = value.indexOf("version=") + 8;
        int end = value.indexOf(";", begin);
        if (end < 0) {
            return Version.parseVersion((String)this.unquote(value.substring(begin)));
        }
        return Version.parseVersion((String)this.unquote(value.substring(begin, end)));
    }

    private String unquote(String string) {
        return string.replace("\"", "");
    }

    public String getPackage() {
        return this.packageName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.value;
    }

    public static List<Import> parse(String value) {
        LinkedList<Import> imports = new LinkedList<Import>();
        for (String imp : value.split(",")) {
            imports.add(new Import(imp));
        }
        return imports;
    }
}

