/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.spring;

import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.osgi.context.BundleContextAware;

public class BundleExtUrlPostProcessor
implements BeanFactoryPostProcessor,
Ordered,
BundleContextAware,
BeanNameAware,
BeanFactoryAware {
    private int order;
    private String beanName;
    private BeanFactory beanFactory;
    private BundleContext bundleContext;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactoryToProcess) throws BeansException {
        BundleExtUrlBeanDefinitionVisitor visitor = new BundleExtUrlBeanDefinitionVisitor();
        String[] beanNames = beanFactoryToProcess.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            if (beanNames[i].equals(this.beanName) && beanFactoryToProcess.equals(this.beanFactory)) continue;
            BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanNames[i]);
            try {
                visitor.visitBeanDefinition(bd);
                continue;
            }
            catch (BeanDefinitionStoreException ex) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
            }
        }
    }

    private class BundleExtUrlBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        private BundleExtUrlBeanDefinitionVisitor() {
        }

        protected String resolveStringValue(String string) {
            if (string.startsWith("bundle-ext:")) {
                string = "bundle://" + BundleExtUrlPostProcessor.this.bundleContext.getBundle().getBundleId() + "/" + string.substring("bundle-ext:".length());
            }
            return string;
        }
    }
}

