/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.management;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.nmr.api.internal.InternalEndpoint;
import org.fusesource.commons.management.ManagementStrategy;
import org.fusesource.commons.management.Statistic;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Managed Endpoint", currencyTimeLimit=15)
public class ManagedEndpoint {
    protected final InternalEndpoint endpoint;
    protected final Map<String, ?> properties;
    protected final Statistic inboundExchanges;
    protected final Statistic outboundExchanges;
    protected final Statistic inboundExchangeRate;
    protected final Statistic outboundExchangeRate;
    protected final ManagementStrategy managementStrategy;

    public ManagedEndpoint(InternalEndpoint endpoint, Map<String, ?> properties, ManagementStrategy managementStrategy) {
        this.endpoint = endpoint;
        this.properties = new HashMap(properties);
        this.managementStrategy = managementStrategy;
        this.inboundExchanges = managementStrategy.createStatistic("inboundExchanges", (Object)this, Statistic.UpdateMode.VALUE);
        this.inboundExchangeRate = managementStrategy.createStatistic("inboundExchangeRate", (Object)this, Statistic.UpdateMode.COUNTER);
        this.outboundExchanges = managementStrategy.createStatistic("outboundExchanges", (Object)this, Statistic.UpdateMode.VALUE);
        this.outboundExchangeRate = managementStrategy.createStatistic("outboundExchangeRate", (Object)this, Statistic.UpdateMode.COUNTER);
    }

    public InternalEndpoint getEndpoint() {
        return this.endpoint;
    }

    void incrementInbound() {
        this.inboundExchanges.increment();
        this.inboundExchangeRate.increment();
    }

    void incrementOutbound() {
        this.outboundExchanges.increment();
        this.outboundExchangeRate.increment();
    }

    @ManagedAttribute(description="Name of the endpoint")
    public String getName() {
        return (String)this.properties.get("NAME");
    }

    @ManagedAttribute(description="Properties associated to this endpoint")
    public Map<String, ?> getProperties() {
        return this.properties;
    }

    @ManagedAttribute(description="Number of exchanges received")
    public long getInboundExchangeCount() {
        return this.inboundExchanges.getUpdateCount();
    }

    @ManagedAttribute(description="Exchanges received per second")
    public double getInboundExchangeRate() {
        return this.getRate(this.inboundExchangeRate);
    }

    @ManagedAttribute(description="Number of exchanges sent")
    public long getOutboundExchangeCount() {
        return this.outboundExchanges.getUpdateCount();
    }

    @ManagedAttribute(description="Exchanges sent per second")
    public double getOutboundExchangeRate() {
        return this.getRate(this.outboundExchangeRate);
    }

    @ManagedOperation
    public void reset() {
        this.inboundExchanges.reset();
        this.outboundExchanges.reset();
        this.inboundExchangeRate.reset();
        this.outboundExchangeRate.reset();
    }

    private synchronized double getRate(Statistic stat) {
        if (stat.getUpdateCount() == 0L) {
            return 0.0;
        }
        double d = stat.getValue();
        return d / (double)stat.getUpdateCount();
    }
}

