/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.framework.util.manifestparser.R4Attribute;
import org.apache.felix.framework.util.manifestparser.R4Directive;
import org.apache.felix.framework.util.manifestparser.R4Library;
import org.apache.felix.framework.util.manifestparser.R4LibraryClause;
import org.apache.felix.framework.util.manifestparser.Requirement;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IRequirement;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class ManifestParser {
    private final Logger m_logger;
    private final Map m_configMap;
    private final Map m_headerMap;
    private volatile int m_activationPolicy = 0;
    private volatile String m_activationIncludeDir;
    private volatile String m_activationExcludeDir;
    private volatile boolean m_isExtension = false;
    private volatile String m_bundleSymbolicName;
    private volatile Version m_bundleVersion;
    private volatile ICapability[] m_capabilities;
    private volatile IRequirement[] m_requirements;
    private volatile IRequirement[] m_dynamicRequirements;
    private volatile R4LibraryClause[] m_libraryHeaders;
    private volatile boolean m_libraryHeadersOptional = false;
    public static final int CLAUSE_PATHS_INDEX = 0;
    public static final int CLAUSE_DIRECTIVES_INDEX = 1;
    public static final int CLAUSE_ATTRIBUTES_INDEX = 2;

    public ManifestParser(Logger logger, Map configMap, Map headerMap) throws BundleException {
        String pkgName;
        int reqIdx;
        Object[][][] clauses;
        ICapability moduleCap;
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_headerMap = headerMap;
        String manifestVersion = (String)this.m_headerMap.get("Bundle-ManifestVersion");
        String string = manifestVersion = manifestVersion == null ? null : manifestVersion.trim();
        if (manifestVersion != null && !manifestVersion.equals("2")) {
            throw new BundleException("Unknown 'Bundle-ManifestVersion' value: " + manifestVersion);
        }
        ArrayList<ICapability> capList = new ArrayList<ICapability>();
        ArrayList<IRequirement> reqList = new ArrayList<IRequirement>();
        this.m_bundleVersion = Version.emptyVersion;
        if (headerMap.get("Bundle-Version") != null) {
            try {
                this.m_bundleVersion = Version.parseVersion((String)headerMap.get("Bundle-Version"));
            }
            catch (RuntimeException ex) {
                if (this.getManifestVersion().equals("2")) {
                    throw ex;
                }
                this.m_bundleVersion = Version.emptyVersion;
            }
        }
        if ((moduleCap = ManifestParser.parseBundleSymbolicName(this.m_headerMap)) != null) {
            this.m_bundleSymbolicName = (String)moduleCap.getProperties().get("bundle-symbolic-name");
            if (headerMap.get("Fragment-Host") == null) {
                capList.add(moduleCap);
                capList.add(new Capability("host", null, ((Capability)moduleCap).getAttributes()));
            }
        }
        if ((clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Fragment-Host"))).length > 0) {
            try {
                reqList.add(new Requirement("host", "(bundle-symbolic-name=" + clauses[0][0][0] + ")"));
            }
            catch (InvalidSyntaxException ex) {
                ex.printStackTrace();
            }
        }
        ICapability[] exportCaps = ManifestParser.parseExportHeader((String)headerMap.get("Export-Package"));
        for (int capIdx = 0; capIdx < exportCaps.length; ++capIdx) {
            String pkgName2 = (String)exportCaps[capIdx].getProperties().get("package");
            if (pkgName2.startsWith("java.")) {
                throw new BundleException("Exporting java.* packages not allowed: " + pkgName2);
            }
            capList.add(exportCaps[capIdx]);
        }
        this.m_capabilities = capList.toArray(new ICapability[capList.size()]);
        IRequirement[] bundleReq = ManifestParser.parseRequireBundleHeader((String)headerMap.get("Require-Bundle"));
        for (int reqIdx2 = 0; reqIdx2 < bundleReq.length; ++reqIdx2) {
            reqList.add(bundleReq[reqIdx2]);
        }
        IRequirement[] importReqs = ManifestParser.parseImportHeader((String)headerMap.get("Import-Package"));
        HashSet<String> dupeSet = new HashSet<String>();
        for (reqIdx = 0; reqIdx < importReqs.length; ++reqIdx) {
            pkgName = ((Requirement)importReqs[reqIdx]).getTargetName();
            if (!dupeSet.contains(pkgName)) {
                if (pkgName.startsWith("java.")) {
                    throw new BundleException("Importing java.* packages not allowed: " + pkgName);
                }
            } else {
                throw new BundleException("Duplicate import - " + pkgName);
            }
            dupeSet.add(pkgName);
            reqList.add(importReqs[reqIdx]);
        }
        this.m_requirements = reqList.toArray(new IRequirement[reqList.size()]);
        this.m_dynamicRequirements = ManifestParser.parseImportHeader((String)headerMap.get("DynamicImport-Package"));
        for (reqIdx = 0; reqIdx < this.m_dynamicRequirements.length; ++reqIdx) {
            pkgName = ((Requirement)this.m_dynamicRequirements[reqIdx]).getTargetName();
            if (pkgName.startsWith("java.")) {
                throw new BundleException("Dynamically importing java.* packages not allowed: " + pkgName);
            }
            if (pkgName.equals("*") || !pkgName.endsWith("*") || pkgName.endsWith(".*")) continue;
            throw new BundleException("Partial package name wild carding is not allowed: " + pkgName);
        }
        this.m_libraryHeaders = ManifestParser.parseLibraryStrings(this.m_logger, ManifestParser.parseDelimitedString((String)this.m_headerMap.get("Bundle-NativeCode"), ","));
        if (this.m_libraryHeaders.length > 0 && this.m_libraryHeaders[this.m_libraryHeaders.length - 1].getLibraryEntries() == null) {
            this.m_libraryHeadersOptional = true;
            R4LibraryClause[] tmp = new R4LibraryClause[this.m_libraryHeaders.length - 1];
            System.arraycopy(this.m_libraryHeaders, 0, tmp, 0, this.m_libraryHeaders.length - 1);
            this.m_libraryHeaders = tmp;
        }
        this.parseActivationPolicy(headerMap);
        if (this.getManifestVersion().equals("2")) {
            this.checkAndNormalizeR4();
        } else {
            this.checkAndNormalizeR3();
        }
    }

    public String getManifestVersion() {
        String manifestVersion = (String)this.m_headerMap.get("Bundle-ManifestVersion");
        return manifestVersion == null ? "1" : manifestVersion.trim();
    }

    public int getActivationPolicy() {
        return this.m_activationPolicy;
    }

    public String getActivationIncludeDirective() {
        return this.m_activationIncludeDir;
    }

    public String getActivationExcludeDirective() {
        return this.m_activationExcludeDir;
    }

    public boolean isExtension() {
        return this.m_isExtension;
    }

    public String getSymbolicName() {
        return this.m_bundleSymbolicName;
    }

    public Version getBundleVersion() {
        return this.m_bundleVersion;
    }

    public ICapability[] getCapabilities() {
        return this.m_capabilities;
    }

    public IRequirement[] getRequirements() {
        return this.m_requirements;
    }

    public IRequirement[] getDynamicRequirements() {
        return this.m_dynamicRequirements;
    }

    public R4LibraryClause[] getLibraryClauses() {
        return this.m_libraryHeaders;
    }

    public R4Library[] getLibraries() {
        R4Library[] libs = null;
        try {
            R4LibraryClause clause = this.getSelectedLibraryClause();
            if (clause != null) {
                String[] entries = clause.getLibraryEntries();
                libs = new R4Library[entries.length];
                int current = 0;
                for (int i = 0; i < libs.length; ++i) {
                    String name = this.getName(entries[i]);
                    boolean found = false;
                    for (int j = 0; !found && j < current; ++j) {
                        found = this.getName(entries[j]).equals(name);
                    }
                    if (found) continue;
                    libs[current++] = new R4Library(clause.getLibraryEntries()[i], clause.getOSNames(), clause.getProcessors(), clause.getOSVersions(), clause.getLanguages(), clause.getSelectionFilter());
                }
                if (current < libs.length) {
                    R4Library[] tmp = new R4Library[current];
                    System.arraycopy(libs, 0, tmp, 0, current);
                    libs = tmp;
                }
            }
        }
        catch (Exception ex) {
            libs = new R4Library[]{};
        }
        return libs;
    }

    private String getName(String path) {
        int idx = path.lastIndexOf(47);
        if (idx > -1) {
            return path.substring(idx);
        }
        return path;
    }

    private R4LibraryClause getSelectedLibraryClause() throws BundleException {
        if (this.m_libraryHeaders != null && this.m_libraryHeaders.length > 0) {
            ArrayList<R4LibraryClause> clauseList = new ArrayList<R4LibraryClause>();
            for (int i = 0; i < this.m_libraryHeaders.length; ++i) {
                if (!this.m_libraryHeaders[i].match(this.m_configMap)) continue;
                clauseList.add(this.m_libraryHeaders[i]);
            }
            int selected = 0;
            if (clauseList.size() == 0) {
                if (this.m_libraryHeadersOptional) {
                    return null;
                }
                throw new BundleException("Unable to select a native library clause.");
            }
            if (clauseList.size() == 1) {
                selected = 0;
            } else if (clauseList.size() > 1) {
                selected = this.firstSortedClause(clauseList);
            }
            return (R4LibraryClause)clauseList.get(selected);
        }
        return null;
    }

    private int firstSortedClause(List clauseList) {
        VersionRange range;
        int k;
        String[] osversions;
        int index;
        int i;
        ArrayList<String> indexList = new ArrayList<String>();
        ArrayList<String> selection = new ArrayList<String>();
        for (int i2 = 0; i2 < clauseList.size(); ++i2) {
            indexList.add("" + i2);
        }
        Version osVersionRangeMaxFloor = new Version(0, 0, 0);
        for (i = 0; i < indexList.size(); ++i) {
            index = Integer.parseInt(indexList.get(i).toString());
            osversions = ((R4LibraryClause)clauseList.get(index)).getOSVersions();
            if (osversions != null) {
                selection.add("" + indexList.get(i));
            }
            for (k = 0; osversions != null && k < osversions.length; ++k) {
                range = VersionRange.parse(osversions[k]);
                if (range.getLow().compareTo(osVersionRangeMaxFloor) < 0) continue;
                osVersionRangeMaxFloor = range.getLow();
            }
        }
        if (selection.size() == 1) {
            return Integer.parseInt(selection.get(0).toString());
        }
        if (selection.size() > 1) {
            indexList = selection;
            selection = new ArrayList();
            for (i = 0; i < indexList.size(); ++i) {
                index = Integer.parseInt(indexList.get(i).toString());
                osversions = ((R4LibraryClause)clauseList.get(index)).getOSVersions();
                for (k = 0; k < osversions.length; ++k) {
                    range = VersionRange.parse(osversions[k]);
                    if (range.getLow().compareTo(osVersionRangeMaxFloor) < 0) continue;
                    selection.add("" + indexList.get(i));
                }
            }
        }
        if (selection.size() == 0) {
            selection.clear();
            indexList.clear();
            for (i = 0; i < clauseList.size(); ++i) {
                indexList.add("" + i);
            }
        } else {
            if (selection.size() == 1) {
                return Integer.parseInt(selection.get(0).toString());
            }
            indexList = selection;
            selection.clear();
        }
        for (i = 0; i < indexList.size(); ++i) {
            index = Integer.parseInt(indexList.get(i).toString());
            if (((R4LibraryClause)clauseList.get(index)).getLanguages() == null) continue;
            selection.add("" + indexList.get(i));
        }
        if (selection.size() == 0) {
            return 0;
        }
        return Integer.parseInt(selection.get(0).toString());
    }

    private void checkAndNormalizeR3() throws BundleException {
        int i;
        int i2;
        int attrIdx;
        R4Attribute pkgVersion;
        R4Attribute pkgName;
        for (int capIdx = 0; this.m_capabilities != null && capIdx < this.m_capabilities.length; ++capIdx) {
            if (!this.m_capabilities[capIdx].getNamespace().equals("package")) continue;
            if (((Capability)this.m_capabilities[capIdx]).getDirectives().length != 0) {
                throw new BundleException("R3 exports cannot contain directives.");
            }
            if (((Capability)this.m_capabilities[capIdx]).getAttributes() == null) continue;
            pkgName = null;
            pkgVersion = new R4Attribute("version", Version.emptyVersion, false);
            for (attrIdx = 0; attrIdx < ((Capability)this.m_capabilities[capIdx]).getAttributes().length; ++attrIdx) {
                if (((Capability)this.m_capabilities[capIdx]).getAttributes()[attrIdx].getName().equals("package")) {
                    pkgName = ((Capability)this.m_capabilities[capIdx]).getAttributes()[attrIdx];
                    continue;
                }
                if (((Capability)this.m_capabilities[capIdx]).getAttributes()[attrIdx].getName().equals("version")) {
                    pkgVersion = ((Capability)this.m_capabilities[capIdx]).getAttributes()[attrIdx];
                    continue;
                }
                this.m_logger.log(2, "Unknown R3 export attribute: " + ((Capability)this.m_capabilities[capIdx]).getAttributes()[attrIdx].getName());
            }
            this.m_capabilities[capIdx] = new Capability("package", null, new R4Attribute[]{pkgName, pkgVersion});
        }
        for (int reqIdx = 0; this.m_requirements != null && reqIdx < this.m_requirements.length; ++reqIdx) {
            if (!this.m_requirements[reqIdx].getNamespace().equals("package")) continue;
            if (((Requirement)this.m_requirements[reqIdx]).getDirectives().length != 0) {
                throw new BundleException("R3 imports cannot contain directives.");
            }
            if (((Requirement)this.m_requirements[reqIdx]).getAttributes() == null) continue;
            pkgName = null;
            pkgVersion = new R4Attribute("version", new VersionRange(Version.emptyVersion, true, null, true), false);
            for (attrIdx = 0; attrIdx < ((Requirement)this.m_requirements[reqIdx]).getAttributes().length; ++attrIdx) {
                if (((Requirement)this.m_requirements[reqIdx]).getAttributes()[attrIdx].getName().equals("package")) {
                    pkgName = ((Requirement)this.m_requirements[reqIdx]).getAttributes()[attrIdx];
                    continue;
                }
                if (((Requirement)this.m_requirements[reqIdx]).getAttributes()[attrIdx].getName().equals("version")) {
                    pkgVersion = ((Requirement)this.m_requirements[reqIdx]).getAttributes()[attrIdx];
                    continue;
                }
                this.m_logger.log(2, "Unknown R3 import attribute: " + ((Requirement)this.m_requirements[reqIdx]).getAttributes()[attrIdx].getName());
            }
            this.m_requirements[reqIdx] = new Requirement("package", null, new R4Attribute[]{pkgName, pkgVersion});
        }
        HashMap<String, IRequirement> map = new HashMap<String, IRequirement>();
        for (i2 = 0; i2 < this.m_requirements.length; ++i2) {
            if (!this.m_requirements[i2].getNamespace().equals("package")) continue;
            map.put(((Requirement)this.m_requirements[i2]).getTargetName(), this.m_requirements[i2]);
        }
        for (i2 = 0; i2 < this.m_capabilities.length; ++i2) {
            if (!this.m_capabilities[i2].getNamespace().equals("package") || map.get(this.m_capabilities[i2].getProperties().get("package")) != null) continue;
            R4Attribute[] attrs = (R4Attribute[])((Capability)this.m_capabilities[i2]).getAttributes().clone();
            for (attrIdx = 0; attrs != null && attrIdx < attrs.length; ++attrIdx) {
                if (!attrs[attrIdx].getName().equals("version")) continue;
                attrs[attrIdx] = new R4Attribute(attrs[attrIdx].getName(), VersionRange.parse(attrs[attrIdx].getValue().toString()), attrs[attrIdx].isMandatory());
            }
            map.put((String)this.m_capabilities[i2].getProperties().get("package"), new Requirement("package", null, attrs));
        }
        this.m_requirements = map.values().toArray(new IRequirement[map.size()]);
        String usesValue = "";
        for (int i3 = 0; this.m_requirements != null && i3 < this.m_requirements.length; ++i3) {
            if (!this.m_requirements[i3].getNamespace().equals("package")) continue;
            usesValue = usesValue + (usesValue.length() > 0 ? "," : "") + ((Requirement)this.m_requirements[i3]).getTargetName();
        }
        R4Directive uses = new R4Directive("uses", usesValue);
        for (i = 0; this.m_capabilities != null && i < this.m_capabilities.length; ++i) {
            if (!this.m_capabilities[i].getNamespace().equals("package")) continue;
            this.m_capabilities[i] = new Capability("package", new R4Directive[]{uses}, ((Capability)this.m_capabilities[i]).getAttributes());
        }
        for (i = 0; this.m_dynamicRequirements != null && i < this.m_dynamicRequirements.length; ++i) {
            if (((Requirement)this.m_dynamicRequirements[i]).getDirectives().length != 0) {
                throw new BundleException("R3 dynamic imports cannot contain directives.");
            }
            if (((Requirement)this.m_dynamicRequirements[i]).getAttributes().length == 0) continue;
        }
    }

    private void checkAndNormalizeR4() throws BundleException {
        if (this.m_bundleSymbolicName == null) {
            throw new BundleException("R4 bundle manifests must include bundle symbolic name.");
        }
        this.m_capabilities = ManifestParser.checkAndNormalizeR4Exports(this.m_capabilities, this.m_bundleSymbolicName, this.m_bundleVersion);
        R4Directive extension = ManifestParser.parseExtensionBundleHeader((String)this.m_headerMap.get("Fragment-Host"));
        if (extension != null) {
            if (!"framework".equals(extension.getValue()) && !"bootclasspath".equals(extension.getValue())) {
                throw new BundleException("Extension bundle must have either 'extension:=framework' or 'extension:=bootclasspath'");
            }
            this.checkExtensionBundle();
            this.m_isExtension = true;
        }
    }

    private static ICapability[] checkAndNormalizeR4Exports(ICapability[] caps, String bsn, Version bv) throws BundleException {
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package")) continue;
            R4Attribute[] attrs = ((Capability)caps[i]).getAttributes();
            for (int attrIdx = 0; attrIdx < attrs.length; ++attrIdx) {
                if (!attrs[attrIdx].getName().equals("bundle-version") && !attrs[attrIdx].getName().equals("bundle-symbolic-name")) continue;
                throw new BundleException("Exports must not specify bundle symbolic name or bundle version.");
            }
            R4Attribute[] newAttrs = new R4Attribute[attrs.length + 2];
            System.arraycopy(attrs, 0, newAttrs, 0, attrs.length);
            newAttrs[attrs.length] = new R4Attribute("bundle-symbolic-name", bsn, false);
            newAttrs[attrs.length + 1] = new R4Attribute("bundle-version", bv, false);
            caps[i] = new Capability("package", ((Capability)caps[i]).getDirectives(), newAttrs);
        }
        return caps;
    }

    private void checkExtensionBundle() throws BundleException {
        if (this.m_headerMap.containsKey("Import-Package") || this.m_headerMap.containsKey("Require-Bundle") || this.m_headerMap.containsKey("Bundle-NativeCode") || this.m_headerMap.containsKey("DynamicImport-Package") || this.m_headerMap.containsKey("Bundle-Activator")) {
            throw new BundleException("Invalid extension bundle manifest");
        }
    }

    private static ICapability parseBundleSymbolicName(Map headerMap) throws BundleException {
        Object[][][] clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Bundle-SymbolicName"));
        if (clauses.length > 0) {
            if (clauses.length > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + headerMap.get("Bundle-SymbolicName"));
            }
            if (clauses[0][0].length > 1) {
                throw new BundleException("Cannot have multiple symbolic names: " + headerMap.get("Bundle-SymbolicName"));
            }
            Version bundleVersion = Version.emptyVersion;
            if (headerMap.get("Bundle-Version") != null) {
                try {
                    bundleVersion = Version.parseVersion((String)headerMap.get("Bundle-Version"));
                }
                catch (RuntimeException ex) {
                    if (((String)headerMap.get("Bundle-ManifestVersion")).equals("2")) {
                        throw ex;
                    }
                    bundleVersion = Version.emptyVersion;
                }
            }
            String symName = (String)clauses[0][0][0];
            R4Attribute[] attrs = new R4Attribute[]{new R4Attribute("bundle-symbolic-name", symName, false), new R4Attribute("bundle-version", bundleVersion, false)};
            return new Capability("module", (R4Directive[])clauses[0][1], attrs);
        }
        return null;
    }

    public static ICapability[] parseExportHeader(String header, String bsn, Version bv) throws BundleException {
        ICapability[] caps = ManifestParser.parseExportHeader(header);
        try {
            caps = ManifestParser.checkAndNormalizeR4Exports(caps, bsn, bv);
        }
        catch (BundleException ex) {
            caps = null;
        }
        return caps;
    }

    private static ICapability[] parseExportHeader(String header) {
        Object[][][] clauses = ManifestParser.parseStandardHeader(header);
        HashMap<String, R4Attribute> attrMap = new HashMap<String, R4Attribute>();
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            attrMap.clear();
            for (int attrIdx = 0; attrIdx < clauses[clauseIdx][2].length; ++attrIdx) {
                R4Attribute attr = (R4Attribute)clauses[clauseIdx][2][attrIdx];
                attrMap.put(attr.getName(), attr);
            }
            R4Attribute v = (R4Attribute)attrMap.get("version");
            R4Attribute sv = (R4Attribute)attrMap.get("specification-version");
            if (v != null && sv != null && !((String)v.getValue()).trim().equals(((String)sv.getValue()).trim())) {
                throw new IllegalArgumentException("Both version and specificat-version are specified, but they are not equal.");
            }
            if (v == null && sv == null) {
                v = new R4Attribute("version", Version.emptyVersion, false);
            }
            if (v == null && sv == null) continue;
            attrMap.remove("specification-version");
            v = v == null ? sv : v;
            attrMap.put("version", new R4Attribute("version", Version.parseVersion(v.getValue().toString()), v.isMandatory()));
            clauses[clauseIdx][2] = attrMap.values().toArray(new R4Attribute[attrMap.size()]);
        }
        ArrayList<Capability> capList = new ArrayList<Capability>();
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            for (int pathIdx = 0; pathIdx < clauses[clauseIdx][0].length; ++pathIdx) {
                if (((String)clauses[clauseIdx][0][pathIdx]).length() == 0) {
                    throw new IllegalArgumentException("An empty package name was specified: " + header);
                }
                R4Attribute[] attrs = (R4Attribute[])clauses[clauseIdx][2];
                R4Attribute[] newAttrs = new R4Attribute[attrs.length + 1];
                newAttrs[0] = new R4Attribute("package", clauses[clauseIdx][0][pathIdx], false);
                System.arraycopy(attrs, 0, newAttrs, 1, attrs.length);
                capList.add(new Capability("package", (R4Directive[])clauses[clauseIdx][1], newAttrs));
            }
        }
        return capList.toArray(new ICapability[capList.size()]);
    }

    private static IRequirement[] parseImportHeader(String header) {
        Object[][][] clauses = ManifestParser.parseStandardHeader(header);
        HashMap<String, R4Attribute> attrMap = new HashMap<String, R4Attribute>();
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            attrMap.clear();
            for (int attrIdx = 0; attrIdx < clauses[clauseIdx][2].length; ++attrIdx) {
                R4Attribute attr = (R4Attribute)clauses[clauseIdx][2][attrIdx];
                attrMap.put(attr.getName(), attr);
            }
            R4Attribute v = (R4Attribute)attrMap.get("version");
            R4Attribute sv = (R4Attribute)attrMap.get("specification-version");
            if (v != null && sv != null && !((String)v.getValue()).trim().equals(((String)sv.getValue()).trim())) {
                throw new IllegalArgumentException("Both version and specificat-version are specified, but they are not equal.");
            }
            if (v != null || sv != null) {
                attrMap.remove("specification-version");
                v = v == null ? sv : v;
                attrMap.put("version", new R4Attribute("version", VersionRange.parse(v.getValue().toString()), v.isMandatory()));
            }
            if ((v = (R4Attribute)attrMap.get("bundle-version")) != null) {
                attrMap.put("bundle-version", new R4Attribute("bundle-version", VersionRange.parse(v.getValue().toString()), v.isMandatory()));
            }
            clauses[clauseIdx][2] = attrMap.values().toArray(new R4Attribute[attrMap.size()]);
        }
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            for (int pathIdx = 0; pathIdx < clauses[clauseIdx][0].length; ++pathIdx) {
                if (((String)clauses[clauseIdx][0][pathIdx]).length() == 0) {
                    throw new IllegalArgumentException("An empty package name was specified: " + header);
                }
                R4Attribute[] attrs = (R4Attribute[])clauses[clauseIdx][2];
                R4Attribute[] newAttrs = new R4Attribute[attrs.length + 1];
                newAttrs[0] = new R4Attribute("package", clauses[clauseIdx][0][pathIdx], false);
                System.arraycopy(attrs, 0, newAttrs, 1, attrs.length);
                reqList.add(new Requirement("package", (R4Directive[])clauses[clauseIdx][1], newAttrs));
            }
        }
        return reqList.toArray(new IRequirement[reqList.size()]);
    }

    private static IRequirement[] parseRequireBundleHeader(String header) {
        Object[][][] clauses = ManifestParser.parseStandardHeader(header);
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            for (int attrIdx = 0; attrIdx < clauses[clauseIdx][2].length; ++attrIdx) {
                R4Attribute attr = (R4Attribute)clauses[clauseIdx][2][attrIdx];
                if (!attr.getName().equals("bundle-version")) continue;
                clauses[clauseIdx][2][attrIdx] = new R4Attribute("bundle-version", VersionRange.parse(attr.getValue().toString()), attr.isMandatory());
            }
        }
        ArrayList<Requirement> reqList = new ArrayList<Requirement>();
        for (int clauseIdx = 0; clauseIdx < clauses.length; ++clauseIdx) {
            for (int pathIdx = 0; pathIdx < clauses[clauseIdx][0].length; ++pathIdx) {
                R4Attribute[] attrs = (R4Attribute[])clauses[clauseIdx][2];
                R4Attribute[] newAttrs = new R4Attribute[attrs.length + 1];
                newAttrs[0] = new R4Attribute("bundle-symbolic-name", clauses[clauseIdx][0][pathIdx], false);
                System.arraycopy(attrs, 0, newAttrs, 1, attrs.length);
                reqList.add(new Requirement("module", (R4Directive[])clauses[clauseIdx][1], newAttrs));
            }
        }
        return reqList.toArray(new IRequirement[reqList.size()]);
    }

    public static R4Directive parseExtensionBundleHeader(String header) throws BundleException {
        Object[][][] clauses = ManifestParser.parseStandardHeader(header);
        R4Directive result = null;
        if (clauses.length == 1) {
            for (int i = 0; result == null && i < clauses[0][1].length; ++i) {
                if (!"extension".equals(((R4Directive)clauses[0][1][i]).getName())) continue;
                if ("org.apache.felix.framework".equals(clauses[0][0][0]) || "system.bundle".equals(clauses[0][0][0])) {
                    result = (R4Directive)clauses[0][1][i];
                    continue;
                }
                throw new BundleException("Only the system bundle can have extension bundles.");
            }
        }
        return result;
    }

    private void parseActivationPolicy(Map headerMap) {
        this.m_activationPolicy = 0;
        Object[][][] clauses = ManifestParser.parseStandardHeader((String)headerMap.get("Bundle-ActivationPolicy"));
        if (clauses.length > 0) {
            for (int i = 0; i < clauses[0][0].length; ++i) {
                if (!clauses[0][0][i].equals("lazy")) continue;
                this.m_activationPolicy = 1;
                for (int j = 0; j < clauses[0][1].length; ++j) {
                    R4Directive dir = (R4Directive)clauses[0][1][j];
                    if (dir.getName().equalsIgnoreCase("include")) {
                        this.m_activationIncludeDir = dir.getValue();
                        continue;
                    }
                    if (!dir.getName().equalsIgnoreCase("exclude")) continue;
                    this.m_activationExcludeDir = dir.getValue();
                }
                break;
            }
        }
    }

    private static Object[][][] parseStandardHeader(String header) {
        Object[][][] clauses = null;
        if (header != null) {
            if (header.length() == 0) {
                throw new IllegalArgumentException("A header cannot be an empty string.");
            }
            String[] clauseStrings = ManifestParser.parseDelimitedString(header, ",");
            ArrayList<Object[][]> completeList = new ArrayList<Object[][]>();
            for (int i = 0; clauseStrings != null && i < clauseStrings.length; ++i) {
                completeList.add(ManifestParser.parseStandardHeaderClause(clauseStrings[i]));
            }
            clauses = (Object[][][])completeList.toArray((T[])new Object[completeList.size()][][]);
        }
        return clauses == null ? new Object[][][]{} : clauses;
    }

    private static Object[][] parseStandardHeaderClause(String clauseString) throws IllegalArgumentException {
        String[] pieces = ManifestParser.parseDelimitedString(clauseString, ";");
        int pathCount = 0;
        for (int pieceIdx = 0; pieceIdx < pieces.length && pieces[pieceIdx].indexOf(61) < 0; ++pieceIdx) {
            ++pathCount;
        }
        if (pathCount == 0) {
            throw new IllegalArgumentException("No paths specified in header: " + clauseString);
        }
        String[] paths = new String[pathCount];
        System.arraycopy(pieces, 0, paths, 0, pathCount);
        HashMap<String, R4Directive> dirsMap = new HashMap<String, R4Directive>();
        HashMap<String, R4Attribute> attrsMap = new HashMap<String, R4Attribute>();
        int idx = -1;
        String sep = null;
        for (int pieceIdx = pathCount; pieceIdx < pieces.length; ++pieceIdx) {
            idx = pieces[pieceIdx].indexOf(":=");
            if (idx >= 0) {
                sep = ":=";
            } else {
                idx = pieces[pieceIdx].indexOf("=");
                if (idx >= 0) {
                    sep = "=";
                } else {
                    throw new IllegalArgumentException("Not a directive/attribute: " + clauseString);
                }
            }
            String key = pieces[pieceIdx].substring(0, idx).trim();
            String value = pieces[pieceIdx].substring(idx + sep.length()).trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (sep.equals(":=")) {
                if (dirsMap.get(key) != null) {
                    throw new IllegalArgumentException("Duplicate directive: " + key);
                }
                dirsMap.put(key, new R4Directive(key, value));
                continue;
            }
            if (attrsMap.get(key) != null) {
                throw new IllegalArgumentException("Duplicate attribute: " + key);
            }
            attrsMap.put(key, new R4Attribute(key, value, false));
        }
        R4Directive[] dirs = dirsMap.values().toArray(new R4Directive[dirsMap.size()]);
        R4Attribute[] attrs = attrsMap.values().toArray(new R4Attribute[attrsMap.size()]);
        Object[][] clause = new Object[][]{paths, dirs, attrs};
        return clause;
    }

    public static String[] parseDelimitedString(String value, String delim) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                sb.append(c);
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list.toArray(new String[list.size()]);
    }

    private static R4LibraryClause[] parseLibraryStrings(Logger logger, String[] libStrs) throws IllegalArgumentException {
        if (libStrs == null) {
            return new R4LibraryClause[0];
        }
        ArrayList<R4LibraryClause> libList = new ArrayList<R4LibraryClause>();
        for (int i = 0; i < libStrs.length; ++i) {
            R4LibraryClause clause = R4LibraryClause.parse(logger, libStrs[i]);
            libList.add(clause);
        }
        return libList.toArray(new R4LibraryClause[libList.size()]);
    }
}

