/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Status;
import org.apache.servicemix.nmr.audit.AbstractAuditor;
import org.apache.servicemix.nmr.audit.AuditorException;
import org.apache.servicemix.nmr.audit.file.FileAuditorStrategy;
import org.apache.servicemix.util.FileUtil;

public class FileAuditor
extends AbstractAuditor {
    private static final Log LOG = LogFactory.getLog(FileAuditor.class);
    private File directory;
    private FileAuditorStrategy strategy = new FileAuditorStrategyImpl();

    public void setDirectory(File directory) {
        if (!directory.exists()) {
            LOG.info((Object)("Creating directory " + directory));
            directory.mkdirs();
        }
        this.directory = directory;
    }

    public void exchangeSent(Exchange exchange) {
        try {
            if (exchange.getStatus() == Status.Active) {
                OutputStream os = this.getOutputStream(exchange);
                os.write(exchange.display(true).getBytes());
                os.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error occurred while storing message %s", exchange.getId()), (Throwable)e);
        }
    }

    private OutputStream getOutputStream(Exchange exchange) throws FileNotFoundException {
        File file = new File(this.directory, this.strategy.getFileName(exchange));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public int deleteExchangesByIds(String[] ids) throws AuditorException {
        throw new AuditorException("deleteExchangesById(s) currently unsupported by FileAuditor");
    }

    public int getExchangeCount() throws AuditorException {
        return FileUtil.countFilesInDirectory((File)this.directory);
    }

    public String[] getExchangeIdsByRange(int fromIndex, int toIndex) throws AuditorException {
        throw new AuditorException("getExchangeIdsByRange currently unsupported by FileAuditor");
    }

    public Exchange[] getExchangesByIds(String[] ids) throws AuditorException {
        throw new AuditorException("getExchangeByIds currently unsupported by FileAuditor");
    }

    public String getDescription() {
        return "File-based auditing service";
    }

    private class FileAuditorStrategyImpl
    implements FileAuditorStrategy {
        private final DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");

        private FileAuditorStrategyImpl() {
        }

        public String getFileName(Exchange exchange) {
            return this.dateformat.format(new Date()) + File.separatorChar + exchange.getId().replaceAll("[:\\.]", "_");
        }
    }
}

