/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.servicemix.nmr.audit.lucene.LuceneCallback;

public class LuceneIndexer {
    protected Directory directory;
    private File segmentFile;

    public LuceneIndexer() {
        IndexWriter.setDefaultWriteLockTimeout((long)-1L);
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public void setDirectoryName(File directoryName) throws IOException {
        this.segmentFile = new File(directoryName, "segments");
        this.directory = FSDirectory.getDirectory((String)directoryName.toString(), (!this.segmentFile.exists() ? 1 : 0) != 0);
    }

    protected void remove(String id) throws IOException {
        this.remove(new String[]{id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(String[] ids) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            if (ids != null && ids.length > 0) {
                IndexWriter writer = new IndexWriter(this.directory, (Analyzer)new SimpleAnalyzer(), IndexWriter.MaxFieldLength.LIMITED);
                try {
                    for (int i = 0; i < ids.length; ++i) {
                        writer.deleteDocuments(new Term("id", ids[i]));
                    }
                    writer.commit();
                }
                finally {
                    writer.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Document lucDoc, String id) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            this.remove(id);
            IndexWriter writer = new IndexWriter(this.directory, (Analyzer)new SimpleAnalyzer(), IndexWriter.MaxFieldLength.LIMITED);
            try {
                writer.addDocument(lucDoc);
                writer.commit();
            }
            finally {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object search(LuceneCallback lc) throws IOException {
        Directory directory = this.directory;
        synchronized (directory) {
            Object object;
            IndexReader ir = IndexReader.open((Directory)this.directory);
            IndexSearcher is = new IndexSearcher(ir);
            try {
                object = lc.doCallback(is);
            }
            catch (Throwable throwable) {
                is.close();
                ir.close();
                throw throwable;
            }
            is.close();
            ir.close();
            return object;
        }
    }
}

