/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.felix.karaf.main.BootstrapLogManager;
import org.apache.felix.karaf.main.Lock;
import org.apache.felix.karaf.main.Statements;

public class DefaultJDBCLock
implements Lock {
    private static final Logger LOG = Logger.getLogger(DefaultJDBCLock.class.getName());
    private static final String PROPERTY_LOCK_URL = "karaf.lock.jdbc.url";
    private static final String PROPERTY_LOCK_JDBC_DRIVER = "karaf.lock.jdbc.driver";
    private static final String PROPERTY_LOCK_JDBC_USER = "karaf.lock.jdbc.user";
    private static final String PROPERTY_LOCK_JDBC_PASSWORD = "karaf.lock.jdbc.password";
    private static final String PROPERTY_LOCK_JDBC_TABLE = "karaf.lock.jdbc.table";
    private static final String PROPERTY_LOCK_JDBC_CLUSTERNAME = "karaf.lock.jdbc.clustername";
    private static final String PROPERTY_LOCK_JDBC_TIMEOUT = "karaf.lock.jdbc.timeout";
    private final Statements statements;
    private Connection lockConnection;
    private String url;
    private String driver;
    private String user;
    private String password;
    private String table;
    private String clusterName;
    private int timeout;

    public DefaultJDBCLock(Properties props) {
        LOG.addHandler(BootstrapLogManager.getDefaultHandler());
        this.url = props.getProperty(PROPERTY_LOCK_URL);
        this.driver = props.getProperty(PROPERTY_LOCK_JDBC_DRIVER);
        this.user = props.getProperty(PROPERTY_LOCK_JDBC_USER);
        this.password = props.getProperty(PROPERTY_LOCK_JDBC_PASSWORD);
        this.table = props.getProperty(PROPERTY_LOCK_JDBC_TABLE);
        this.clusterName = props.getProperty(PROPERTY_LOCK_JDBC_CLUSTERNAME);
        String time = props.getProperty(PROPERTY_LOCK_JDBC_TIMEOUT);
        this.lockConnection = null;
        if (this.table == null) {
            this.table = "KARAF_LOCK";
        }
        if (this.clusterName == null) {
            this.clusterName = "karaf";
        }
        this.statements = new Statements(this.table, this.clusterName);
        this.timeout = time != null ? Integer.parseInt(time) * 1000 : 10000;
        if (this.user == null) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setUpdateCursor() throws Exception {
        Statement statement = null;
        boolean result = false;
        try {
            if (this.lockConnection == null || this.lockConnection.isClosed()) {
                this.lockConnection = this.getConnection(this.driver, this.url, this.user, this.password);
                this.lockConnection.setAutoCommit(false);
                this.statements.init(this.lockConnection);
            }
            String sql = this.statements.setUpdateCursor();
            statement = this.lockConnection.prepareStatement(sql);
            result = statement.execute();
        }
        catch (Exception e) {
            LOG.warning("Could not obtain connection: " + e.getMessage());
        }
        finally {
            if (null != statement) {
                try {
                    LOG.severe("Cleaning up DB connection.");
                    statement.close();
                }
                catch (SQLException e1) {
                    LOG.severe("Caught while closing statement: " + e1.getMessage());
                }
                statement = null;
            }
        }
        LOG.info("Connected to data source: " + this.url);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() {
        Statement statement = null;
        boolean result = false;
        try {
            if (!this.setUpdateCursor()) {
                LOG.severe("Could not set DB update cursor");
                boolean bl = result;
                return bl;
            }
            long time = System.currentTimeMillis();
            statement = this.lockConnection.prepareStatement(this.statements.getLockUpdateStatement(time));
            int rows = statement.executeUpdate();
            if (rows >= 1) {
                result = true;
            }
        }
        catch (Exception e) {
            LOG.warning("Failed to acquire database lock: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.severe("Failed to close statement" + e);
                }
            }
        }
        return result;
    }

    public void release() throws Exception {
        if (this.lockConnection != null && !this.lockConnection.isClosed()) {
            this.lockConnection.rollback();
            this.lockConnection.close();
            this.lockConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() throws Exception {
        if (this.lockConnection == null || this.lockConnection.isClosed()) {
            LOG.severe("Lost lock!");
            return false;
        }
        Statement statement = null;
        boolean result = true;
        try {
            long time = System.currentTimeMillis();
            statement = this.lockConnection.prepareStatement(this.statements.getLockUpdateStatement(time));
            int rows = statement.executeUpdate();
            if (rows < 1) {
                result = false;
            }
        }
        catch (Exception ex) {
            LOG.severe("Error occured while testing lock: " + ex + " " + ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception ex1) {
                    LOG.severe("Error occured after testing lock: " + ex1.getMessage());
                }
            }
        }
        return result;
    }

    private Connection getConnection(String driver, String url, String username, String password) throws Exception {
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = url.startsWith("jdbc:derby:") ? DriverManager.getConnection(url + ";create=true", username, password) : DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            LOG.severe("Error occured while setting up JDBC connection: " + e);
            throw e;
        }
        return conn;
    }
}

