/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.cluster.requestor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.servicemix.jbi.cluster.requestor.AbstractJmsRequestorPool;
import org.apache.servicemix.jbi.cluster.requestor.JmsRequestor;
import org.apache.servicemix.jbi.cluster.requestor.JmsRequestorListener;
import org.apache.servicemix.jbi.cluster.requestor.JmsRequestorPool;
import org.apache.servicemix.jbi.cluster.requestor.Transacted;
import org.springframework.jms.JmsException;
import org.springframework.jms.support.JmsUtils;

public abstract class AbstractPollingRequestorPool
extends AbstractJmsRequestorPool
implements JmsRequestorPool {
    protected JmsRequestorListener listener;
    protected Transacted transacted;
    protected TransactionManager transactionManager;
    protected final Map<String, Requestor> parked = new ConcurrentHashMap<String, Requestor>();

    public JmsRequestorListener getListener() {
        return this.listener;
    }

    public void setListener(JmsRequestorListener listener) {
        this.listener = listener;
    }

    public Transacted getTransacted() {
        return this.transacted;
    }

    public void setTransacted(Transacted transacted) {
        this.transacted = transacted;
        switch (transacted) {
            case None: {
                this.setSessionTransacted(false);
                this.setSessionAcknowledgeMode(1);
                break;
            }
            case ClientAck: {
                this.setSessionTransacted(false);
                this.setSessionAcknowledgeMode(2);
                break;
            }
            case Jms: 
            case Xa: {
                this.setSessionTransacted(true);
            }
        }
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected void parkItem(Requestor item, String id) {
        this.parked.put(id, item);
    }

    public JmsRequestor newRequestor() throws JMSException {
        return this.createRequestor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsRequestor resume(String id) {
        Requestor requestor;
        Requestor requestor2 = requestor = this.parked.remove(id);
        synchronized (requestor2) {
            requestor.resume();
        }
        return requestor;
    }

    protected void doShutdown() throws JMSException {
    }

    protected abstract JmsRequestor createRequestor(boolean var1) throws JMSException;

    public static class TransactionException
    extends RuntimeException {
        public TransactionException(Throwable cause) {
            super(cause);
        }
    }

    public class Requestor
    implements JmsRequestor {
        protected Connection connection;
        protected Session session;
        protected MessageConsumer consumer;
        protected MessageProducer producer;
        protected boolean suspended;
        protected boolean rollbackOnly;
        protected Message message;
        protected Transaction transaction;

        public synchronized Session getSession() throws JmsException {
            try {
                if (this.session == null) {
                    Connection conToUse;
                    if (this.connection == null) {
                        if (AbstractPollingRequestorPool.this.sharedConnectionEnabled()) {
                            conToUse = AbstractPollingRequestorPool.this.getSharedConnection();
                        } else {
                            this.connection = AbstractPollingRequestorPool.this.createConnection();
                            this.connection.start();
                            conToUse = this.connection;
                        }
                    } else {
                        conToUse = this.connection;
                    }
                    this.session = AbstractPollingRequestorPool.this.createSession(conToUse);
                }
                return this.session;
            }
            catch (JMSException e) {
                throw AbstractPollingRequestorPool.this.convertJmsAccessException(e);
            }
        }

        public synchronized Message receive(long timeout) throws JMSException {
            this.message = timeout < 0L ? this.getConsumer().receive() : this.getConsumer().receive(timeout);
            return this.message;
        }

        protected MessageConsumer getConsumer() throws JMSException {
            if (this.consumer == null) {
                this.consumer = AbstractPollingRequestorPool.this.createConsumer(this.session);
            }
            return this.consumer;
        }

        public synchronized void send(Message msg) throws JmsException {
            if (AbstractPollingRequestorPool.this.logger.isDebugEnabled()) {
                AbstractPollingRequestorPool.this.logger.debug((Object)("Sending JMS message: " + msg));
            }
            try {
                this.getProducer().send(msg);
            }
            catch (JMSException e) {
                throw AbstractPollingRequestorPool.this.convertJmsAccessException(e);
            }
        }

        protected MessageProducer getProducer() throws JMSException {
            if (this.producer == null) {
                this.producer = AbstractPollingRequestorPool.this.createProducer(this.session);
            }
            return this.producer;
        }

        public synchronized void close() {
            block18: {
                if (this.session != null && !this.suspended) {
                    try {
                        if (AbstractPollingRequestorPool.this.transacted == Transacted.Jms) {
                            if (this.rollbackOnly) {
                                this.session.rollback();
                            } else {
                                this.session.commit();
                            }
                            this.afterClose();
                            break block18;
                        }
                        if (AbstractPollingRequestorPool.this.transacted == Transacted.Xa) {
                            this.destroy();
                            try {
                                if (this.rollbackOnly) {
                                    if (AbstractPollingRequestorPool.this.logger.isDebugEnabled()) {
                                        AbstractPollingRequestorPool.this.logger.debug((Object)"Rolling back XA transaction");
                                    }
                                    AbstractPollingRequestorPool.this.transactionManager.rollback();
                                } else {
                                    if (AbstractPollingRequestorPool.this.logger.isDebugEnabled()) {
                                        AbstractPollingRequestorPool.this.logger.debug((Object)"Committing XA transaction");
                                    }
                                    AbstractPollingRequestorPool.this.transactionManager.commit();
                                }
                                break block18;
                            }
                            catch (Exception e) {
                                throw new TransactionException(e);
                            }
                        }
                        if (AbstractPollingRequestorPool.this.transacted == Transacted.ClientAck) {
                            if (this.message != null) {
                                if (!this.rollbackOnly) {
                                    this.message.acknowledge();
                                } else {
                                    this.destroyConsumer();
                                }
                            }
                            this.afterClose();
                        } else {
                            this.afterClose();
                        }
                    }
                    catch (JMSException e) {
                        this.destroy();
                        throw AbstractPollingRequestorPool.this.convertJmsAccessException(e);
                    }
                }
            }
        }

        protected void afterClose() throws JMSException {
            this.destroy();
        }

        public synchronized void suspend(String id) {
            if (AbstractPollingRequestorPool.this.transacted == Transacted.Xa) {
                try {
                    if (AbstractPollingRequestorPool.this.logger.isDebugEnabled()) {
                        AbstractPollingRequestorPool.this.logger.debug((Object)"Suspending XA transaction");
                    }
                    AbstractPollingRequestorPool.this.transactionManager.suspend();
                }
                catch (Exception e) {
                    throw new TransactionException(e);
                }
            }
            if (id != null) {
                AbstractPollingRequestorPool.this.parkItem(this, id);
            }
            this.suspended = true;
        }

        protected void destroy() {
            JmsUtils.closeSession((Session)this.session);
            JmsUtils.closeConnection((Connection)this.connection);
            this.session = null;
            this.connection = null;
        }

        protected void destroyConsumer() {
            MessageConsumer c = this.consumer;
            this.consumer = null;
            JmsUtils.closeMessageConsumer((MessageConsumer)c);
        }

        protected synchronized void resume() {
            if (this.transaction != null) {
                try {
                    if (AbstractPollingRequestorPool.this.logger.isDebugEnabled()) {
                        AbstractPollingRequestorPool.this.logger.debug((Object)"Resuming XA transaction");
                    }
                    AbstractPollingRequestorPool.this.transactionManager.resume(this.transaction);
                }
                catch (Exception e) {
                    throw new TransactionException(e);
                }
            }
            this.suspended = false;
        }

        protected void reset() {
            this.rollbackOnly = false;
            this.message = null;
        }

        public synchronized void begin() throws JmsException {
            this.startXaTransaction();
            this.getSession();
        }

        protected void startXaTransaction() {
            if (AbstractPollingRequestorPool.this.transacted == Transacted.Xa) {
                try {
                    if (AbstractPollingRequestorPool.this.logger.isDebugEnabled()) {
                        AbstractPollingRequestorPool.this.logger.debug((Object)"Starting XA transaction");
                    }
                    AbstractPollingRequestorPool.this.transactionManager.begin();
                    this.transaction = AbstractPollingRequestorPool.this.transactionManager.getTransaction();
                }
                catch (Exception e) {
                    throw new TransactionException(e);
                }
            }
        }

        public synchronized void setRollbackOnly() {
            this.rollbackOnly = true;
            if (AbstractPollingRequestorPool.this.transacted == Transacted.Xa) {
                try {
                    AbstractPollingRequestorPool.this.transactionManager.setRollbackOnly();
                }
                catch (Exception e) {
                    throw new TransactionException(e);
                }
            }
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

