/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContextWrapper
extends InitialContext {
    public static final String OSGI_SCHEME = "osgi";
    private final Context delegate;
    private final Context osgiContext;

    public InitialContextWrapper(Context delegate, Context osgiContext, Hashtable<?, ?> environment) throws NamingException {
        super(environment);
        this.delegate = delegate;
        this.osgiContext = osgiContext;
    }

    @Override
    protected Context getDefaultInitCtx() throws NamingException {
        return this.delegate;
    }

    @Override
    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        Context ctx;
        String scheme = InitialContextWrapper.getURLScheme(name);
        if (OSGI_SCHEME.equals(scheme)) {
            return this.osgiContext;
        }
        if (scheme != null && (ctx = NamingManager.getURLContext(scheme, this.delegate.getEnvironment())) != null) {
            return ctx;
        }
        return this.delegate;
    }

    @Override
    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            Context ctx;
            String first = name.get(0);
            String scheme = InitialContextWrapper.getURLScheme(first);
            if (OSGI_SCHEME.equals(scheme)) {
                return this.osgiContext;
            }
            if (scheme != null && (ctx = NamingManager.getURLContext(scheme, this.delegate.getEnvironment())) != null) {
                return ctx;
            }
        }
        return this.delegate;
    }

    private static String getURLScheme(String str) {
        int colon_posn = str.indexOf(58);
        int slash_posn = str.indexOf(47);
        if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
            return str.substring(0, colon_posn);
        }
        return null;
    }
}

