/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.xbean.naming.context.VirtualSubcontext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextFederation {
    private final Context actualContext;
    private final AtomicReference<Set<Context>> federatedContextRef = new AtomicReference(Collections.emptySet());
    public static final int MAX_WRITE_ATTEMPTS = 10;

    public ContextFederation(Context actualContext) {
        this.actualContext = actualContext;
    }

    public void addContext(Context context) {
        for (int i = 0; i < 10; ++i) {
            Set<Context> federatedContext = this.getFederatedContexts();
            Set<Context> newFederatedContext = new LinkedHashSet<Context>(federatedContext);
            newFederatedContext.add(context);
            newFederatedContext = Collections.unmodifiableSet(newFederatedContext);
            if (!this.federatedContextRef.compareAndSet(federatedContext, newFederatedContext)) continue;
            return;
        }
        throw new RuntimeException("Unable to update federatedContextRef within 10 attempts");
    }

    public Set<Context> getFederatedContexts() {
        return this.federatedContextRef.get();
    }

    public Object getFederatedBinding(String name) throws NamingException {
        for (Context context : this.getFederatedContexts()) {
            try {
                Object value = context.lookup(name);
                if (value == null) continue;
                return value;
            }
            catch (NamingException e) {
            }
        }
        return null;
    }

    public Map<String, Object> getFederatedBindings() throws NamingException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        for (Context context : this.getFederatedContexts()) {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
            while (namingEnumeration.hasMoreElements()) {
                Binding binding = (Binding)namingEnumeration.nextElement();
                String name = binding.getName();
                if (bindings.containsKey(name)) continue;
                bindings.put(name, binding.getObject());
            }
        }
        return bindings;
    }

    protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
        for (Context context : this.getFederatedContexts()) {
            try {
                if (rebind) {
                    context.rebind(name, value);
                } else {
                    context.bind(name, value);
                }
                return true;
            }
            catch (OperationNotSupportedException ignored) {
            }
        }
        return false;
    }

    protected boolean removeBinding(String name) throws NamingException {
        for (Context context : this.getFederatedContexts()) {
            try {
                context.unbind(name);
                return true;
            }
            catch (OperationNotSupportedException ignored) {
            }
        }
        return false;
    }

    public Object lookup(Name name) {
        for (Context federatedContext : this.getFederatedContexts()) {
            try {
                Object value = federatedContext.lookup(name);
                if (value instanceof Context) {
                    return new VirtualSubcontext(name, this.actualContext);
                }
                return value;
            }
            catch (NamingException ignored) {
            }
        }
        return null;
    }

    public ContextFederation createSubcontextFederation(String subcontextName, Context actualSubcontext) throws NamingException {
        Name parsedSubcontextName = this.actualContext.getNameParser("").parse(subcontextName);
        ContextFederation subcontextFederation = new ContextFederation(actualSubcontext);
        for (Context federatedContext : this.getFederatedContexts()) {
            VirtualSubcontext virtualSubcontext = new VirtualSubcontext(parsedSubcontextName, federatedContext);
            subcontextFederation.addContext(virtualSubcontext);
        }
        return subcontextFederation;
    }
}

