/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.collection;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;

public class DynamicCollection
extends AbstractCollection {
    protected final Object iteratorsLock = new Object();
    protected final List storage;
    protected final Map iterators;

    public DynamicCollection() {
        this(16);
    }

    public DynamicCollection(int size) {
        this.storage = new ArrayList(size);
        this.iterators = new WeakHashMap(4);
    }

    public DynamicCollection(Collection c) {
        this(c.size());
        this.addAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        DynamicIterator iter = new DynamicIterator();
        Object object = this.iteratorsLock;
        synchronized (object) {
            this.iterators.put(iter, null);
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.storage;
        synchronized (list) {
            this.storage.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List list = this.storage;
        synchronized (list) {
            return this.storage.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        List list = this.storage;
        synchronized (list) {
            return this.storage.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        List list = this.storage;
        synchronized (list) {
            return this.storage.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        List list = this.storage;
        synchronized (list) {
            return this.storage.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        List list = this.storage;
        synchronized (list) {
            return this.storage.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List list = this.storage;
        synchronized (list) {
            return this.storage.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        List list = this.storage;
        synchronized (list) {
            int index = this.storage.indexOf(o);
            if (index == -1) {
                return false;
            }
            this.remove(index);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object remove(int index) {
        Object o = null;
        List list = this.storage;
        synchronized (list) {
            Object object = this.iteratorsLock;
            synchronized (object) {
                o = this.storage.remove(index);
                Iterator iter = this.iterators.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    DynamicIterator dynamicIterator = (DynamicIterator)entry.getKey();
                    if (index >= dynamicIterator.cursor) continue;
                    --dynamicIterator.cursor;
                }
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(int index, Object o) {
        List list = this.storage;
        synchronized (list) {
            Object object = this.iteratorsLock;
            synchronized (object) {
                this.storage.add(index, o);
                Iterator iter = this.iterators.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    DynamicIterator dynamicIterator = (DynamicIterator)entry.getKey();
                    if (index >= dynamicIterator.cursor) continue;
                    ++dynamicIterator.cursor;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        List list = this.storage;
        synchronized (list) {
            return this.storage.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] array) {
        List list = this.storage;
        synchronized (list) {
            return this.storage.toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List list = this.storage;
        synchronized (list) {
            return this.storage.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int indexOf(Object o) {
        List list = this.storage;
        synchronized (list) {
            return this.storage.indexOf(o);
        }
    }

    protected class DynamicIterator
    implements Iterator {
        protected volatile int cursor = 0;
        protected final Object lock = new Object();
        protected boolean removalAllowed = false;
        protected Boolean hasNext = null;

        protected DynamicIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            List list = DynamicCollection.this.storage;
            synchronized (list) {
                Object object = DynamicCollection.this.iteratorsLock;
                synchronized (object) {
                    return this.unsafeHasNext();
                }
            }
        }

        protected boolean unsafeHasNext() {
            this.hasNext = this.cursor < DynamicCollection.this.storage.size() ? Boolean.TRUE : Boolean.FALSE;
            return this.hasNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object next() {
            try {
                this.removalAllowed = true;
                if (this.hasNext == null) {
                    List list = DynamicCollection.this.storage;
                    synchronized (list) {
                        Object object = DynamicCollection.this.iteratorsLock;
                        synchronized (object) {
                            if (!this.unsafeHasNext()) throw new NoSuchElementException();
                            Object e = DynamicCollection.this.storage.get(this.cursor++);
                            return e;
                        }
                    }
                }
                if (this.hasNext.booleanValue()) {
                    List list = DynamicCollection.this.storage;
                    synchronized (list) {
                        Object object = DynamicCollection.this.iteratorsLock;
                        synchronized (object) {
                            if (this.unsafeHasNext()) {
                                Object e = DynamicCollection.this.storage.get(this.cursor++);
                                return e;
                            }
                        }
                    }
                    list = null;
                    return list;
                }
                if (this.hasNext != false) throw new NoSuchElementException();
                throw new NoSuchElementException();
            }
            finally {
                this.hasNext = null;
            }
        }

        public void remove() {
            if (!this.removalAllowed) {
                throw new IllegalStateException();
            }
            DynamicCollection.this.remove(this.cursor - 1);
            this.removalAllowed = false;
        }
    }
}

