/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support.internal.support;

import org.springframework.osgi.service.importer.support.internal.support.RetryCallback;
import org.springframework.util.Assert;

public class RetryTemplate {
    private static final int hashCode = RetryTemplate.class.hashCode() * 13;
    public static final long DEFAULT_WAIT_TIME = 1000L;
    public static final int DEFAULT_RETRY_NUMBER = 3;
    private final Object monitor = new Object();
    private final Object notificationLock;
    private long waitTime = 1000L;
    private int retryNumbers = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryTemplate(int retryNumbers, long waitTime, Object notificationLock) {
        Assert.isTrue((retryNumbers >= 0 ? 1 : 0) != 0, (String)"retryNumbers must be positive");
        Assert.isTrue((waitTime >= 0L ? 1 : 0) != 0, (String)"waitTime must be positive");
        Assert.notNull((Object)notificationLock, (String)"notificationLock must be non null");
        Object object = this.monitor;
        synchronized (object) {
            this.retryNumbers = retryNumbers;
            this.waitTime = waitTime;
            this.notificationLock = notificationLock;
        }
    }

    public RetryTemplate(Object notificationLock) {
        this(3, 1000L, notificationLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(RetryCallback callback) {
        int retryNumbers;
        long waitTime;
        Assert.notNull((Object)callback, (String)"callback is required");
        Assert.notNull((Object)this.notificationLock, (String)"notificationLock is required");
        Object object = this.monitor;
        synchronized (object) {
            waitTime = this.waitTime;
            retryNumbers = this.retryNumbers;
        }
        int count = -1;
        Object object2 = this.notificationLock;
        synchronized (object2) {
            do {
                Object result;
                if (callback.isComplete(result = callback.doWithRetry())) {
                    return result;
                }
                if (waitTime > 0L) {
                    try {
                        this.notificationLock.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException("Retry failed; interrupted while waiting", ex);
                    }
                }
                ++count;
                Object object3 = this.monitor;
                synchronized (object3) {
                    if (waitTime != this.waitTime || retryNumbers != this.retryNumbers) {
                        count = -1;
                        waitTime = this.waitTime;
                        retryNumbers = this.retryNumbers;
                    }
                }
            } while (count < retryNumbers);
        }
        return callback.doWithRetry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int retriesNumber, long waitTime) {
        Object object = this.monitor;
        synchronized (object) {
            this.retryNumbers = retriesNumber;
            this.waitTime = waitTime;
        }
        object = this.notificationLock;
        synchronized (object) {
            this.notificationLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRetryNumbers() {
        Object object = this.monitor;
        synchronized (object) {
            return this.retryNumbers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getWaitTime() {
        Object object = this.monitor;
        synchronized (object) {
            return this.waitTime;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RetryTemplate) {
            RetryTemplate oth = (RetryTemplate)other;
            return this.getWaitTime() == oth.getWaitTime() && this.getRetryNumbers() == oth.getRetryNumbers();
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }
}

