/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.manifestparser.Capability;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;

class ExportedPackageImpl
implements ExportedPackage {
    private final Felix m_felix;
    private final BundleImpl m_exportingBundle;
    private final IModule m_exportingModule;
    private final Capability m_export;
    private String m_toString = null;
    private String m_versionString = null;

    public ExportedPackageImpl(Felix felix, BundleImpl exporter, IModule module, Capability export) {
        this.m_felix = felix;
        this.m_exportingBundle = exporter;
        this.m_exportingModule = module;
        this.m_export = export;
    }

    public Bundle getExportingBundle() {
        if (this.m_exportingBundle.isStale()) {
            return null;
        }
        return this.m_exportingBundle;
    }

    public Bundle[] getImportingBundles() {
        if (this.m_exportingBundle.isStale()) {
            return null;
        }
        return this.m_felix.getImportingBundles(this);
    }

    public String getName() {
        return this.m_export.getPackageName();
    }

    public String getSpecificationVersion() {
        if (this.m_versionString == null) {
            this.m_versionString = this.m_export.getPackageVersion() == null ? Version.emptyVersion.toString() : this.m_export.getPackageVersion().toString();
        }
        return this.m_versionString;
    }

    public Version getVersion() {
        return this.m_export.getPackageVersion() == null ? Version.emptyVersion : this.m_export.getPackageVersion();
    }

    public boolean isRemovalPending() {
        return this.m_exportingBundle.isRemovalPending();
    }

    public String toString() {
        if (this.m_toString == null) {
            this.m_toString = this.m_export.getPackageName() + "; version=" + this.getSpecificationVersion();
        }
        return this.m_toString;
    }
}

