/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.compendium.UserManagerMBean;
import org.osgi.service.useradmin.Authorization;

public class OSGiAuthorization {
    private static final Log log = LogFactory.getLog(OSGiAuthorization.class);
    protected String name;
    protected String[] roles;
    public static final CompositeType AUTHORIZATION = OSGiAuthorization.createAuthorizationType();

    public OSGiAuthorization(CompositeData data) {
        if (data != null) {
            this.name = (String)data.get("UserName");
            this.roles = (String[])data.get("RoleNames");
        }
    }

    public OSGiAuthorization(Authorization authorization) {
        this(authorization.getName(), authorization.getRoles());
    }

    public OSGiAuthorization(String name, String[] roles) {
        this.name = name;
        this.roles = roles;
    }

    private static CompositeType createAuthorizationType() {
        String description = "An authorization object defines which roles has a user got";
        String[] itemNames = UserManagerMBean.AUTHORIZATION;
        String[] itemDescriptions = new String[]{"The user name for this authorization object", "The names of the roles encapsulated by this auth object"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, Util.STRING_ARRAY_TYPE};
        try {
            return new CompositeType("Authorization", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            log.error((Object)"cannot create authorization open data type", (Throwable)e);
            return null;
        }
    }

    public CompositeData asCompositeData() throws OpenDataException {
        Object[] itemValues = new Object[2];
        String[] itemNames = UserManagerMBean.AUTHORIZATION;
        itemValues[0] = this.name;
        itemValues[1] = this.roles;
        return new CompositeDataSupport(AUTHORIZATION, itemNames, itemValues);
    }

    public String getName() {
        return this.name;
    }

    public String[] getRoles() {
        return this.roles;
    }
}

