/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.osgi.framework.BundleEvent;
import org.osgi.jmx.core.BundleStateMBean;

public class OSGiBundleEvent {
    public static final CompositeType BUNDLE_EVENT = OSGiBundleEvent.createBundleEventType();
    private long bundleId;
    private int eventType;
    private String location;
    private String symbolicName;

    public OSGiBundleEvent(BundleEvent event) {
        this(event.getBundle().getBundleId(), event.getBundle().getLocation(), event.getBundle().getSymbolicName(), event.getType());
    }

    public OSGiBundleEvent(CompositeData data) {
        this.bundleId = (Long)data.get("Identifier");
        this.location = (String)data.get("Location");
        this.symbolicName = (String)data.get("BundleSymbolicName");
        this.eventType = (Integer)data.get("Type");
    }

    public OSGiBundleEvent(long bundleId, String location, String symbolicName, int eventType) {
        this.bundleId = bundleId;
        this.location = location;
        this.symbolicName = symbolicName;
        this.eventType = eventType;
    }

    private static CompositeType createBundleEventType() {
        String description = "This type encapsulates OSGi bundle events";
        String[] itemNames = BundleStateMBean.BUNDLE_EVENT;
        OpenType[] itemTypes = new OpenType[4];
        String[] itemDescriptions = new String[4];
        itemTypes[0] = SimpleType.LONG;
        itemTypes[1] = SimpleType.STRING;
        itemTypes[2] = SimpleType.STRING;
        itemTypes[3] = SimpleType.INTEGER;
        itemDescriptions[0] = "The ID of the bundle that generated this event";
        itemDescriptions[1] = "The location of the bundle that generated this event";
        itemDescriptions[2] = "The symbolic name of the bundle that generated this event";
        itemDescriptions[3] = "The type of the event: {INSTALLED=1, STARTED=2, STOPPED=4, UPDATED=8, UNINSTALLED=16}";
        try {
            return new CompositeType("BundleEvent", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompositeData asCompositeData() {
        String[] itemNames = BundleStateMBean.BUNDLE_EVENT;
        Object[] itemValues = new Object[]{this.bundleId, this.location, this.symbolicName, this.eventType};
        try {
            return new CompositeDataSupport(BUNDLE_EVENT, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle event open data", e);
        }
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }
}

