/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.osgi.jmx.codec.OSGiUser;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.compendium.UserManagerMBean;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

public class OSGiGroup {
    protected OSGiUser user;
    protected String[] members;
    protected String[] requiredMembers;
    public final CompositeType GROUP = OSGiGroup.createGroupType();

    public OSGiGroup(Group group) {
        Role[] rm;
        this.user = new OSGiUser((User)group);
        Role[] m = group.getMembers();
        if (m != null) {
            this.members = new String[m.length];
            int i = 0;
            for (Role role : m) {
                this.members[i++] = role.getName();
            }
        } else {
            this.members = new String[0];
        }
        if ((rm = group.getRequiredMembers()) != null) {
            this.requiredMembers = new String[rm.length];
            int i = 0;
            for (Role role : rm) {
                this.requiredMembers[i++] = role.getName();
            }
        } else {
            this.requiredMembers = new String[0];
        }
    }

    public OSGiGroup(CompositeData data) {
        this.user = new OSGiUser((CompositeData)data.get("User"));
        this.members = (String[])data.get("Members");
        this.requiredMembers = (String[])data.get("RequiredMembers");
    }

    public CompositeData asCompositeData() throws OpenDataException {
        String[] itemNames = UserManagerMBean.GROUP;
        Object[] itemValues = new Object[]{this.user.asCompositeData(), this.members, this.requiredMembers};
        return new CompositeDataSupport(this.GROUP, itemNames, itemValues);
    }

    private static CompositeType createGroupType() {
        String description = "Mapping of org.osgi.service.useradmin.Group for remote management purposes. Group extends User which in turn extends Role";
        String[] itemNames = UserManagerMBean.GROUP;
        String[] itemDescriptions = new String[]{"The user object that is extended by this group object", "The members of this group", "The required members for this group"};
        OpenType[] itemTypes = new OpenType[]{OSGiUser.USER, Util.STRING_ARRAY_TYPE, Util.STRING_ARRAY_TYPE};
        try {
            return new CompositeType("Group", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OSGiUser getUser() {
        return this.user;
    }

    public String[] getMembers() {
        return this.members;
    }

    public String[] getRequiredMembers() {
        return this.requiredMembers;
    }
}

