/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import org.osgi.jmx.codec.OSGiProperties;
import org.osgi.jmx.compendium.UserManagerMBean;
import org.osgi.service.useradmin.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiRole {
    protected String name;
    protected int type;
    protected Hashtable<String, Object> properties;
    public static final CompositeType ROLE = OSGiRole.createRoleType();

    public OSGiRole(CompositeData data) {
        this.name = (String)data.get("Name");
        this.type = (Integer)data.get("Type");
        this.properties = OSGiProperties.propertiesFrom((TabularData)data.get("Properties"));
    }

    public OSGiRole(Role role) {
        this.name = role.getName();
        this.type = role.getType();
        this.properties = new Hashtable();
        Dictionary props = role.getProperties();
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.properties.put(key, props.get(key));
        }
    }

    private static CompositeType createRoleType() {
        String description = "Mapping of org.osgi.service.useradmin.Role for remote management purposes. User and Group extend Role";
        String[] RoleItemNames = UserManagerMBean.ROLE;
        String[] itemDescriptions = new String[]{"The name of the role. Can be either a group or a user", "An integer representing type of the role: {0=Role,1=user,2=group}", "A credentials list as defined by org.osgi.service.useradmin.Role"};
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, OSGiProperties.PROPERTY_TABLE};
        try {
            return new CompositeType("Role", description, RoleItemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompositeData asCompositeData() throws OpenDataException {
        Object[] itemValues = new Object[]{this.name, this.type, OSGiProperties.tableFrom(this.properties)};
        return new CompositeDataSupport(ROLE, UserManagerMBean.ROLE, itemValues);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

