/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import java.util.ArrayList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.core.ServiceStateMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiService {
    public static final CompositeType SERVICE = OSGiService.createServiceType();
    public static final TabularType SERVICE_TABLE = OSGiService.createServiceTableType();
    private long bundle;
    private long identifier;
    private String[] interfaces;
    private long[] usingBundles;

    public OSGiService(CompositeData data) {
        this((Long)data.get("Identifier"), (String[])data.get("objectClass"), (Long)data.get("BundleIdentifier"), Util.longArrayFrom((Long[])data.get("UsingBundles")));
    }

    public OSGiService(long identifier, String[] interfaces, long bundle, long[] usingBundles) {
        this.identifier = identifier;
        this.interfaces = interfaces;
        this.bundle = bundle;
        this.usingBundles = usingBundles;
    }

    public OSGiService(ServiceReference reference) {
        this((Long)reference.getProperty("service.id"), (String[])reference.getProperty("objectClass"), reference.getBundle().getBundleId(), Util.bundleIds(reference.getUsingBundles()));
    }

    public static TabularData tableFrom(ArrayList<OSGiService> services) {
        TabularDataSupport table = new TabularDataSupport(SERVICE_TABLE);
        for (OSGiService service : services) {
            table.put(service.asCompositeData());
        }
        return table;
    }

    private static TabularType createServiceTableType() {
        try {
            return new TabularType("Services", "The table of all services", SERVICE, new String[]{"Identifier"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form services table open data", e);
        }
    }

    private static CompositeType createServiceType() {
        String description = "This type encapsulates an OSGi service";
        String[] itemNames = ServiceStateMBean.SERVICE;
        OpenType[] itemTypes = new OpenType[itemNames.length];
        String[] itemDescriptions = new String[itemNames.length];
        itemTypes[0] = SimpleType.LONG;
        itemTypes[1] = Util.STRING_ARRAY_TYPE;
        itemTypes[2] = SimpleType.LONG;
        itemTypes[3] = Util.LONG_ARRAY_TYPE;
        itemDescriptions[0] = "The identifier of the service";
        itemDescriptions[1] = "The interfaces of the service";
        itemDescriptions[2] = "The id of the bundle the service belongs to";
        itemDescriptions[3] = "The bundles using the service";
        try {
            return new CompositeType("Service", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service open data", e);
        }
    }

    public CompositeData asCompositeData() {
        String[] itemNames = ServiceStateMBean.SERVICE;
        Object[] itemValues = new Object[]{this.identifier, this.interfaces, this.bundle, Util.LongArrayFrom(this.usingBundles)};
        try {
            return new CompositeDataSupport(SERVICE, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service open data", e);
        }
    }

    public long getBundle() {
        return this.bundle;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public long[] getUsingBundles() {
        return this.usingBundles;
    }
}

