/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceEvent;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.core.ServiceStateMBean;

public class OSGiServiceEvent {
    public static final CompositeType SERVICE_EVENT = OSGiServiceEvent.createServiceEventType();
    private static final Log log = LogFactory.getLog(OSGiServiceEvent.class);
    private long bundleId;
    private int eventType;
    private String[] interfaces;
    private String location;
    private long serviceId;

    public OSGiServiceEvent(CompositeData data) {
        this.serviceId = (Long)data.get("Identifier");
        this.bundleId = (Long)data.get("BundleIdentifier");
        this.location = (String)data.get("BundleLocation");
        this.interfaces = (String[])data.get("objectClass");
        this.eventType = (Integer)data.get("Type");
    }

    public OSGiServiceEvent(long serviceId, long bundleId, String location, String[] interfaces, int eventType) {
        this.serviceId = serviceId;
        this.bundleId = bundleId;
        this.location = location;
        this.interfaces = interfaces;
        this.eventType = eventType;
    }

    public OSGiServiceEvent(ServiceEvent event) {
        this((Long)event.getServiceReference().getProperty("service.id"), event.getServiceReference().getBundle().getBundleId(), event.getServiceReference().getBundle().getLocation(), (String[])event.getServiceReference().getProperty("objectClass"), event.getType());
    }

    private static CompositeType createServiceEventType() {
        String description = "This eventType encapsulates OSGi service events";
        String[] itemNames = ServiceStateMBean.SERVICE_EVENT;
        OpenType[] itemTypes = new OpenType[5];
        String[] itemDescriptions = new String[5];
        itemTypes[0] = SimpleType.LONG;
        itemTypes[1] = SimpleType.LONG;
        itemTypes[2] = SimpleType.STRING;
        itemTypes[3] = Util.STRING_ARRAY_TYPE;
        itemTypes[4] = SimpleType.INTEGER;
        itemDescriptions[0] = "The id of the bundle which registered the service";
        itemDescriptions[1] = "The id of the bundle which registered the service";
        itemDescriptions[2] = "The location of the bundle that registered the service";
        itemDescriptions[3] = "An string array containing the interfaces under which the service has been registered";
        itemDescriptions[4] = "The eventType of the event: {REGISTERED=1, MODIFIED=2 UNREGISTERING=3}";
        try {
            return new CompositeType("ServiceEvent", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            log.error((Object)"Unable to create ServiceEvent OpenData eventType", (Throwable)e);
            return null;
        }
    }

    public CompositeData asCompositeData() {
        String[] itemNames = ServiceStateMBean.SERVICE_EVENT;
        Object[] itemValues = new Object[]{this.serviceId, this.bundleId, this.location, this.interfaces, this.eventType};
        try {
            return new CompositeDataSupport(SERVICE_EVENT, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form service event open data", e);
        }
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public String getLocation() {
        return this.location;
    }

    public long getServiceId() {
        return this.serviceId;
    }
}

