/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.SimpleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static ArrayType LONG_ARRAY_TYPE;
    public static ArrayType STRING_ARRAY_TYPE;
    private static final Log log;

    public static long[] bundleIds(Bundle[] bundles) {
        if (bundles == null) {
            return new long[0];
        }
        long[] ids = new long[bundles.length];
        for (int i = 0; i < bundles.length; ++i) {
            ids[i] = bundles[i].getBundleId();
        }
        return ids;
    }

    public static long[] bundleIds(RequiredBundle[] bundles) {
        if (bundles == null) {
            return new long[0];
        }
        long[] ids = new long[bundles.length];
        for (int i = 0; i < bundles.length; ++i) {
            ids[i] = bundles[i].getBundle().getBundleId();
        }
        return ids;
    }

    public static long[] getBundlesRequiring(Bundle b, BundleContext bc, PackageAdmin admin) {
        Bundle[] all = bc.getBundles();
        ArrayList<Long> required = new ArrayList<Long>();
        for (Bundle anAll : all) {
            long[] requiring = Util.getBundleDependencies(anAll, admin);
            if (requiring == null) continue;
            for (long r : requiring) {
                if (r != b.getBundleId()) continue;
                required.add(anAll.getBundleId());
            }
        }
        long[] ids = new long[required.size()];
        for (int i = 0; i < required.size(); ++i) {
            ids[i] = (Long)required.get(i);
        }
        return ids;
    }

    public static String[] getBundleExportedPackages(Bundle b, PackageAdmin admin) {
        ArrayList<String> packages = new ArrayList<String>();
        ExportedPackage[] exportedPackages = admin.getExportedPackages(b);
        if (exportedPackages == null) {
            return new String[0];
        }
        for (ExportedPackage pkg : exportedPackages) {
            packages.add(Util.packageString(pkg));
        }
        return packages.toArray(new String[packages.size()]);
    }

    public static long[] getBundleFragments(Bundle b, PackageAdmin admin) {
        Bundle[] fragments = admin.getFragments(b);
        if (fragments == null) {
            return new long[0];
        }
        long[] ids = new long[fragments.length];
        for (int i = 0; i < fragments.length; ++i) {
            ids[i] = fragments[i].getBundleId();
        }
        return ids;
    }

    public static Map<String, String> getBundleHeaders(Bundle b) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        Dictionary h = b.getHeaders();
        Enumeration keys = h.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            headers.put(key, (String)h.get(key));
        }
        return headers;
    }

    public static String[] getBundleImportedPackages(Bundle b, BundleContext bc, PackageAdmin admin) {
        Bundle[] allBundles;
        ArrayList<String> imported = new ArrayList<String>();
        for (Bundle bundle : allBundles = bc.getBundles()) {
            ExportedPackage[] eps = admin.getExportedPackages(bundle);
            if (eps == null) continue;
            block1: for (ExportedPackage ep : eps) {
                Bundle[] imp = ep.getImportingBundles();
                if (imp == null) continue;
                for (Bundle b2 : imp) {
                    if (b2.getBundleId() != b.getBundleId()) continue;
                    imported.add(Util.packageString(ep));
                    continue block1;
                }
            }
        }
        if (imported.size() == 0) {
            return new String[0];
        }
        return imported.toArray(new String[imported.size()]);
    }

    public static long[] getBundleDependencies(Bundle bundle, PackageAdmin admin) {
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName == null) {
            return new long[0];
        }
        RequiredBundle[] required = admin.getRequiredBundles(symbolicName);
        if (required == null || required.length == 0) {
            return new long[0];
        }
        return Util.bundleIds(required);
    }

    public static String getBundleState(Bundle b) {
        switch (b.getState()) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "UNKNOWN";
    }

    public static RequiredBundle getRequiredBundle(Bundle bundle, BundleContext bc, PackageAdmin admin) {
        Bundle[] all;
        for (Bundle anAll : all = bc.getBundles()) {
            RequiredBundle[] requiring;
            String symbolicName = anAll.getSymbolicName();
            if (symbolicName == null || (requiring = admin.getRequiredBundles(symbolicName)) == null) continue;
            for (RequiredBundle r : requiring) {
                if (!r.getBundle().equals(bundle)) continue;
                return r;
            }
        }
        return null;
    }

    public static boolean isBundleFragment(Bundle bundle, PackageAdmin admin) {
        return admin.getBundleType(bundle) == 1;
    }

    public static boolean isBundlePersistentlyStarted(Bundle bundle, StartLevel sl) {
        return bundle.getBundleId() == 0L || sl.isBundlePersistentlyStarted(bundle);
    }

    public static boolean isBundleRequired(Bundle bundle, BundleContext bc, PackageAdmin admin) {
        return Util.getRequiredBundle(bundle, bc, admin) != null;
    }

    public static boolean isRequiredBundleRemovalPending(Bundle bundle, BundleContext bc, PackageAdmin admin) {
        RequiredBundle r = Util.getRequiredBundle(bundle, bc, admin);
        return r != null && r.isRemovalPending();
    }

    public static String packageString(ExportedPackage pkg) {
        return pkg.getName() + ";" + pkg.getVersion();
    }

    public static long[] serviceIds(ServiceReference[] refs) {
        if (refs == null) {
            return new long[0];
        }
        long[] ids = new long[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            ids[i] = (Long)refs[i].getProperty("service.id");
        }
        return ids;
    }

    public static Long[] LongArrayFrom(long[] array) {
        if (array == null) {
            return new Long[0];
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] longArrayFrom(Long[] array) {
        if (array == null) {
            return new long[0];
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    static {
        log = LogFactory.getLog(Util.class);
        try {
            LONG_ARRAY_TYPE = new ArrayType(1, SimpleType.LONG);
            STRING_ARRAY_TYPE = new ArrayType(1, SimpleType.STRING);
        }
        catch (OpenDataException e) {
            log.error((Object)"Cannot create array open data type", (Throwable)e);
        }
    }
}

