/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.admin.internal.commands;

import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.kernel.gshell.admin.Instance;
import org.apache.servicemix.kernel.gshell.admin.internal.commands.AdminCommandSupport;

public class ListCommand
extends AdminCommandSupport {
    @Option(name="-l", aliases={"--location"}, description="Display instances location")
    boolean location;

    protected Object doExecute() throws Exception {
        Instance[] instances = this.getAdminService().getInstances();
        if (this.location) {
            this.io.out.println("  Port   State       Pid  Location");
        } else {
            this.io.out.println("  Port   State       Pid  Name");
        }
        for (Instance instance : instances) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            String s = Integer.toString(instance.getPort());
            for (int i = s.length(); i < 5; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            sb.append("] [");
            String state = instance.getState();
            while (state.length() < "starting".length()) {
                state = state + " ";
            }
            sb.append(state);
            sb.append("] [");
            s = Integer.toString(instance.getPid());
            for (int i = s.length(); i < 5; ++i) {
                sb.append(' ');
            }
            sb.append(s);
            sb.append("] ");
            if (this.location) {
                sb.append(instance.getLocation());
            } else {
                sb.append(instance.getName());
            }
            this.io.out.println(sb.toString());
        }
        return CommandAction.Result.SUCCESS;
    }
}

