/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.ansi;

import org.apache.geronimo.gshell.ansi.Ansi;
import org.apache.geronimo.gshell.ansi.AnsiCode;

public class AnsiBuffer {
    private final StringBuilder buff = new StringBuilder();
    public Boolean ansiEnabled;
    public boolean autoClear;

    public AnsiBuffer(Boolean ansiEnabled, boolean autoClear) {
        this.ansiEnabled = ansiEnabled;
        this.autoClear = autoClear;
    }

    public AnsiBuffer() {
        this(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        try {
            String string = this.buff.toString();
            return string;
        }
        finally {
            if (this.autoClear) {
                this.clear();
            }
        }
    }

    public boolean isAnsiEnabled() {
        if (this.ansiEnabled == null) {
            this.ansiEnabled = Ansi.isEnabled();
        }
        return this.ansiEnabled;
    }

    public void clear() {
        this.buff.setLength(0);
    }

    public int size() {
        return this.buff.length();
    }

    public AnsiBuffer append(String text) {
        this.buff.append(text);
        return this;
    }

    public AnsiBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public AnsiBuffer attrib(AnsiCode code) {
        if (this.isAnsiEnabled()) {
            this.buff.append(AnsiCode.attrib(code));
        }
        return this;
    }

    public AnsiBuffer attrib(String text, AnsiCode code) {
        assert (text != null);
        if (this.isAnsiEnabled()) {
            this.buff.append(AnsiCode.attrib(code)).append(text).append(AnsiCode.attrib(AnsiCode.OFF));
        } else {
            this.buff.append(text);
        }
        return this;
    }

    public AnsiBuffer attrib(String text, String codeName) {
        return this.attrib(text, AnsiCode.valueOf(codeName.toUpperCase()));
    }
}

